/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.R;
import com.stripe.android.view.DateUtils;
import com.stripe.android.view.StripeEditText;

public class ExpiryDateEditText
extends StripeEditText {
    private static final int INVALID_INPUT = -1;
    private static final int MAX_INPUT_LENGTH = 5;
    @Nullable
    private ExpiryDateEditListener mExpiryDateEditListener;
    private boolean mIsDateValid;

    public ExpiryDateEditText(@NonNull Context context) {
        super(context);
        this.listenForTextChanges();
    }

    public ExpiryDateEditText(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.listenForTextChanges();
    }

    public ExpiryDateEditText(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.listenForTextChanges();
    }

    public void onInitializeAccessibilityNodeInfo(@NonNull AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        String accLabel = this.getResources().getString(R.string.acc_label_expiry_date_node, new Object[]{this.getText()});
        info.setText((CharSequence)accLabel);
    }

    public boolean isDateValid() {
        return this.mIsDateValid;
    }

    @Nullable
    @Size(value=2L)
    public int[] getValidDateFields() {
        if (!this.mIsDateValid) {
            return null;
        }
        int[] monthYearPair = new int[2];
        String rawNumericInput = this.getText().toString().replaceAll("/", "");
        String[] dateFields = DateUtils.separateDateStringParts(rawNumericInput);
        try {
            int fourDigitYear;
            monthYearPair[0] = Integer.parseInt(dateFields[0]);
            int twoDigitYear = Integer.parseInt(dateFields[1]);
            monthYearPair[1] = fourDigitYear = DateUtils.convertTwoDigitYearToFour(twoDigitYear);
        }
        catch (NumberFormatException numEx) {
            return null;
        }
        return monthYearPair;
    }

    public void setExpiryDateEditListener(@Nullable ExpiryDateEditListener expiryDateEditListener) {
        this.mExpiryDateEditListener = expiryDateEditListener;
    }

    private void listenForTextChanges() {
        this.addTextChangedListener(new TextWatcher(){
            boolean ignoreChanges = false;
            int latestChangeStart;
            int latestInsertionSize;
            String[] parts = new String[2];

            public void beforeTextChanged(CharSequence s, int start2, int count, int after) {
                if (this.ignoreChanges) {
                    return;
                }
                this.latestChangeStart = start2;
                this.latestInsertionSize = after;
            }

            public void onTextChanged(CharSequence s, int start2, int before, int count) {
                if (this.ignoreChanges) {
                    return;
                }
                boolean inErrorState = false;
                String rawNumericInput = s.toString().replaceAll("/", "");
                if (rawNumericInput.length() == 1 && this.latestChangeStart == 0 && this.latestInsertionSize == 1) {
                    char first = rawNumericInput.charAt(0);
                    if (first != '0' && first != '1') {
                        rawNumericInput = "0" + rawNumericInput;
                        ++this.latestInsertionSize;
                    }
                } else if (rawNumericInput.length() == 2 && this.latestChangeStart == 2 && this.latestInsertionSize == 0) {
                    rawNumericInput = rawNumericInput.substring(0, 1);
                }
                this.parts = DateUtils.separateDateStringParts(rawNumericInput);
                if (!DateUtils.isValidMonth(this.parts[0])) {
                    inErrorState = true;
                }
                StringBuilder formattedDateBuilder = new StringBuilder();
                formattedDateBuilder.append(this.parts[0]);
                if (this.parts[0].length() == 2 && this.latestInsertionSize > 0 && !inErrorState || rawNumericInput.length() > 2) {
                    formattedDateBuilder.append("/");
                }
                formattedDateBuilder.append(this.parts[1]);
                String formattedDate = formattedDateBuilder.toString();
                int cursorPosition = ExpiryDateEditText.this.updateSelectionIndex(formattedDate.length(), this.latestChangeStart, this.latestInsertionSize, 5);
                this.ignoreChanges = true;
                ExpiryDateEditText.this.setText(formattedDate);
                ExpiryDateEditText.this.setSelection(cursorPosition);
                this.ignoreChanges = false;
            }

            public void afterTextChanged(Editable s) {
                boolean shouldShowError = false;
                if (this.parts[0].length() == 2 && !DateUtils.isValidMonth(this.parts[0])) {
                    shouldShowError = true;
                }
                if (this.parts[0].length() == 2 && this.parts[1].length() == 2) {
                    boolean wasComplete = ExpiryDateEditText.this.mIsDateValid;
                    ExpiryDateEditText.this.updateInputValues(this.parts);
                    boolean bl = shouldShowError = !ExpiryDateEditText.this.mIsDateValid;
                    if (!wasComplete && ExpiryDateEditText.this.mIsDateValid && ExpiryDateEditText.this.mExpiryDateEditListener != null) {
                        ExpiryDateEditText.this.mExpiryDateEditListener.onExpiryDateComplete();
                    }
                } else {
                    ExpiryDateEditText.this.mIsDateValid = false;
                }
                ExpiryDateEditText.this.setShouldShowError(shouldShowError);
            }
        });
    }

    @VisibleForTesting
    int updateSelectionIndex(int newLength, int editActionStart, int editActionAddition, int maxInputLength) {
        int gapsJumped = 0;
        boolean skipBack = false;
        if (editActionStart <= 2 && editActionStart + editActionAddition >= 2) {
            gapsJumped = 1;
        }
        if (editActionAddition == 0 && editActionStart == 3) {
            skipBack = true;
        }
        int newPosition = editActionStart + editActionAddition + gapsJumped;
        if (skipBack && newPosition > 0) {
            --newPosition;
        }
        int untruncatedPosition = newPosition <= newLength ? newPosition : newLength;
        return Math.min(maxInputLength, untruncatedPosition);
    }

    private void updateInputValues(@NonNull @Size(value=2L) String[] parts) {
        int inputYear;
        int inputMonth;
        if (parts[0].length() != 2) {
            inputMonth = -1;
        } else {
            try {
                inputMonth = Integer.parseInt(parts[0]);
            }
            catch (NumberFormatException numEx) {
                inputMonth = -1;
            }
        }
        if (parts[1].length() != 2) {
            inputYear = -1;
        } else {
            try {
                inputYear = DateUtils.convertTwoDigitYearToFour(Integer.parseInt(parts[1]));
            }
            catch (NumberFormatException numEx) {
                inputYear = -1;
            }
        }
        this.mIsDateValid = DateUtils.isExpiryDataValid(inputMonth, inputYear);
    }

    static interface ExpiryDateEditListener {
        public void onExpiryDateComplete();
    }
}

