/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.stripe.android.R;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.PaymentMethodsAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 *2\u00020\u0001:\u0002*+B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J@\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0016J \u0010\"\u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u0016H\u0016J\u0018\u0010$\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\fH\u0016J(\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/stripe/android/view/PaymentMethodSwipeCallback;", "Landroidx/recyclerview/widget/ItemTouchHelper$SimpleCallback;", "context", "Landroid/content/Context;", "adapter", "Lcom/stripe/android/view/PaymentMethodsAdapter;", "listener", "Lcom/stripe/android/view/PaymentMethodSwipeCallback$Listener;", "(Landroid/content/Context;Lcom/stripe/android/view/PaymentMethodsAdapter;Lcom/stripe/android/view/PaymentMethodSwipeCallback$Listener;)V", "background", "Landroid/graphics/drawable/ColorDrawable;", "iconStartOffset", "", "itemViewStartPadding", "swipeStartColor", "swipeThresholdColor", "trashIcon", "Landroid/graphics/drawable/Drawable;", "getSwipeDirs", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "viewHolder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "getSwipeThreshold", "", "onChildDraw", "", "canvas", "Landroid/graphics/Canvas;", "dX", "dY", "actionState", "isCurrentlyActive", "", "onMove", "target", "onSwiped", "direction", "updateSwipedPaymentMethod", "itemView", "Landroid/view/View;", "transitionFraction", "Companion", "Listener", "stripe_release"})
public final class PaymentMethodSwipeCallback
extends ItemTouchHelper.SimpleCallback {
    private final Drawable trashIcon;
    private final int swipeStartColor;
    private final int swipeThresholdColor;
    private final ColorDrawable background;
    private final int itemViewStartPadding;
    private final int iconStartOffset;
    private final PaymentMethodsAdapter adapter;
    private final Listener listener;
    private static final float START_TRANSITION_THRESHOLD = 0.25f;
    private static final float END_TRANSITION_THRESHOLD = 0.5f;
    public static final Companion Companion = new Companion(null);

    public boolean onMove(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder, @NotNull RecyclerView.ViewHolder target) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        return true;
    }

    public void onSwiped(@NotNull RecyclerView.ViewHolder viewHolder, int direction) {
        Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
        PaymentMethod paymentMethod = this.adapter.getPaymentMethods().get(viewHolder.getAdapterPosition());
        Intrinsics.checkExpressionValueIsNotNull((Object)paymentMethod, (String)"adapter.paymentMethods[viewHolder.adapterPosition]");
        PaymentMethod paymentMethod2 = paymentMethod;
        this.listener.onSwiped(paymentMethod2);
    }

    public int getSwipeDirs(@NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder) {
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
        return viewHolder instanceof PaymentMethodsAdapter.PaymentMethodViewHolder ? super.getSwipeDirs(recyclerView, viewHolder) : 0;
    }

    public void onChildDraw(@NotNull Canvas canvas, @NotNull RecyclerView recyclerView, @NotNull RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)recyclerView, (String)"recyclerView");
        Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
        super.onChildDraw(canvas, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
        if (viewHolder instanceof PaymentMethodsAdapter.PaymentMethodViewHolder) {
            View view = viewHolder.itemView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"viewHolder.itemView");
            View itemView = view;
            float startTransition = (float)itemView.getWidth() * 0.25f;
            float endTransition = (float)itemView.getWidth() * 0.5f;
            float transitionFraction = dX < startTransition ? 0.0f : (dX >= endTransition ? 1.0f : (dX - startTransition) / (endTransition - startTransition));
            this.updateSwipedPaymentMethod(itemView, (int)dX, transitionFraction, canvas);
        }
    }

    public float getSwipeThreshold(@NotNull RecyclerView.ViewHolder viewHolder) {
        Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
        return 0.5f;
    }

    private final void updateSwipedPaymentMethod(View itemView, int dX, float transitionFraction, Canvas canvas) {
        int iconTop = itemView.getTop() + (itemView.getHeight() - this.trashIcon.getIntrinsicHeight()) / 2;
        int iconBottom = iconTop + this.trashIcon.getIntrinsicHeight();
        if (dX > 0) {
            int iconLeft = itemView.getLeft() + this.iconStartOffset;
            int iconRight = iconLeft + this.trashIcon.getIntrinsicWidth();
            if (dX > iconRight) {
                this.trashIcon.setBounds(iconLeft, iconTop, iconRight, iconBottom);
            } else {
                this.trashIcon.setBounds(0, 0, 0, 0);
            }
            this.background.setBounds(itemView.getLeft(), itemView.getTop(), itemView.getLeft() + dX + this.itemViewStartPadding, itemView.getBottom());
            this.background.setColor(transitionFraction <= 0.0f ? this.swipeStartColor : (transitionFraction >= 1.0f ? this.swipeThresholdColor : Companion.calculateTransitionColor$stripe_release(transitionFraction, this.swipeStartColor, this.swipeThresholdColor)));
        } else {
            this.trashIcon.setBounds(0, 0, 0, 0);
            this.background.setBounds(0, 0, 0, 0);
        }
        this.background.draw(canvas);
        this.trashIcon.draw(canvas);
    }

    public PaymentMethodSwipeCallback(@NotNull Context context, @NotNull PaymentMethodsAdapter adapter, @NotNull Listener listener) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)adapter), (String)"adapter");
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        super(0, 8);
        this.adapter = adapter;
        this.listener = listener;
        Drawable drawable2 = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_trash);
        if (drawable2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable2, (String)"ContextCompat.getDrawabl\u2026t, R.drawable.ic_trash)!!");
        this.trashIcon = drawable2;
        this.swipeStartColor = ContextCompat.getColor((Context)context, (int)R.color.stripe_swipe_start_payment_method);
        this.swipeThresholdColor = ContextCompat.getColor((Context)context, (int)R.color.stripe_swipe_threshold_payment_method);
        this.background = new ColorDrawable(this.swipeStartColor);
        this.itemViewStartPadding = this.trashIcon.getIntrinsicWidth() / 2;
        this.iconStartOffset = context.getResources().getDimensionPixelSize(R.dimen.stripe_list_row_start_padding);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/view/PaymentMethodSwipeCallback$Listener;", "", "onSwiped", "", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "stripe_release"})
    public static interface Listener {
        public void onSwiped(@NotNull PaymentMethod var1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00042\b\b\u0001\u0010\t\u001a\u00020\u00072\b\b\u0001\u0010\n\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/stripe/android/view/PaymentMethodSwipeCallback$Companion;", "", "()V", "END_TRANSITION_THRESHOLD", "", "START_TRANSITION_THRESHOLD", "calculateTransitionColor", "", "fraction", "startValue", "endValue", "calculateTransitionColor$stripe_release", "stripe_release"})
    public static final class Companion {
        public final int calculateTransitionColor$stripe_release(float fraction, @ColorInt int startValue, @ColorInt int endValue) {
            int startAlpha = Color.alpha((int)startValue);
            int startRed = Color.red((int)startValue);
            int startGreen = Color.green((int)startValue);
            int startBlue = Color.blue((int)startValue);
            float deltaAlpha = (float)(Color.alpha((int)endValue) - startAlpha) * fraction;
            float deltaRed = (float)(Color.red((int)endValue) - startRed) * fraction;
            float deltaGreen = (float)(Color.green((int)endValue) - startGreen) * fraction;
            float deltaBlue = (float)(Color.blue((int)endValue) - startBlue) * fraction;
            return Color.argb((int)((int)((float)startAlpha + deltaAlpha)), (int)((int)((float)startRed + deltaRed)), (int)((int)((float)startGreen + deltaGreen)), (int)((int)((float)startBlue + deltaBlue)));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

