/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.StringRes;
import androidx.core.text.util.LinkifyCompat;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.CustomerSession;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.R;
import com.stripe.android.Stripe;
import com.stripe.android.StripeError;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.view.AddPaymentMethodActivity$WhenMappings;
import com.stripe.android.view.AddPaymentMethodActivityStarter;
import com.stripe.android.view.AddPaymentMethodCardView;
import com.stripe.android.view.AddPaymentMethodFpxView;
import com.stripe.android.view.AddPaymentMethodView;
import com.stripe.android.view.StripeActivity;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 (2\u00020\u0001:\u0004'()*B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010 \u001a\u00020\u0015J\b\u0010!\u001a\u00020\u0015H\u0016J\u0012\u0010\"\u001a\u00020\u00152\b\u0010#\u001a\u0004\u0018\u00010$H\u0014J\u0010\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\bH\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006+"}, d2={"Lcom/stripe/android/view/AddPaymentMethodActivity;", "Lcom/stripe/android/view/StripeActivity;", "()V", "addPaymentMethodView", "Lcom/stripe/android/view/AddPaymentMethodView;", "paymentMethodType", "Lcom/stripe/android/model/PaymentMethod$Type;", "shouldAttachToCustomer", "", "startedFromPaymentSession", "stripe", "Lcom/stripe/android/Stripe;", "titleStringRes", "", "getTitleStringRes", "()I", "windowToken", "Landroid/os/IBinder;", "getWindowToken$stripe_release", "()Landroid/os/IBinder;", "attachPaymentMethodToCustomer", "", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "configureView", "args", "Lcom/stripe/android/view/AddPaymentMethodActivityStarter$Args;", "createPaymentMethod", "params", "Lcom/stripe/android/model/PaymentMethodCreateParams;", "createPaymentMethodView", "finishWithPaymentMethod", "initCustomerSessionTokens", "onActionSave", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "setCommunicatingProgress", "communicating", "ActivityPaymentMethodCallback", "Companion", "PaymentMethodCallbackImpl", "PaymentMethodRetrievalListenerImpl", "stripe_release"})
public class AddPaymentMethodActivity
extends StripeActivity {
    private Stripe stripe;
    private AddPaymentMethodView addPaymentMethodView;
    private PaymentMethod.Type paymentMethodType;
    private boolean startedFromPaymentSession;
    private boolean shouldAttachToCustomer;
    @NotNull
    public static final String TOKEN_ADD_PAYMENT_METHOD_ACTIVITY = "AddPaymentMethodActivity";
    @NotNull
    public static final String EXTRA_NEW_PAYMENT_METHOD = "new_payment_method";
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    /*
     * Enabled aggressive block sorting
     */
    @StringRes
    private final int getTitleStringRes() {
        String string2;
        PaymentMethod.Type type = this.paymentMethodType;
        if (type != null) {
            switch (AddPaymentMethodActivity$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    int n = R.string.title_add_a_card;
                    return n;
                }
                case 2: {
                    int n = R.string.title_bank_account;
                    return n;
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder().append("Unsupported Payment Method type: ");
        PaymentMethod.Type type2 = this.paymentMethodType;
        if (type2 != null) {
            string2 = type2.code;
            throw (Throwable)new IllegalArgumentException(stringBuilder.append(string2).toString());
        }
        string2 = null;
        throw (Throwable)new IllegalArgumentException(stringBuilder.append(string2).toString());
    }

    @Nullable
    public IBinder getWindowToken$stripe_release() {
        return this.getViewStub().getWindowToken();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"intent");
        AddPaymentMethodActivityStarter.Args args = AddPaymentMethodActivityStarter.Args.Companion.create(intent);
        PaymentConfiguration paymentConfiguration = args.getPaymentConfiguration$stripe_release();
        if (paymentConfiguration == null) {
            PaymentConfiguration paymentConfiguration2 = PaymentConfiguration.getInstance((Context)this);
            paymentConfiguration = paymentConfiguration2;
            Intrinsics.checkExpressionValueIsNotNull((Object)paymentConfiguration2, (String)"PaymentConfiguration.getInstance(this)");
        }
        PaymentConfiguration paymentConfiguration3 = paymentConfiguration;
        Context context = this.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"applicationContext");
        String string2 = paymentConfiguration3.getPublishableKey();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"paymentConfiguration.publishableKey");
        this.stripe = new Stripe(context, string2, null, false, 12, null);
        this.paymentMethodType = args.getPaymentMethodType$stripe_release();
        this.configureView(args);
        PaymentMethod.Type type = this.paymentMethodType;
        this.shouldAttachToCustomer = type != null && type.isReusable && args.getShouldAttachToCustomer$stripe_release();
        this.startedFromPaymentSession = args.isPaymentSessionActive$stripe_release();
        if (this.shouldAttachToCustomer && args.getShouldInitCustomerSessionTokens$stripe_release()) {
            this.initCustomerSessionTokens();
        }
    }

    private final void configureView(AddPaymentMethodActivityStarter.Args args) {
        this.getViewStub().setLayoutResource(R.layout.add_payment_method_layout);
        View view = this.getViewStub().inflate();
        if (view == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
        }
        ViewGroup scrollView = (ViewGroup)view;
        ViewGroup contentRoot = (ViewGroup)scrollView.findViewById(R.id.stripe_add_payment_method_content_root);
        this.addPaymentMethodView = this.createPaymentMethodView(args);
        contentRoot.addView((View)this.addPaymentMethodView);
        if (args.getAddPaymentMethodFooter$stripe_release() > 0) {
            View footerView = this.getLayoutInflater().inflate(args.getAddPaymentMethodFooter$stripe_release(), contentRoot, false);
            if (footerView instanceof TextView) {
                LinkifyCompat.addLinks((TextView)((TextView)footerView), (int)15);
                ((TextView)footerView).setMovementMethod(LinkMovementMethod.getInstance());
            }
            contentRoot.addView(footerView);
        }
        this.setTitle(this.getTitleStringRes());
        if (this.paymentMethodType == PaymentMethod.Type.Card) {
            this.getWindow().setSoftInputMode(4);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final AddPaymentMethodView createPaymentMethodView(AddPaymentMethodActivityStarter.Args args) {
        String string2;
        PaymentMethod.Type type = this.paymentMethodType;
        if (type != null) {
            switch (AddPaymentMethodActivity$WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
                case 1: {
                    AddPaymentMethodView addPaymentMethodView = AddPaymentMethodCardView.Companion.create((Context)this, args.getShouldRequirePostalCode$stripe_release());
                    return addPaymentMethodView;
                }
                case 2: {
                    AddPaymentMethodView addPaymentMethodView = AddPaymentMethodFpxView.Companion.create((Context)this);
                    return addPaymentMethodView;
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder().append("Unsupported Payment Method type: ");
        PaymentMethod.Type type2 = this.paymentMethodType;
        if (type2 != null) {
            string2 = type2.code;
            throw (Throwable)new IllegalArgumentException(stringBuilder.append(string2).toString());
        }
        string2 = null;
        throw (Throwable)new IllegalArgumentException(stringBuilder.append(string2).toString());
    }

    public final void initCustomerSessionTokens() {
        CustomerSession customerSession = CustomerSession.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)customerSession, (String)"CustomerSession.getInstance()");
        CustomerSession customerSession2 = customerSession;
        customerSession2.addProductUsageTokenIfValid(TOKEN_ADD_PAYMENT_METHOD_ACTIVITY);
        if (this.startedFromPaymentSession) {
            customerSession2.addProductUsageTokenIfValid("PaymentSession");
        }
    }

    @Override
    public void onActionSave() {
        Stripe stripe = this.stripe;
        if (stripe == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"stripe");
        }
        AddPaymentMethodView addPaymentMethodView = this.addPaymentMethodView;
        this.createPaymentMethod(stripe, addPaymentMethodView != null ? addPaymentMethodView.getCreateParams() : null);
    }

    public final void createPaymentMethod(@NotNull Stripe stripe, @Nullable PaymentMethodCreateParams params) {
        Intrinsics.checkParameterIsNotNull((Object)stripe, (String)"stripe");
        if (params == null) {
            return;
        }
        this.setCommunicatingProgress(true);
        stripe.createPaymentMethod(params, new PaymentMethodCallbackImpl(this, this.shouldAttachToCustomer));
    }

    private final void attachPaymentMethodToCustomer(PaymentMethod paymentMethod) {
        String string2 = paymentMethod.id;
        CustomerSession customerSession = CustomerSession.getInstance();
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (string2 == null) {
            boolean bl4 = false;
            String string3 = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        String string4 = string2;
        customerSession.attachPaymentMethod(string4, new PaymentMethodRetrievalListenerImpl(this));
    }

    private final void finishWithPaymentMethod(PaymentMethod paymentMethod) {
        this.setCommunicatingProgress(false);
        this.setResult(-1, new Intent().putExtra(EXTRA_NEW_PAYMENT_METHOD, (Parcelable)paymentMethod).putExtras(new AddPaymentMethodActivityStarter.Result(paymentMethod).toBundle()));
        this.finish();
    }

    @Override
    protected void setCommunicatingProgress(boolean communicating) {
        block0: {
            super.setCommunicatingProgress(communicating);
            AddPaymentMethodView addPaymentMethodView = this.addPaymentMethodView;
            if (addPaymentMethodView == null) break block0;
            addPaymentMethodView.setCommunicatingProgress(communicating);
        }
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/view/AddPaymentMethodActivity$PaymentMethodCallbackImpl;", "Lcom/stripe/android/view/AddPaymentMethodActivity$ActivityPaymentMethodCallback;", "Lcom/stripe/android/view/AddPaymentMethodActivity;", "activity", "updatesCustomer", "", "(Lcom/stripe/android/view/AddPaymentMethodActivity;Z)V", "onError", "", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onSuccess", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "stripe_release"})
    private static final class PaymentMethodCallbackImpl
    extends ActivityPaymentMethodCallback<AddPaymentMethodActivity> {
        private final boolean updatesCustomer;

        @Override
        public void onError(@NotNull Exception error) {
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                AddPaymentMethodActivity addPaymentMethodActivity = (AddPaymentMethodActivity)((Object)this.getActivity());
                if (addPaymentMethodActivity == null) break block1;
                AddPaymentMethodActivity addPaymentMethodActivity2 = addPaymentMethodActivity;
                boolean bl = false;
                boolean bl2 = false;
                AddPaymentMethodActivity activity = addPaymentMethodActivity2;
                boolean bl3 = false;
                activity.setCommunicatingProgress(false);
                String string2 = error.getLocalizedMessage();
                AddPaymentMethodActivity addPaymentMethodActivity3 = activity;
                boolean bl4 = false;
                String string3 = string2;
                if (string3 == null) {
                    string3 = "";
                }
                String string4 = string3;
                addPaymentMethodActivity3.showError(string4);
            }
        }

        @Override
        public void onSuccess(@NotNull PaymentMethod paymentMethod) {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
                AddPaymentMethodActivity addPaymentMethodActivity = (AddPaymentMethodActivity)((Object)this.getActivity());
                if (addPaymentMethodActivity == null) break block2;
                AddPaymentMethodActivity addPaymentMethodActivity2 = addPaymentMethodActivity;
                boolean bl = false;
                boolean bl2 = false;
                AddPaymentMethodActivity activity = addPaymentMethodActivity2;
                boolean bl3 = false;
                if (this.updatesCustomer) {
                    activity.attachPaymentMethodToCustomer(paymentMethod);
                } else {
                    activity.finishWithPaymentMethod(paymentMethod);
                }
            }
        }

        public PaymentMethodCallbackImpl(@NotNull AddPaymentMethodActivity activity, boolean updatesCustomer) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)activity), (String)"activity");
            super((Activity)activity);
            this.updatesCustomer = updatesCustomer;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/view/AddPaymentMethodActivity$PaymentMethodRetrievalListenerImpl;", "Lcom/stripe/android/CustomerSession$ActivityPaymentMethodRetrievalListener;", "Lcom/stripe/android/view/AddPaymentMethodActivity;", "activity", "(Lcom/stripe/android/view/AddPaymentMethodActivity;)V", "onError", "", "errorCode", "", "errorMessage", "", "stripeError", "Lcom/stripe/android/StripeError;", "onPaymentMethodRetrieved", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "stripe_release"})
    private static final class PaymentMethodRetrievalListenerImpl
    extends CustomerSession.ActivityPaymentMethodRetrievalListener<AddPaymentMethodActivity> {
        @Override
        public void onPaymentMethodRetrieved(@NotNull PaymentMethod paymentMethod) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)paymentMethod, (String)"paymentMethod");
                AddPaymentMethodActivity addPaymentMethodActivity = (AddPaymentMethodActivity)((Object)this.getActivity());
                if (addPaymentMethodActivity == null) break block0;
                addPaymentMethodActivity.finishWithPaymentMethod(paymentMethod);
            }
        }

        @Override
        public void onError(int errorCode, @NotNull String errorMessage, @Nullable StripeError stripeError) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
                AddPaymentMethodActivity addPaymentMethodActivity = (AddPaymentMethodActivity)((Object)this.getActivity());
                if (addPaymentMethodActivity == null) break block0;
                addPaymentMethodActivity.setCommunicatingProgress(false);
            }
        }

        public PaymentMethodRetrievalListenerImpl(@NotNull AddPaymentMethodActivity activity) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)activity), (String)"activity");
            super((Activity)activity);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u0003B\u000f\b\u0000\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0005\u001a\u0004\u0018\u00018\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/view/AddPaymentMethodActivity$ActivityPaymentMethodCallback;", "A", "Landroid/app/Activity;", "Lcom/stripe/android/ApiResultCallback;", "Lcom/stripe/android/model/PaymentMethod;", "activity", "(Landroid/app/Activity;)V", "getActivity", "()Landroid/app/Activity;", "activityRef", "Ljava/lang/ref/WeakReference;", "stripe_release"})
    private static abstract class ActivityPaymentMethodCallback<A extends Activity>
    implements ApiResultCallback<PaymentMethod> {
        private final WeakReference<A> activityRef;

        @Nullable
        public final A getActivity() {
            return (A)((Activity)this.activityRef.get());
        }

        public ActivityPaymentMethodCallback(@NotNull A activity) {
            Intrinsics.checkParameterIsNotNull(activity, (String)"activity");
            this.activityRef = new WeakReference<A>(activity);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/view/AddPaymentMethodActivity$Companion;", "", "()V", "EXTRA_NEW_PAYMENT_METHOD", "", "EXTRA_NEW_PAYMENT_METHOD$annotations", "TOKEN_ADD_PAYMENT_METHOD_ACTIVITY", "stripe_release"})
    public static final class Companion {
        @Deprecated(message="use {@link AddPaymentMethodActivityStarter.Result}")
        public static /* synthetic */ void EXTRA_NEW_PAYMENT_METHOD$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

