/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import com.stripe.android.model.Card;
import com.stripe.android.model.Source;
import com.stripe.android.model.SourceCardData;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.model.StripePaymentSource;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u000f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0000H\u0002R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/model/CustomerSource;", "Lcom/stripe/android/model/StripeModel;", "Lcom/stripe/android/model/StripePaymentSource;", "stripePaymentSource", "(Lcom/stripe/android/model/StripePaymentSource;)V", "id", "", "getId", "()Ljava/lang/String;", "sourceType", "getSourceType", "tokenizationMethod", "getTokenizationMethod", "asCard", "Lcom/stripe/android/model/Card;", "asSource", "Lcom/stripe/android/model/Source;", "equals", "", "other", "", "hashCode", "", "typedEquals", "customerSource", "Companion", "stripe_release"})
public final class CustomerSource
extends StripeModel
implements StripePaymentSource {
    private final StripePaymentSource stripePaymentSource;
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public String getId() {
        return this.stripePaymentSource.getId();
    }

    @Nullable
    public final String getTokenizationMethod() {
        String string2;
        Source paymentAsSource = this.asSource();
        Card paymentAsCard = this.asCard();
        if (paymentAsSource != null && Intrinsics.areEqual((Object)"card", (Object)paymentAsSource.getType())) {
            SourceCardData cardData;
            SourceCardData sourceCardData = cardData = (SourceCardData)paymentAsSource.getSourceTypeModel();
            string2 = sourceCardData != null ? sourceCardData.getTokenizationMethod() : null;
        } else {
            Card card = paymentAsCard;
            string2 = card != null ? card.getTokenizationMethod() : null;
        }
        return string2;
    }

    @NotNull
    public final String getSourceType() {
        String string2;
        StripePaymentSource stripePaymentSource = this.stripePaymentSource;
        if (stripePaymentSource instanceof Card) {
            string2 = "card";
        } else if (stripePaymentSource instanceof Source) {
            String string3 = ((Source)this.stripePaymentSource).getType();
            string2 = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"stripePaymentSource.type");
        } else {
            string2 = "unknown";
        }
        return string2;
    }

    @Nullable
    public final Source asSource() {
        return this.stripePaymentSource instanceof Source ? (Source)this.stripePaymentSource : null;
    }

    @Nullable
    public final Card asCard() {
        return this.stripePaymentSource instanceof Card ? (Card)this.stripePaymentSource : null;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CustomerSource ? this.typedEquals((CustomerSource)other) : false;
    }

    private final boolean typedEquals(CustomerSource customerSource) {
        return Intrinsics.areEqual((Object)this.stripePaymentSource, (Object)customerSource.stripePaymentSource);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.stripePaymentSource);
    }

    private CustomerSource(StripePaymentSource stripePaymentSource) {
        this.stripePaymentSource = stripePaymentSource;
    }

    public /* synthetic */ CustomerSource(StripePaymentSource stripePaymentSource, DefaultConstructorMarker $constructor_marker) {
        this(stripePaymentSource);
    }

    @JvmStatic
    @Nullable
    public static final CustomerSource fromJson(@Nullable JSONObject jsonObject) {
        return Companion.fromJson(jsonObject);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/model/CustomerSource$Companion;", "", "()V", "fromJson", "Lcom/stripe/android/model/CustomerSource;", "jsonObject", "Lorg/json/JSONObject;", "stripe_release"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @Nullable
        public final CustomerSource fromJson(@Nullable JSONObject jsonObject) {
            StripePaymentSource stripePaymentSource;
            block6: {
                if (jsonObject == null) {
                    return null;
                }
                String string2 = StripeJsonUtils.optString(jsonObject, "object");
                if (string2 == null) return null;
                String string3 = string2;
                switch (string3.hashCode()) {
                    case -896505829: {
                        if (!string3.equals("source")) return null;
                        break;
                    }
                    case 3046160: {
                        if (!string3.equals("card")) return null;
                        stripePaymentSource = Card.fromJson(jsonObject);
                        break block6;
                    }
                }
                stripePaymentSource = Source.fromJson(jsonObject);
                break block6;
                return null;
            }
            StripePaymentSource sourceObject = stripePaymentSource;
            if (sourceObject == null) {
                return null;
            }
            CustomerSource customerSource = new CustomerSource(sourceObject, null);
            return customerSource;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

