/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.ApiKeyValidator;
import com.stripe.android.ApiVersion;
import com.stripe.android.PaymentConfiguration;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public final class GooglePayConfig {
    @NonNull
    private final String mPublishableKey;
    @NonNull
    private final String mApiVersion;
    @Nullable
    private final String mConnectedAccountId;

    public GooglePayConfig(@NonNull Context context) {
        this(PaymentConfiguration.getInstance(context).getPublishableKey(), null);
    }

    public GooglePayConfig(@NonNull Context context, @Nullable String connectedAccountId) {
        this(PaymentConfiguration.getInstance(context).getPublishableKey(), connectedAccountId);
    }

    public GooglePayConfig(@NonNull String publishableKey) {
        this(publishableKey, null);
    }

    public GooglePayConfig(@NonNull String publishableKey, @Nullable String connectedAccountId) {
        this.mPublishableKey = ApiKeyValidator.get().requireValid(publishableKey);
        this.mApiVersion = ApiVersion.get().getCode();
        this.mConnectedAccountId = connectedAccountId;
    }

    @NonNull
    public JSONObject getTokenizationSpecification() throws JSONException {
        return new JSONObject().put("type", (Object)"PAYMENT_GATEWAY").put("parameters", (Object)new JSONObject().put("gateway", (Object)"stripe").put("stripe:version", (Object)this.mApiVersion).put("stripe:publishableKey", (Object)this.getKey()));
    }

    @NonNull
    private String getKey() {
        if (this.mConnectedAccountId != null) {
            return String.format(Locale.ROOT, "%s/%s", this.mPublishableKey, this.mConnectedAccountId);
        }
        return this.mPublishableKey;
    }
}

