/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.utils.ObjectUtils;
import com.stripe.android.view.ActivityStarter;
import com.stripe.android.view.AddPaymentMethodActivity;
import java.util.Objects;

public final class AddPaymentMethodActivityStarter
extends ActivityStarter<AddPaymentMethodActivity, Args> {
    public static final int REQUEST_CODE = 6001;

    AddPaymentMethodActivityStarter(@NonNull Activity activity) {
        super(activity, AddPaymentMethodActivity.class, Args.DEFAULT, 6001);
    }

    public static final class Args
    implements ActivityStarter.Args {
        private static final Args DEFAULT = new Builder().build();
        final boolean shouldAttachToCustomer;
        final boolean shouldRequirePostalCode;
        final boolean isPaymentSessionActive;
        final boolean shouldInitCustomerSessionTokens;
        @NonNull
        final PaymentMethod.Type paymentMethodType;
        @Nullable
        final PaymentConfiguration paymentConfiguration;
        public static final Parcelable.Creator<Args> CREATOR = new Parcelable.Creator<Args>(){

            public Args createFromParcel(@NonNull Parcel in) {
                return new Args(in);
            }

            public Args[] newArray(int size) {
                return new Args[size];
            }
        };

        @NonNull
        public static Args create(@NonNull Intent intent) {
            Args args = (Args)intent.getParcelableExtra("extra_activity_args");
            return Objects.requireNonNull(args);
        }

        private Args(@NonNull Builder builder) {
            this.shouldAttachToCustomer = builder.mShouldAttachToCustomer;
            this.shouldRequirePostalCode = builder.mShouldRequirePostalCode;
            this.isPaymentSessionActive = builder.mIsPaymentSessionActive;
            this.shouldInitCustomerSessionTokens = builder.mShouldInitCustomerSessionTokens;
            this.paymentMethodType = ObjectUtils.getOrDefault(builder.mPaymentMethodType, PaymentMethod.Type.Card);
            this.paymentConfiguration = builder.mPaymentConfiguration;
        }

        private Args(@NonNull Parcel in) {
            this.shouldAttachToCustomer = in.readInt() == 1;
            this.shouldRequirePostalCode = in.readInt() == 1;
            this.isPaymentSessionActive = in.readInt() == 1;
            this.shouldInitCustomerSessionTokens = in.readInt() == 1;
            this.paymentMethodType = PaymentMethod.Type.valueOf(in.readString());
            this.paymentConfiguration = (PaymentConfiguration)in.readParcelable(PaymentConfiguration.class.getClassLoader());
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.shouldAttachToCustomer ? 1 : 0);
            dest.writeInt(this.shouldRequirePostalCode ? 1 : 0);
            dest.writeInt(this.isPaymentSessionActive ? 1 : 0);
            dest.writeInt(this.shouldInitCustomerSessionTokens ? 1 : 0);
            dest.writeString(this.paymentMethodType.name());
            dest.writeParcelable((Parcelable)this.paymentConfiguration, 0);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.shouldAttachToCustomer, this.shouldRequirePostalCode, this.isPaymentSessionActive, this.shouldInitCustomerSessionTokens, this.paymentMethodType, this.paymentConfiguration});
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj) || obj instanceof Args && this.typedEquals((Args)obj);
        }

        private boolean typedEquals(@NonNull Args args) {
            return Objects.equals(this.shouldAttachToCustomer, args.shouldAttachToCustomer) && Objects.equals(this.shouldRequirePostalCode, args.shouldRequirePostalCode) && Objects.equals(this.isPaymentSessionActive, args.isPaymentSessionActive) && Objects.equals(this.shouldInitCustomerSessionTokens, args.shouldInitCustomerSessionTokens) && Objects.equals((Object)this.paymentMethodType, (Object)args.paymentMethodType) && Objects.equals(this.paymentConfiguration, args.paymentConfiguration);
        }

        public static final class Builder
        implements ObjectBuilder<Args> {
            private boolean mShouldAttachToCustomer;
            private boolean mShouldRequirePostalCode;
            private boolean mIsPaymentSessionActive = false;
            private boolean mShouldInitCustomerSessionTokens = true;
            @Nullable
            private PaymentMethod.Type mPaymentMethodType;
            @Nullable
            private PaymentConfiguration mPaymentConfiguration;

            @NonNull
            public Builder setShouldAttachToCustomer(boolean shouldAttachToCustomer) {
                this.mShouldAttachToCustomer = shouldAttachToCustomer;
                return this;
            }

            @NonNull
            public Builder setShouldRequirePostalCode(boolean shouldRequirePostalCode) {
                this.mShouldRequirePostalCode = shouldRequirePostalCode;
                return this;
            }

            @NonNull
            Builder setIsPaymentSessionActive(boolean isPaymentSessionActive) {
                this.mIsPaymentSessionActive = isPaymentSessionActive;
                return this;
            }

            @NonNull
            Builder setShouldInitCustomerSessionTokens(boolean shouldInitCustomerSessionTokens) {
                this.mShouldInitCustomerSessionTokens = shouldInitCustomerSessionTokens;
                return this;
            }

            @NonNull
            Builder setPaymentMethodType(@NonNull PaymentMethod.Type paymentMethodType) {
                this.mPaymentMethodType = paymentMethodType;
                return this;
            }

            @NonNull
            Builder setPaymentConfiguration(@Nullable PaymentConfiguration paymentConfiguration) {
                this.mPaymentConfiguration = paymentConfiguration;
                return this;
            }

            @Override
            @NonNull
            public Args build() {
                return new Args(this);
            }
        }
    }
}

