/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.stripe.android.model.SourceCardData;
import com.stripe.android.model.SourceCodeVerification;
import com.stripe.android.model.SourceOwner;
import com.stripe.android.model.SourceReceiver;
import com.stripe.android.model.SourceRedirect;
import com.stripe.android.model.SourceSepaDebitData;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.model.StripePaymentSource;
import com.stripe.android.model.StripeSourceTypeModel;
import com.stripe.android.model.WeChat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public final class Source
extends StripeModel
implements StripePaymentSource {
    static final String VALUE_SOURCE = "source";
    private static final String VALUE_CARD = "card";
    private static final Set<String> MODELED_TYPES = new HashSet<String>(Arrays.asList("card", "sepa_debit"));
    static final String EURO = "eur";
    static final String USD = "usd";
    private static final String FIELD_ID = "id";
    private static final String FIELD_OBJECT = "object";
    private static final String FIELD_AMOUNT = "amount";
    private static final String FIELD_CLIENT_SECRET = "client_secret";
    private static final String FIELD_CODE_VERIFICATION = "code_verification";
    private static final String FIELD_CREATED = "created";
    private static final String FIELD_CURRENCY = "currency";
    private static final String FIELD_FLOW = "flow";
    private static final String FIELD_LIVEMODE = "livemode";
    private static final String FIELD_METADATA = "metadata";
    private static final String FIELD_OWNER = "owner";
    private static final String FIELD_RECEIVER = "receiver";
    private static final String FIELD_REDIRECT = "redirect";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_USAGE = "usage";
    private static final String FIELD_WECHAT = "wechat";
    @NonNull
    private final String mType;
    @NonNull
    private final String mTypeRaw;
    @Nullable
    private final String mId;
    @Nullable
    private final Long mAmount;
    @Nullable
    private final String mClientSecret;
    @Nullable
    private final SourceCodeVerification mCodeVerification;
    @Nullable
    private final Long mCreated;
    @Nullable
    private final String mCurrency;
    @Nullable
    private final String mFlow;
    @Nullable
    private final Boolean mLiveMode;
    @Nullable
    private final Map<String, String> mMetaData;
    @Nullable
    private final SourceOwner mOwner;
    @Nullable
    private final SourceReceiver mReceiver;
    @Nullable
    private final SourceRedirect mRedirect;
    @Nullable
    private final String mStatus;
    @Nullable
    private final Map<String, Object> mSourceTypeData;
    @Nullable
    private final StripeSourceTypeModel mSourceTypeModel;
    @Nullable
    private final String mUsage;
    @Nullable
    private final WeChat mWeChat;

    private Source(@Nullable String id, @Nullable Long amount, @Nullable String clientSecret, @Nullable SourceCodeVerification codeVerification, @Nullable Long created, @Nullable String currency, @Nullable String flow, @Nullable Boolean liveMode, @Nullable Map<String, String> metaData, @Nullable SourceOwner owner, @Nullable SourceReceiver receiver, @Nullable SourceRedirect redirect, @Nullable String status, @Nullable Map<String, Object> sourceTypeData, @Nullable StripeSourceTypeModel sourceTypeModel, @NonNull String type, @NonNull String rawType, @Nullable String usage, @Nullable WeChat weChat) {
        this.mId = id;
        this.mAmount = amount;
        this.mClientSecret = clientSecret;
        this.mCodeVerification = codeVerification;
        this.mCreated = created;
        this.mCurrency = currency;
        this.mFlow = flow;
        this.mLiveMode = liveMode;
        this.mMetaData = metaData;
        this.mOwner = owner;
        this.mReceiver = receiver;
        this.mRedirect = redirect;
        this.mStatus = status;
        this.mSourceTypeData = sourceTypeData;
        this.mSourceTypeModel = sourceTypeModel;
        this.mType = type;
        this.mTypeRaw = rawType;
        this.mUsage = usage;
        this.mWeChat = weChat;
    }

    @Override
    @Nullable
    public String getId() {
        return this.mId;
    }

    @Nullable
    public Long getAmount() {
        return this.mAmount;
    }

    @Nullable
    public String getClientSecret() {
        return this.mClientSecret;
    }

    @Nullable
    public SourceCodeVerification getCodeVerification() {
        return this.mCodeVerification;
    }

    @Nullable
    public Long getCreated() {
        return this.mCreated;
    }

    @Nullable
    public String getCurrency() {
        return this.mCurrency;
    }

    @Nullable
    public String getFlow() {
        return this.mFlow;
    }

    @Nullable
    public Boolean isLiveMode() {
        return this.mLiveMode;
    }

    @Nullable
    public Map<String, String> getMetaData() {
        return this.mMetaData;
    }

    @Nullable
    public SourceOwner getOwner() {
        return this.mOwner;
    }

    @Nullable
    public SourceReceiver getReceiver() {
        return this.mReceiver;
    }

    @Nullable
    public SourceRedirect getRedirect() {
        return this.mRedirect;
    }

    @Nullable
    public String getStatus() {
        return this.mStatus;
    }

    @Nullable
    public Map<String, Object> getSourceTypeData() {
        return this.mSourceTypeData;
    }

    @Nullable
    public StripeSourceTypeModel getSourceTypeModel() {
        return this.mSourceTypeModel;
    }

    @NonNull
    public String getType() {
        return this.mType;
    }

    @NonNull
    public String getTypeRaw() {
        return this.mTypeRaw;
    }

    @Nullable
    public String getUsage() {
        return this.mUsage;
    }

    @NonNull
    public WeChat getWeChat() {
        if (!FIELD_WECHAT.equals(this.mType)) {
            throw new IllegalStateException(String.format(Locale.ENGLISH, "Source type must be '%s'", FIELD_WECHAT));
        }
        return Objects.requireNonNull(this.mWeChat);
    }

    @Nullable
    public static Source fromString(@Nullable String jsonString) {
        try {
            return Source.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static Source fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        String objectType = jsonObject.optString(FIELD_OBJECT);
        if (VALUE_CARD.equals(objectType)) {
            return Source.fromCardJson(jsonObject);
        }
        if (VALUE_SOURCE.equals(objectType)) {
            return Source.fromSourceJson(jsonObject);
        }
        return null;
    }

    @NonNull
    private static Source fromCardJson(@NonNull JSONObject jsonObject) {
        String id = StripeJsonUtils.optString(jsonObject, FIELD_ID);
        SourceCardData sourceTypeModel = SourceCardData.fromJson(jsonObject);
        return new Source(id, null, null, null, null, null, null, null, null, null, null, null, null, null, sourceTypeModel, VALUE_CARD, VALUE_CARD, null, null);
    }

    @NonNull
    private static Source fromSourceJson(@NonNull JSONObject jsonObject) {
        String id = StripeJsonUtils.optString(jsonObject, FIELD_ID);
        Long amount = StripeJsonUtils.optLong(jsonObject, FIELD_AMOUNT);
        String clientSecret = StripeJsonUtils.optString(jsonObject, FIELD_CLIENT_SECRET);
        SourceCodeVerification codeVerification = Source.optStripeJsonModel(jsonObject, FIELD_CODE_VERIFICATION, SourceCodeVerification.class);
        Long created = StripeJsonUtils.optLong(jsonObject, FIELD_CREATED);
        String currency = StripeJsonUtils.optString(jsonObject, FIELD_CURRENCY);
        String flow = Source.asSourceFlow(StripeJsonUtils.optString(jsonObject, FIELD_FLOW));
        Boolean liveMode = jsonObject.optBoolean(FIELD_LIVEMODE);
        Map<String, String> metadata = StripeJsonUtils.jsonObjectToStringMap(jsonObject.optJSONObject(FIELD_METADATA));
        SourceOwner owner = Source.optStripeJsonModel(jsonObject, FIELD_OWNER, SourceOwner.class);
        SourceReceiver receiver = Source.optStripeJsonModel(jsonObject, FIELD_RECEIVER, SourceReceiver.class);
        SourceRedirect redirect = Source.optStripeJsonModel(jsonObject, FIELD_REDIRECT, SourceRedirect.class);
        String status = Source.asSourceStatus(StripeJsonUtils.optString(jsonObject, FIELD_STATUS));
        String typeRawOpt = StripeJsonUtils.optString(jsonObject, FIELD_TYPE);
        String typeRaw = typeRawOpt != null ? typeRawOpt : "unknown";
        String type = Source.asSourceType(typeRaw);
        Map<String, Object> sourceTypeData = StripeJsonUtils.jsonObjectToMap(jsonObject.optJSONObject(typeRaw));
        StripeSourceTypeModel sourceTypeModel = MODELED_TYPES.contains(typeRaw) ? Source.optStripeJsonModel(jsonObject, typeRaw, StripeSourceTypeModel.class) : null;
        String usage = Source.asUsage(StripeJsonUtils.optString(jsonObject, FIELD_USAGE));
        WeChat weChat = FIELD_WECHAT.equals(type) ? WeChat.fromJson(jsonObject.optJSONObject(FIELD_WECHAT)) : null;
        return new Source(id, amount, clientSecret, codeVerification, created, currency, flow, liveMode, metadata, owner, receiver, redirect, status, sourceTypeData, sourceTypeModel, type, typeRaw, usage, weChat);
    }

    @Nullable
    private static <T extends StripeModel> T optStripeJsonModel(@NonNull JSONObject jsonObject, @NonNull @Size(min=1L) String key, @NonNull Class<T> type) {
        if (!jsonObject.has(key)) {
            return null;
        }
        switch (key) {
            case "code_verification": {
                return (T)((StripeModel)type.cast(SourceCodeVerification.fromJson(jsonObject.optJSONObject(FIELD_CODE_VERIFICATION))));
            }
            case "owner": {
                return (T)((StripeModel)type.cast(SourceOwner.fromJson(jsonObject.optJSONObject(FIELD_OWNER))));
            }
            case "receiver": {
                return (T)((StripeModel)type.cast(SourceReceiver.fromJson(jsonObject.optJSONObject(FIELD_RECEIVER))));
            }
            case "redirect": {
                return (T)((StripeModel)type.cast(SourceRedirect.fromJson(jsonObject.optJSONObject(FIELD_REDIRECT))));
            }
            case "card": {
                return (T)((StripeModel)type.cast(SourceCardData.fromJson(jsonObject.optJSONObject(VALUE_CARD))));
            }
            case "sepa_debit": {
                return (T)((StripeModel)type.cast(SourceSepaDebitData.fromJson(jsonObject.optJSONObject("sepa_debit"))));
            }
        }
        return null;
    }

    @Nullable
    private static String asSourceStatus(@Nullable String sourceStatus) {
        if ("pending".equals(sourceStatus)) {
            return "pending";
        }
        if ("chargeable".equals(sourceStatus)) {
            return "chargeable";
        }
        if ("consumed".equals(sourceStatus)) {
            return "consumed";
        }
        if ("canceled".equals(sourceStatus)) {
            return "canceled";
        }
        if ("failed".equals(sourceStatus)) {
            return "failed";
        }
        return null;
    }

    @NonNull
    static String asSourceType(@Nullable String sourceType) {
        if (VALUE_CARD.equals(sourceType)) {
            return VALUE_CARD;
        }
        if ("three_d_secure".equals(sourceType)) {
            return "three_d_secure";
        }
        if ("giropay".equals(sourceType)) {
            return "giropay";
        }
        if ("sepa_debit".equals(sourceType)) {
            return "sepa_debit";
        }
        if ("ideal".equals(sourceType)) {
            return "ideal";
        }
        if ("sofort".equals(sourceType)) {
            return "sofort";
        }
        if ("bancontact".equals(sourceType)) {
            return "bancontact";
        }
        if ("alipay".equals(sourceType)) {
            return "alipay";
        }
        if ("eps".equals(sourceType)) {
            return "eps";
        }
        if ("p24".equals(sourceType)) {
            return "p24";
        }
        if ("multibanco".equals(sourceType)) {
            return "multibanco";
        }
        if (FIELD_WECHAT.equals(sourceType)) {
            return FIELD_WECHAT;
        }
        if ("unknown".equals(sourceType)) {
            return "unknown";
        }
        return "unknown";
    }

    @Nullable
    private static String asUsage(@Nullable String usage) {
        if ("reusable".equals(usage)) {
            return "reusable";
        }
        if ("single_use".equals(usage)) {
            return "single_use";
        }
        return null;
    }

    @Nullable
    private static String asSourceFlow(@Nullable String sourceFlow) {
        if (FIELD_REDIRECT.equals(sourceFlow)) {
            return FIELD_REDIRECT;
        }
        if (FIELD_RECEIVER.equals(sourceFlow)) {
            return FIELD_RECEIVER;
        }
        if (FIELD_CODE_VERIFICATION.equals(sourceFlow)) {
            return FIELD_CODE_VERIFICATION;
        }
        if ("none".equals(sourceFlow)) {
            return "none";
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof Source && this.typedEquals((Source)obj);
    }

    private boolean typedEquals(@NonNull Source source) {
        return Objects.equals(this.mId, source.mId) && Objects.equals(this.mAmount, source.mAmount) && Objects.equals(this.mClientSecret, source.mClientSecret) && Objects.equals(this.mCodeVerification, source.mCodeVerification) && Objects.equals(this.mCreated, source.mCreated) && Objects.equals(this.mCurrency, source.mCurrency) && Objects.equals(this.mTypeRaw, source.mTypeRaw) && Objects.equals(this.mFlow, source.mFlow) && Objects.equals(this.mLiveMode, source.mLiveMode) && Objects.equals(this.mMetaData, source.mMetaData) && Objects.equals(this.mOwner, source.mOwner) && Objects.equals(this.mReceiver, source.mReceiver) && Objects.equals(this.mRedirect, source.mRedirect) && Objects.equals(this.mStatus, source.mStatus) && Objects.equals(this.mSourceTypeData, source.mSourceTypeData) && Objects.equals(this.mSourceTypeModel, source.mSourceTypeModel) && Objects.equals(this.mType, source.mType) && Objects.equals(this.mUsage, source.mUsage) && Objects.equals(this.mWeChat, source.mWeChat);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mId, this.mAmount, this.mClientSecret, this.mCodeVerification, this.mCreated, this.mCurrency, this.mTypeRaw, this.mFlow, this.mLiveMode, this.mMetaData, this.mOwner, this.mReceiver, this.mRedirect, this.mStatus, this.mSourceTypeData, this.mSourceTypeModel, this.mType, this.mUsage);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SourceFlow {
        public static final String REDIRECT = "redirect";
        public static final String RECEIVER = "receiver";
        public static final String CODE_VERIFICATION = "code_verification";
        public static final String NONE = "none";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Usage {
        public static final String REUSABLE = "reusable";
        public static final String SINGLE_USE = "single_use";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SourceStatus {
        public static final String PENDING = "pending";
        public static final String CHARGEABLE = "chargeable";
        public static final String CONSUMED = "consumed";
        public static final String CANCELED = "canceled";
        public static final String FAILED = "failed";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SourceType {
        public static final String ALIPAY = "alipay";
        public static final String CARD = "card";
        public static final String THREE_D_SECURE = "three_d_secure";
        public static final String GIROPAY = "giropay";
        public static final String SEPA_DEBIT = "sepa_debit";
        public static final String IDEAL = "ideal";
        public static final String SOFORT = "sofort";
        public static final String BANCONTACT = "bancontact";
        public static final String P24 = "p24";
        public static final String EPS = "eps";
        public static final String MULTIBANCO = "multibanco";
        public static final String WECHAT = "wechat";
        public static final String UNKNOWN = "unknown";
    }
}

