/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.model.StripeParamsModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class AccountParams
implements StripeParamsModel {
    static final String API_BUSINESS_TYPE = "business_type";
    static final String API_TOS_SHOWN_AND_ACCEPTED = "tos_shown_and_accepted";
    private final boolean mTosShownAndAccepted;
    @Nullable
    private final BusinessType mBusinessType;
    @Nullable
    private final Map<String, Object> mBusinessData;

    @NonNull
    public static AccountParams createAccountParams(boolean tosShownAndAccepted, @Nullable BusinessType businessType, @Nullable Map<String, Object> businessData) {
        return new AccountParams(businessType, businessData, tosShownAndAccepted);
    }

    private AccountParams(@Nullable BusinessType businessType, @Nullable Map<String, Object> businessData, boolean tosShownAndAccepted) {
        this.mBusinessType = businessType;
        this.mBusinessData = businessData;
        this.mTosShownAndAccepted = tosShownAndAccepted;
    }

    @Override
    @NonNull
    public Map<String, Object> toParamMap() {
        HashMap<String, Object> accountData = new HashMap<String, Object>();
        if (this.mBusinessType != null) {
            accountData.put(API_BUSINESS_TYPE, this.mBusinessType.code);
            if (this.mBusinessData != null) {
                accountData.put(this.mBusinessType.code, this.mBusinessData);
            }
        }
        accountData.put(API_TOS_SHOWN_AND_ACCEPTED, this.mTosShownAndAccepted);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("account", accountData);
        return params;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mTosShownAndAccepted, this.mBusinessType, this.mBusinessData});
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof AccountParams && this.typedEquals((AccountParams)obj);
    }

    private boolean typedEquals(@NonNull AccountParams accountParams) {
        return Objects.equals(this.mTosShownAndAccepted, accountParams.mTosShownAndAccepted) && Objects.equals((Object)this.mBusinessType, (Object)accountParams.mBusinessType) && Objects.equals(this.mBusinessData, accountParams.mBusinessData);
    }

    public static enum BusinessType {
        Individual("individual"),
        Company("company");

        @NonNull
        public final String code;

        private BusinessType(String code) {
            this.code = code;
        }
    }
}

