/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.ConnectionFactory;
import com.stripe.android.FireAndForgetRequestExecutor;
import com.stripe.android.StripeRequest;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.InvalidRequestException;
import java.io.Closeable;
import java.io.IOException;
import java.net.HttpURLConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/StripeFireAndForgetRequestExecutor;", "Lcom/stripe/android/FireAndForgetRequestExecutor;", "()V", "connectionFactory", "Lcom/stripe/android/ConnectionFactory;", "closeConnection", "", "conn", "Ljava/net/HttpURLConnection;", "responseCode", "", "closeStream", "stream", "Ljava/io/Closeable;", "execute", "request", "Lcom/stripe/android/StripeRequest;", "executeAsync", "stripe_release"})
public final class StripeFireAndForgetRequestExecutor
implements FireAndForgetRequestExecutor {
    private final ConnectionFactory connectionFactory = new ConnectionFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final int execute(@NotNull StripeRequest request) throws APIConnectionException, InvalidRequestException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        HttpURLConnection conn = null;
        try {
            conn = this.connectionFactory.create(request);
            int responseCode = conn.getResponseCode();
            this.closeConnection(conn, responseCode);
            int n = responseCode;
            return n;
        }
        catch (IOException e) {
            APIConnectionException aPIConnectionException = APIConnectionException.create(request.getBaseUrl(), e);
            Intrinsics.checkExpressionValueIsNotNull((Object)aPIConnectionException, (String)"APIConnectionException.create(request.baseUrl, e)");
            throw (Throwable)aPIConnectionException;
        }
        finally {
            block5: {
                HttpURLConnection httpURLConnection = conn;
                if (httpURLConnection == null) break block5;
                httpURLConnection.disconnect();
            }
        }
    }

    private final void closeConnection(HttpURLConnection conn, int responseCode) throws IOException {
        int n = responseCode;
        if (200 <= n && 299 >= n) {
            this.closeStream(conn.getInputStream());
        } else {
            this.closeStream(conn.getErrorStream());
        }
    }

    private final void closeStream(Closeable stream) throws IOException {
        block0: {
            Closeable closeable = stream;
            if (closeable == null) break block0;
            closeable.close();
        }
    }

    @Override
    public void executeAsync(@NotNull StripeRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        HandlerThread handlerThread = new HandlerThread(StripeFireAndForgetRequestExecutor.class.getSimpleName());
        handlerThread.start();
        Handler handler = new Handler(handlerThread.getLooper());
        handler.post(new Runnable(this, request, handlerThread){
            final /* synthetic */ StripeFireAndForgetRequestExecutor this$0;
            final /* synthetic */ StripeRequest $request;
            final /* synthetic */ HandlerThread $handlerThread;

            public final void run() {
                try {
                    this.this$0.execute(this.$request);
                    this.$handlerThread.quitSafely();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            {
                this.this$0 = stripeFireAndForgetRequestExecutor;
                this.$request = stripeRequest;
                this.$handlerThread = handlerThread;
            }
        });
    }
}

