/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.model.Address;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.model.StripeParamsModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.json.JSONObject;

public final class ShippingInformation
extends StripeModel
implements StripeParamsModel,
Parcelable {
    public static final Parcelable.Creator<ShippingInformation> CREATOR = new Parcelable.Creator<ShippingInformation>(){

        public ShippingInformation createFromParcel(Parcel source) {
            return new ShippingInformation(source);
        }

        public ShippingInformation[] newArray(int size) {
            return new ShippingInformation[size];
        }
    };
    private static final String FIELD_ADDRESS = "address";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_PHONE = "phone";
    @Nullable
    private final Address mAddress;
    @Nullable
    private final String mName;
    @Nullable
    private final String mPhone;

    public ShippingInformation(@Nullable Address address, @Nullable String name, @Nullable String phone) {
        this.mAddress = address;
        this.mName = name;
        this.mPhone = phone;
    }

    protected ShippingInformation(@NonNull Parcel in) {
        this.mAddress = (Address)in.readParcelable(Address.class.getClassLoader());
        this.mName = in.readString();
        this.mPhone = in.readString();
    }

    @Nullable
    public Address getAddress() {
        return this.mAddress;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public String getPhone() {
        return this.mPhone;
    }

    @Nullable
    public static ShippingInformation fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        return new ShippingInformation(Address.fromJson(jsonObject.optJSONObject(FIELD_ADDRESS)), StripeJsonUtils.optString(jsonObject, FIELD_NAME), StripeJsonUtils.optString(jsonObject, FIELD_PHONE));
    }

    @Override
    @NonNull
    public Map<String, Object> toParamMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.mName != null) {
            map.put(FIELD_NAME, this.mName);
        }
        if (this.mPhone != null) {
            map.put(FIELD_PHONE, this.mPhone);
        }
        if (this.mAddress != null) {
            map.put(FIELD_ADDRESS, this.mAddress.toParamMap());
        }
        return map;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.mAddress, flags);
        dest.writeString(this.mName);
        dest.writeString(this.mPhone);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof ShippingInformation && this.typedEquals((ShippingInformation)obj);
    }

    private boolean typedEquals(@NonNull ShippingInformation shippingInformation) {
        return Objects.equals(this.mAddress, shippingInformation.mAddress) && Objects.equals(this.mName, shippingInformation.mName) && Objects.equals(this.mPhone, shippingInformation.mPhone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mAddress, this.mName, this.mPhone);
    }
}

