/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.stripe.android.CustomerSession;
import com.stripe.android.R;
import com.stripe.android.StripeError;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.AddPaymentMethodCardRowView;
import com.stripe.android.view.AddPaymentMethodFpxRowView;
import com.stripe.android.view.PaymentMethodsActivityStarter;
import com.stripe.android.view.PaymentMethodsAdapter;
import com.stripe.android.view.i18n.TranslatorManager;
import java.util.List;

public class PaymentMethodsActivity
extends AppCompatActivity {
    private static final String STATE_SELECTED_PAYMENT_METHOD_ID = "state_selected_payment_method_id";
    public static final String TOKEN_PAYMENT_METHODS_ACTIVITY = "PaymentMethodsActivity";
    private PaymentMethodsAdapter mAdapter;
    private ProgressBar mProgressBar;
    private boolean mStartedFromPaymentSession;
    private CustomerSession mCustomerSession;
    @Nullable
    private PaymentMethod mTappedPaymentMethod = null;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_payment_methods);
        PaymentMethodsActivityStarter.Args args = PaymentMethodsActivityStarter.Args.create(this.getIntent());
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.payment_methods_progress_bar);
        String initiallySelectedPaymentMethodId = savedInstanceState != null && savedInstanceState.containsKey(STATE_SELECTED_PAYMENT_METHOD_ID) ? savedInstanceState.getString(STATE_SELECTED_PAYMENT_METHOD_ID) : args.initialPaymentMethodId;
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.payment_methods_recycler);
        this.mAdapter = new PaymentMethodsAdapter(initiallySelectedPaymentMethodId);
        this.mAdapter.setListener(new PaymentMethodsAdapter.Listener(){

            @Override
            public void onClick(@NonNull PaymentMethod paymentMethod) {
                PaymentMethodsActivity.this.mTappedPaymentMethod = paymentMethod;
            }
        });
        recyclerView.setHasFixedSize(false);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        recyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        recyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator(){

            public void onAnimationFinished(@NonNull RecyclerView.ViewHolder viewHolder) {
                super.onAnimationFinished(viewHolder);
                if (PaymentMethodsActivity.this.mTappedPaymentMethod != null) {
                    PaymentMethodsActivity.this.setSelectionAndFinish(PaymentMethodsActivity.this.mTappedPaymentMethod);
                    PaymentMethodsActivity.this.mTappedPaymentMethod = null;
                }
            }
        });
        this.mCustomerSession = CustomerSession.getInstance();
        this.mStartedFromPaymentSession = args.isPaymentSessionActive;
        ViewGroup addPaymentMethodsContainer = (ViewGroup)this.findViewById(R.id.add_payment_methods);
        AddPaymentMethodCardRowView addCardView = new AddPaymentMethodCardRowView((Activity)this, args);
        addPaymentMethodsContainer.addView((View)addCardView);
        if (args.paymentMethodTypes.contains((Object)PaymentMethod.Type.Fpx)) {
            addPaymentMethodsContainer.addView((View)new AddPaymentMethodFpxRowView((Activity)this, args));
        }
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.payment_methods_toolbar);
        this.setSupportActionBar(toolbar);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            this.getSupportActionBar().setDisplayShowHomeEnabled(true);
        }
        this.fetchCustomerPaymentMethods();
        addCardView.requestFocusFromTouch();
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 6001 && resultCode == -1) {
            this.onPaymentMethodCreated(data);
        }
    }

    public boolean onSupportNavigateUp() {
        this.setSelectionAndFinish(this.mAdapter.getSelectedPaymentMethod());
        return true;
    }

    private void onPaymentMethodCreated(@Nullable Intent data) {
        this.initLoggingTokens();
        if (data != null && data.hasExtra("new_payment_method")) {
            PaymentMethod.Type type;
            PaymentMethod paymentMethod = (PaymentMethod)data.getParcelableExtra("new_payment_method");
            PaymentMethod.Type type2 = type = paymentMethod != null ? PaymentMethod.Type.lookup(paymentMethod.type) : null;
            if (type != null && !type.isReusable) {
                this.finishWithPaymentMethod(paymentMethod);
            } else {
                this.fetchCustomerPaymentMethods();
            }
        } else {
            this.fetchCustomerPaymentMethods();
        }
    }

    public void onBackPressed() {
        this.setSelectionAndFinish(this.mAdapter.getSelectedPaymentMethod());
    }

    private void fetchCustomerPaymentMethods() {
        this.setCommunicatingProgress(true);
        this.mCustomerSession.getPaymentMethods(PaymentMethod.Type.Card, new PaymentMethodsRetrievalListener(this));
    }

    private void updatePaymentMethods(@NonNull List<PaymentMethod> paymentMethods) {
        this.mAdapter.setPaymentMethods(paymentMethods);
    }

    private void initLoggingTokens() {
        if (this.mStartedFromPaymentSession) {
            this.mCustomerSession.addProductUsageTokenIfValid("PaymentSession");
        }
        this.mCustomerSession.addProductUsageTokenIfValid(TOKEN_PAYMENT_METHODS_ACTIVITY);
    }

    private void cancelAndFinish() {
        this.setResult(0);
        this.finish();
    }

    private void setCommunicatingProgress(boolean communicating) {
        if (communicating) {
            this.mProgressBar.setVisibility(0);
        } else {
            this.mProgressBar.setVisibility(8);
        }
        this.supportInvalidateOptionsMenu();
    }

    @VisibleForTesting
    void setSelectionAndFinish(@Nullable PaymentMethod paymentMethod) {
        if (paymentMethod == null || paymentMethod.id == null) {
            this.cancelAndFinish();
            return;
        }
        this.finishWithPaymentMethod(paymentMethod);
    }

    private void finishWithPaymentMethod(@NonNull PaymentMethod paymentMethod) {
        this.setResult(-1, new Intent().putExtras(new PaymentMethodsActivityStarter.Result(paymentMethod).toBundle()));
        this.finish();
    }

    private void showError(@NonNull String error) {
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)error).setCancelable(true).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                dialogInterface.dismiss();
            }
        }).create().show();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        PaymentMethod paymentMethod = this.mAdapter.getSelectedPaymentMethod();
        if (paymentMethod != null) {
            outState.putString(STATE_SELECTED_PAYMENT_METHOD_ID, paymentMethod.id);
        }
    }

    private static final class PaymentMethodsRetrievalListener
    extends CustomerSession.ActivityPaymentMethodsRetrievalListener<PaymentMethodsActivity> {
        private PaymentMethodsRetrievalListener(@NonNull PaymentMethodsActivity activity) {
            super(activity);
        }

        @Override
        public void onPaymentMethodsRetrieved(@NonNull List<PaymentMethod> paymentMethods) {
            PaymentMethodsActivity activity = (PaymentMethodsActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            activity.updatePaymentMethods(paymentMethods);
            activity.setCommunicatingProgress(false);
        }

        @Override
        public void onError(int errorCode, @NonNull String errorMessage, @Nullable StripeError stripeError) {
            PaymentMethodsActivity activity = (PaymentMethodsActivity)((Object)this.getActivity());
            if (activity == null) {
                return;
            }
            String displayedError = TranslatorManager.getErrorMessageTranslator().translate(errorCode, errorMessage, stripeError);
            activity.showError(displayedError);
            activity.setCommunicatingProgress(false);
        }
    }
}

