/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public final class SourceReceiver
extends StripeModel {
    private static final String FIELD_ADDRESS = "address";
    private static final String FIELD_AMOUNT_CHARGED = "amount_charged";
    private static final String FIELD_AMOUNT_RECEIVED = "amount_received";
    private static final String FIELD_AMOUNT_RETURNED = "amount_returned";
    @Nullable
    private final String mAddress;
    private final long mAmountCharged;
    private final long mAmountReceived;
    private final long mAmountReturned;

    private SourceReceiver(@Nullable String address, long amountCharged, long amountReceived, long amountReturned) {
        this.mAddress = address;
        this.mAmountCharged = amountCharged;
        this.mAmountReceived = amountReceived;
        this.mAmountReturned = amountReturned;
    }

    @Nullable
    public String getAddress() {
        return this.mAddress;
    }

    public long getAmountCharged() {
        return this.mAmountCharged;
    }

    public long getAmountReceived() {
        return this.mAmountReceived;
    }

    public long getAmountReturned() {
        return this.mAmountReturned;
    }

    @Nullable
    public static SourceReceiver fromString(@Nullable String jsonString) {
        try {
            return SourceReceiver.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static SourceReceiver fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        return new SourceReceiver(StripeJsonUtils.optString(jsonObject, FIELD_ADDRESS), jsonObject.optLong(FIELD_AMOUNT_CHARGED), jsonObject.optLong(FIELD_AMOUNT_RECEIVED), jsonObject.optLong(FIELD_AMOUNT_RETURNED));
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof SourceReceiver && this.typedEquals((SourceReceiver)obj);
    }

    private boolean typedEquals(@NonNull SourceReceiver sourceReceiver) {
        return Objects.equals(this.mAddress, sourceReceiver.mAddress) && this.mAmountCharged == sourceReceiver.mAmountCharged && this.mAmountReceived == sourceReceiver.mAmountReceived && this.mAmountReturned == sourceReceiver.mAmountReturned;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mAddress, this.mAmountCharged, this.mAmountReceived, this.mAmountReturned);
    }
}

