/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import com.stripe.android.model.StripeModel;
import java.util.Currency;
import java.util.Objects;

public final class ShippingMethod
extends StripeModel
implements Parcelable {
    public static final Parcelable.Creator<ShippingMethod> CREATOR = new Parcelable.Creator<ShippingMethod>(){

        public ShippingMethod createFromParcel(Parcel in) {
            return new ShippingMethod(in);
        }

        public ShippingMethod[] newArray(int size) {
            return new ShippingMethod[size];
        }
    };
    private final long mAmount;
    @NonNull
    @Size(min=0L, max=3L)
    private final String mCurrencyCode;
    @Nullable
    private final String mDetail;
    @NonNull
    private final String mIdentifier;
    @NonNull
    private final String mLabel;

    public ShippingMethod(@NonNull String label, @NonNull String identifier, long amount, @NonNull @Size(min=0L, max=3L) String currencyCode) {
        this(label, identifier, null, amount, currencyCode);
    }

    public ShippingMethod(@NonNull String label, @NonNull String identifier, @Nullable String detail, long amount, @NonNull @Size(min=0L, max=3L) String currencyCode) {
        this.mLabel = label;
        this.mIdentifier = identifier;
        this.mDetail = detail;
        this.mAmount = amount;
        this.mCurrencyCode = currencyCode;
    }

    private ShippingMethod(@NonNull Parcel in) {
        this.mAmount = in.readLong();
        this.mCurrencyCode = Objects.requireNonNull(in.readString());
        this.mDetail = in.readString();
        this.mIdentifier = Objects.requireNonNull(in.readString());
        this.mLabel = Objects.requireNonNull(in.readString());
    }

    @NonNull
    public Currency getCurrency() {
        return Currency.getInstance(this.mCurrencyCode);
    }

    public long getAmount() {
        return this.mAmount;
    }

    @NonNull
    public String getLabel() {
        return this.mLabel;
    }

    @Nullable
    public String getDetail() {
        return this.mDetail;
    }

    @NonNull
    public String getIdentifier() {
        return this.mIdentifier;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int i) {
        parcel.writeLong(this.mAmount);
        parcel.writeString(this.mCurrencyCode);
        parcel.writeString(this.mDetail);
        parcel.writeString(this.mIdentifier);
        parcel.writeString(this.mLabel);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof ShippingMethod && this.typedEquals((ShippingMethod)obj);
    }

    private boolean typedEquals(@NonNull ShippingMethod shippingMethod) {
        return this.mAmount == shippingMethod.mAmount && Objects.equals(this.mCurrencyCode, shippingMethod.mCurrencyCode) && Objects.equals(this.mDetail, shippingMethod.mDetail) && Objects.equals(this.mIdentifier, shippingMethod.mIdentifier) && Objects.equals(this.mLabel, shippingMethod.mLabel);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mAmount, this.mCurrencyCode, this.mDetail, this.mIdentifier, this.mLabel);
    }
}

