/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.model.Address;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.StripeParamsModel;
import com.stripe.android.model.Token;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public final class PaymentMethodCreateParams
implements StripeParamsModel {
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_CARD = "card";
    private static final String FIELD_FPX = "fpx";
    private static final String FIELD_IDEAL = "ideal";
    private static final String FIELD_BILLING_DETAILS = "billing_details";
    private static final String FIELD_METADATA = "metadata";
    @NonNull
    private final Type type;
    @Nullable
    private final Card card;
    @Nullable
    private final Ideal ideal;
    @Nullable
    private final Fpx fpx;
    @Nullable
    private final PaymentMethod.BillingDetails billingDetails;
    @Nullable
    private final Map<String, String> metadata;

    @NonNull
    public static PaymentMethodCreateParams create(@NonNull Card card) {
        return PaymentMethodCreateParams.create(card, null);
    }

    @NonNull
    public static PaymentMethodCreateParams create(@NonNull Card card, @Nullable PaymentMethod.BillingDetails billingDetails) {
        return new PaymentMethodCreateParams(card, billingDetails, null);
    }

    @NonNull
    public static PaymentMethodCreateParams create(@NonNull Card card, @Nullable PaymentMethod.BillingDetails billingDetails, @Nullable Map<String, String> metadata) {
        return new PaymentMethodCreateParams(card, billingDetails, metadata);
    }

    @NonNull
    public static PaymentMethodCreateParams create(@NonNull Ideal ideal) {
        return new PaymentMethodCreateParams(ideal, null, null);
    }

    @NonNull
    public static PaymentMethodCreateParams create(@NonNull Ideal ideal, @Nullable PaymentMethod.BillingDetails billingDetails) {
        return new PaymentMethodCreateParams(ideal, billingDetails, null);
    }

    @NonNull
    public static PaymentMethodCreateParams create(@NonNull Ideal ideal, @Nullable PaymentMethod.BillingDetails billingDetails, @Nullable Map<String, String> metadata) {
        return new PaymentMethodCreateParams(ideal, billingDetails, metadata);
    }

    @NonNull
    public static PaymentMethodCreateParams create(@NonNull Fpx fpx) {
        return PaymentMethodCreateParams.create(fpx, null);
    }

    @NonNull
    public static PaymentMethodCreateParams create(@NonNull Fpx fpx, @Nullable PaymentMethod.BillingDetails billingDetails) {
        return PaymentMethodCreateParams.create(fpx, billingDetails, null);
    }

    @NonNull
    public static PaymentMethodCreateParams create(@NonNull Fpx fpx, @Nullable PaymentMethod.BillingDetails billingDetails, @Nullable Map<String, String> metadata) {
        return new PaymentMethodCreateParams(fpx, billingDetails, metadata);
    }

    @NonNull
    public static PaymentMethodCreateParams createFromGooglePay(@NonNull JSONObject googlePayPaymentData) throws JSONException {
        PaymentMethod.BillingDetails billingDetails;
        JSONObject paymentMethodData = googlePayPaymentData.getJSONObject("paymentMethodData");
        JSONObject googlePayBillingAddress = paymentMethodData.getJSONObject("info").optJSONObject("billingAddress");
        String paymentToken = paymentMethodData.getJSONObject("tokenizationData").getString("token");
        Token stripeToken = Token.fromJson(new JSONObject(paymentToken));
        String stripeTokenId = Objects.requireNonNull(stripeToken).getId();
        String email = googlePayPaymentData.optString("email");
        if (googlePayBillingAddress != null) {
            Address billingAddress = new Address.Builder().setLine1(googlePayBillingAddress.optString("address1")).setLine2(googlePayBillingAddress.optString("address2")).setCity(googlePayBillingAddress.optString("locality")).setState(googlePayBillingAddress.optString("administrativeArea")).setCountry(googlePayBillingAddress.optString("countryCode")).setPostalCode(googlePayBillingAddress.optString("postalCode")).build();
            billingDetails = new PaymentMethod.BillingDetails.Builder().setAddress(billingAddress).setName(googlePayBillingAddress.optString("name")).setEmail(email).setPhone(googlePayBillingAddress.optString("phoneNumber")).build();
        } else {
            billingDetails = new PaymentMethod.BillingDetails.Builder().setEmail(email).build();
        }
        return PaymentMethodCreateParams.create(Card.create(stripeTokenId), billingDetails);
    }

    private PaymentMethodCreateParams(@NonNull Card card, @Nullable PaymentMethod.BillingDetails billingDetails, @Nullable Map<String, String> metadata) {
        this.type = Type.Card;
        this.card = card;
        this.ideal = null;
        this.fpx = null;
        this.billingDetails = billingDetails;
        this.metadata = metadata;
    }

    private PaymentMethodCreateParams(@NonNull Ideal ideal, @Nullable PaymentMethod.BillingDetails billingDetails, @Nullable Map<String, String> metadata) {
        this.type = Type.Ideal;
        this.card = null;
        this.ideal = ideal;
        this.fpx = null;
        this.billingDetails = billingDetails;
        this.metadata = metadata;
    }

    private PaymentMethodCreateParams(@NonNull Fpx fpx, @Nullable PaymentMethod.BillingDetails billingDetails, @Nullable Map<String, String> metadata) {
        this.type = Type.Fpx;
        this.card = null;
        this.ideal = null;
        this.fpx = fpx;
        this.billingDetails = billingDetails;
        this.metadata = metadata;
    }

    @Override
    @NonNull
    public Map<String, Object> toParamMap() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(FIELD_TYPE, this.type.mCode);
        if (this.type == Type.Card && this.card != null) {
            params.put(FIELD_CARD, this.card.toParamMap());
        } else if (this.type == Type.Ideal && this.ideal != null) {
            params.put(FIELD_IDEAL, this.ideal.toParamMap());
        } else if (this.type == Type.Fpx && this.fpx != null) {
            params.put(FIELD_FPX, this.fpx.toParamMap());
        }
        if (this.billingDetails != null) {
            params.put(FIELD_BILLING_DETAILS, this.billingDetails.toParamMap());
        }
        if (this.metadata != null) {
            params.put(FIELD_METADATA, this.metadata);
        }
        return params;
    }

    @NonNull
    public String getTypeCode() {
        return this.type.mCode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.card, this.fpx, this.ideal, this.billingDetails, this.metadata});
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof PaymentMethodCreateParams && this.typedEquals((PaymentMethodCreateParams)obj);
    }

    private boolean typedEquals(@NonNull PaymentMethodCreateParams params) {
        return Objects.equals((Object)this.type, (Object)params.type) && Objects.equals(this.card, params.card) && Objects.equals(this.fpx, params.fpx) && Objects.equals(this.ideal, params.ideal) && Objects.equals(this.billingDetails, params.billingDetails) && Objects.equals(this.metadata, params.metadata);
    }

    public static final class Fpx
    implements StripeParamsModel {
        private static final String FIELD_BANK = "bank";
        @Nullable
        private final String mBank;

        private Fpx(@NonNull Builder builder) {
            this.mBank = builder.mBank;
        }

        @Override
        @NonNull
        public Map<String, Object> toParamMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ((AbstractMap)map).put(FIELD_BANK, this.mBank);
            return map;
        }

        public int hashCode() {
            return Objects.hash(this.mBank);
        }

        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof Fpx && this.typedEquals((Fpx)obj);
        }

        private boolean typedEquals(@NonNull Fpx fpx) {
            return Objects.equals(this.mBank, fpx.mBank);
        }

        public static final class Builder
        implements ObjectBuilder<Fpx> {
            @Nullable
            private String mBank;

            @NonNull
            public Builder setBank(@Nullable String bank) {
                this.mBank = bank;
                return this;
            }

            @Override
            @NonNull
            public Fpx build() {
                return new Fpx(this);
            }
        }
    }

    public static final class Ideal
    implements StripeParamsModel {
        private static final String FIELD_BANK = "bank";
        @Nullable
        private final String mBank;

        private Ideal(@NonNull Builder builder) {
            this.mBank = builder.mBank;
        }

        @Override
        @NonNull
        public Map<String, Object> toParamMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.mBank != null) {
                map.put(FIELD_BANK, this.mBank);
            }
            return map;
        }

        public int hashCode() {
            return Objects.hash(this.mBank);
        }

        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof Ideal && this.typedEquals((Ideal)obj);
        }

        private boolean typedEquals(@NonNull Ideal ideal) {
            return Objects.equals(this.mBank, ideal.mBank);
        }

        public static final class Builder
        implements ObjectBuilder<Ideal> {
            @Nullable
            private String mBank;

            @NonNull
            public Builder setBank(@Nullable String bank) {
                this.mBank = bank;
                return this;
            }

            @Override
            @NonNull
            public Ideal build() {
                return new Ideal(this);
            }
        }
    }

    public static final class Card
    implements StripeParamsModel {
        private static final String FIELD_NUMBER = "number";
        private static final String FIELD_EXP_MONTH = "exp_month";
        private static final String FIELD_EXP_YEAR = "exp_year";
        private static final String FIELD_CVC = "cvc";
        private static final String FIELD_TOKEN = "token";
        @Nullable
        private final String mNumber;
        @Nullable
        private final Integer mExpiryMonth;
        @Nullable
        private final Integer mExpiryYear;
        @Nullable
        private final String mCvc;
        @Nullable
        private final String mToken;

        @NonNull
        public static Card create(@NonNull String token) {
            return new Card(token);
        }

        private Card(@NonNull String token) {
            this.mToken = token;
            this.mNumber = null;
            this.mExpiryMonth = null;
            this.mExpiryYear = null;
            this.mCvc = null;
        }

        private Card(@NonNull Builder builder) {
            this.mNumber = builder.mNumber;
            this.mExpiryMonth = builder.mExpiryMonth;
            this.mExpiryYear = builder.mExpiryYear;
            this.mCvc = builder.mCvc;
            this.mToken = null;
        }

        public int hashCode() {
            return Objects.hash(this.mNumber, this.mExpiryMonth, this.mExpiryYear, this.mCvc, this.mToken);
        }

        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof Card && this.typedEquals((Card)obj);
        }

        private boolean typedEquals(@NonNull Card card) {
            return Objects.equals(this.mNumber, card.mNumber) && Objects.equals(this.mCvc, card.mCvc) && Objects.equals(this.mExpiryMonth, card.mExpiryMonth) && Objects.equals(this.mExpiryYear, card.mExpiryYear) && Objects.equals(this.mToken, card.mToken);
        }

        @Override
        @NonNull
        public Map<String, Object> toParamMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.mNumber != null) {
                map.put(FIELD_NUMBER, this.mNumber);
            }
            if (this.mExpiryMonth != null) {
                map.put(FIELD_EXP_MONTH, this.mExpiryMonth);
            }
            if (this.mExpiryYear != null) {
                map.put(FIELD_EXP_YEAR, this.mExpiryYear);
            }
            if (this.mCvc != null) {
                map.put(FIELD_CVC, this.mCvc);
            }
            if (this.mToken != null) {
                map.put(FIELD_TOKEN, this.mToken);
            }
            return map;
        }

        public static final class Builder
        implements ObjectBuilder<Card> {
            @Nullable
            private String mNumber;
            @Nullable
            private Integer mExpiryMonth;
            @Nullable
            private Integer mExpiryYear;
            @Nullable
            private String mCvc;

            @NonNull
            public Builder setNumber(@Nullable String number) {
                this.mNumber = number;
                return this;
            }

            @NonNull
            public Builder setExpiryMonth(@Nullable Integer expiryMonth) {
                this.mExpiryMonth = expiryMonth;
                return this;
            }

            @NonNull
            public Builder setExpiryYear(@Nullable Integer expiryYear) {
                this.mExpiryYear = expiryYear;
                return this;
            }

            @NonNull
            public Builder setCvc(@Nullable String cvc) {
                this.mCvc = cvc;
                return this;
            }

            @Override
            @NonNull
            public Card build() {
                return new Card(this);
            }
        }
    }

    static enum Type {
        Card("card"),
        Ideal("ideal"),
        Fpx("fpx");

        @NonNull
        private final String mCode;

        private Type(String code) {
            this.mCode = code;
        }
    }
}

