/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.stripe3ds2.init.ui.ButtonCustomization;
import com.stripe.android.stripe3ds2.init.ui.LabelCustomization;
import com.stripe.android.stripe3ds2.init.ui.StripeButtonCustomization;
import com.stripe.android.stripe3ds2.init.ui.StripeLabelCustomization;
import com.stripe.android.stripe3ds2.init.ui.StripeTextBoxCustomization;
import com.stripe.android.stripe3ds2.init.ui.StripeToolbarCustomization;
import com.stripe.android.stripe3ds2.init.ui.StripeUiCustomization;
import com.stripe.android.stripe3ds2.init.ui.TextBoxCustomization;
import com.stripe.android.stripe3ds2.init.ui.ToolbarCustomization;
import com.stripe.android.stripe3ds2.init.ui.UiCustomization;
import java.util.Objects;

public final class PaymentAuthConfig {
    @Nullable
    private static PaymentAuthConfig sInstance;
    @NonNull
    private static final PaymentAuthConfig DEFAULT;
    @NonNull
    final Stripe3ds2Config stripe3ds2Config;

    public static void init(@NonNull PaymentAuthConfig config) {
        sInstance = config;
    }

    @NonNull
    public static PaymentAuthConfig get() {
        return sInstance != null ? sInstance : DEFAULT;
    }

    @VisibleForTesting
    static void reset() {
        sInstance = null;
    }

    private PaymentAuthConfig(@NonNull Builder builder) {
        this.stripe3ds2Config = builder.mStripe3ds2Config;
    }

    static {
        DEFAULT = new Builder().set3ds2Config(new Stripe3ds2Config.Builder().build()).build();
    }

    public static final class Stripe3ds2UiCustomization {
        @NonNull
        private final StripeUiCustomization mUiCustomization;

        private Stripe3ds2UiCustomization(@NonNull StripeUiCustomization uiCustomization) {
            this.mUiCustomization = uiCustomization;
        }

        @NonNull
        public StripeUiCustomization getUiCustomization() {
            return this.mUiCustomization;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Stripe3ds2UiCustomization && this.typedEquals((Stripe3ds2UiCustomization)obj);
        }

        private boolean typedEquals(@NonNull Stripe3ds2UiCustomization uiCustomization) {
            return Objects.equals(this.mUiCustomization, uiCustomization.mUiCustomization);
        }

        public int hashCode() {
            return Objects.hash(this.mUiCustomization);
        }

        public static final class Builder
        implements ObjectBuilder<Stripe3ds2UiCustomization> {
            @NonNull
            private final StripeUiCustomization mUiCustomization;

            @NonNull
            public static Builder createWithAppTheme(@NonNull Activity activity) {
                return new Builder(activity);
            }

            public Builder() {
                this.mUiCustomization = new StripeUiCustomization();
            }

            private Builder(@NonNull Activity activity) {
                this.mUiCustomization = StripeUiCustomization.createWithAppTheme((Activity)activity);
            }

            @NonNull
            private UiCustomization.ButtonType getUiButtonType(@NonNull ButtonType buttonType) throws RuntimeException {
                switch (buttonType) {
                    case SUBMIT: {
                        return UiCustomization.ButtonType.SUBMIT;
                    }
                    case CONTINUE: {
                        return UiCustomization.ButtonType.CONTINUE;
                    }
                    case NEXT: {
                        return UiCustomization.ButtonType.NEXT;
                    }
                    case CANCEL: {
                        return UiCustomization.ButtonType.CANCEL;
                    }
                    case RESEND: {
                        return UiCustomization.ButtonType.RESEND;
                    }
                    case SELECT: {
                        return UiCustomization.ButtonType.SELECT;
                    }
                }
                throw new IllegalArgumentException("Invalid Button Type");
            }

            @NonNull
            public Builder setButtonCustomization(@NonNull Stripe3ds2ButtonCustomization buttonCustomization, @NonNull ButtonType buttonType) throws RuntimeException {
                this.mUiCustomization.setButtonCustomization(buttonCustomization.mButtonCustomization, this.getUiButtonType(buttonType));
                return this;
            }

            @NonNull
            public Builder setToolbarCustomization(@NonNull Stripe3ds2ToolbarCustomization toolbarCustomization) throws RuntimeException {
                this.mUiCustomization.setToolbarCustomization(toolbarCustomization.mToolbarCustomization);
                return this;
            }

            @NonNull
            public Builder setLabelCustomization(@NonNull Stripe3ds2LabelCustomization labelCustomization) throws RuntimeException {
                this.mUiCustomization.setLabelCustomization(labelCustomization.mLabelCustomization);
                return this;
            }

            @NonNull
            public Builder setTextBoxCustomization(@NonNull Stripe3ds2TextBoxCustomization textBoxCustomization) throws RuntimeException {
                this.mUiCustomization.setTextBoxCustomization(textBoxCustomization.mTextBoxCustomization);
                return this;
            }

            @NonNull
            public Builder setAccentColor(@NonNull String hexColor) throws RuntimeException {
                this.mUiCustomization.setAccentColor(hexColor);
                return this;
            }

            @Override
            @NonNull
            public Stripe3ds2UiCustomization build() {
                return new Stripe3ds2UiCustomization(this.mUiCustomization);
            }
        }

        public static enum ButtonType {
            SUBMIT,
            CONTINUE,
            NEXT,
            CANCEL,
            RESEND,
            SELECT;

        }
    }

    public static final class Stripe3ds2ToolbarCustomization {
        @NonNull
        final ToolbarCustomization mToolbarCustomization;

        Stripe3ds2ToolbarCustomization(@NonNull ToolbarCustomization toolbarCustomization) {
            this.mToolbarCustomization = toolbarCustomization;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Stripe3ds2ToolbarCustomization && this.typedEquals((Stripe3ds2ToolbarCustomization)obj);
        }

        private boolean typedEquals(@NonNull Stripe3ds2ToolbarCustomization uiCustomization) {
            return Objects.equals(this.mToolbarCustomization, uiCustomization.mToolbarCustomization);
        }

        public int hashCode() {
            return Objects.hash(this.mToolbarCustomization);
        }

        public static final class Builder
        implements ObjectBuilder<Stripe3ds2ToolbarCustomization> {
            @NonNull
            final ToolbarCustomization mToolbarCustomization = new StripeToolbarCustomization();

            @NonNull
            public Builder setBackgroundColor(@NonNull String hexColor) throws RuntimeException {
                this.mToolbarCustomization.setBackgroundColor(hexColor);
                return this;
            }

            @NonNull
            public Builder setStatusBarColor(@NonNull String hexColor) throws RuntimeException {
                this.mToolbarCustomization.setStatusBarColor(hexColor);
                return this;
            }

            @NonNull
            public Builder setHeaderText(@NonNull String headerText) throws RuntimeException {
                this.mToolbarCustomization.setHeaderText(headerText);
                return this;
            }

            @NonNull
            public Builder setButtonText(@NonNull String buttonText) throws RuntimeException {
                this.mToolbarCustomization.setButtonText(buttonText);
                return this;
            }

            @NonNull
            public Builder setTextFontName(@NonNull String fontName) throws RuntimeException {
                this.mToolbarCustomization.setTextFontName(fontName);
                return this;
            }

            @NonNull
            public Builder setTextColor(@NonNull String hexColor) throws RuntimeException {
                this.mToolbarCustomization.setTextColor(hexColor);
                return this;
            }

            @NonNull
            public Builder setTextFontSize(int fontSize) throws RuntimeException {
                this.mToolbarCustomization.setTextFontSize(fontSize);
                return this;
            }

            @Override
            @NonNull
            public Stripe3ds2ToolbarCustomization build() {
                return new Stripe3ds2ToolbarCustomization(this.mToolbarCustomization);
            }
        }
    }

    public static final class Stripe3ds2TextBoxCustomization {
        @NonNull
        final TextBoxCustomization mTextBoxCustomization;

        Stripe3ds2TextBoxCustomization(@NonNull TextBoxCustomization textBoxCustomization) {
            this.mTextBoxCustomization = textBoxCustomization;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Stripe3ds2TextBoxCustomization && this.typedEquals((Stripe3ds2TextBoxCustomization)obj);
        }

        private boolean typedEquals(@NonNull Stripe3ds2TextBoxCustomization uiCustomization) {
            return Objects.equals(this.mTextBoxCustomization, uiCustomization.mTextBoxCustomization);
        }

        public int hashCode() {
            return Objects.hash(this.mTextBoxCustomization);
        }

        public static final class Builder
        implements ObjectBuilder<Stripe3ds2TextBoxCustomization> {
            @NonNull
            final TextBoxCustomization mTextBoxCustomization = new StripeTextBoxCustomization();

            @NonNull
            public Builder setBorderWidth(int borderWidth) throws RuntimeException {
                this.mTextBoxCustomization.setBorderWidth(borderWidth);
                return this;
            }

            @NonNull
            public Builder setBorderColor(@NonNull String hexColor) throws RuntimeException {
                this.mTextBoxCustomization.setBorderColor(hexColor);
                return this;
            }

            @NonNull
            public Builder setCornerRadius(int cornerRadius) throws RuntimeException {
                this.mTextBoxCustomization.setCornerRadius(cornerRadius);
                return this;
            }

            @NonNull
            public Builder setTextFontName(@NonNull String fontName) throws RuntimeException {
                this.mTextBoxCustomization.setTextFontName(fontName);
                return this;
            }

            @NonNull
            public Builder setTextColor(@NonNull String hexColor) throws RuntimeException {
                this.mTextBoxCustomization.setTextColor(hexColor);
                return this;
            }

            @NonNull
            public Builder setTextFontSize(int fontSize) throws RuntimeException {
                this.mTextBoxCustomization.setTextFontSize(fontSize);
                return this;
            }

            @Override
            @NonNull
            public Stripe3ds2TextBoxCustomization build() {
                return new Stripe3ds2TextBoxCustomization(this.mTextBoxCustomization);
            }
        }
    }

    public static final class Stripe3ds2LabelCustomization {
        @NonNull
        final LabelCustomization mLabelCustomization;

        Stripe3ds2LabelCustomization(@NonNull LabelCustomization labelCustomization) {
            this.mLabelCustomization = labelCustomization;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Stripe3ds2LabelCustomization && this.typedEquals((Stripe3ds2LabelCustomization)obj);
        }

        private boolean typedEquals(@NonNull Stripe3ds2LabelCustomization uiCustomization) {
            return Objects.equals(this.mLabelCustomization, uiCustomization.mLabelCustomization);
        }

        public int hashCode() {
            return Objects.hash(this.mLabelCustomization);
        }

        public static final class Builder
        implements ObjectBuilder<Stripe3ds2LabelCustomization> {
            @NonNull
            final LabelCustomization mLabelCustomization = new StripeLabelCustomization();

            @NonNull
            public Builder setHeadingTextColor(@NonNull String hexColor) throws RuntimeException {
                this.mLabelCustomization.setHeadingTextColor(hexColor);
                return this;
            }

            @NonNull
            public Builder setHeadingTextFontName(@NonNull String fontName) throws RuntimeException {
                this.mLabelCustomization.setHeadingTextFontName(fontName);
                return this;
            }

            @NonNull
            public Builder setHeadingTextFontSize(int fontSize) throws RuntimeException {
                this.mLabelCustomization.setHeadingTextFontSize(fontSize);
                return this;
            }

            @NonNull
            public Builder setTextFontName(@NonNull String fontName) throws RuntimeException {
                this.mLabelCustomization.setTextFontName(fontName);
                return this;
            }

            @NonNull
            public Builder setTextColor(@NonNull String hexColor) throws RuntimeException {
                this.mLabelCustomization.setTextColor(hexColor);
                return this;
            }

            @NonNull
            public Builder setTextFontSize(int fontSize) throws RuntimeException {
                this.mLabelCustomization.setTextFontSize(fontSize);
                return this;
            }

            @Override
            @NonNull
            public Stripe3ds2LabelCustomization build() {
                return new Stripe3ds2LabelCustomization(this.mLabelCustomization);
            }
        }
    }

    public static final class Stripe3ds2ButtonCustomization {
        @NonNull
        final ButtonCustomization mButtonCustomization;

        Stripe3ds2ButtonCustomization(@NonNull ButtonCustomization buttonCustomization) {
            this.mButtonCustomization = buttonCustomization;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof Stripe3ds2ButtonCustomization && this.typedEquals((Stripe3ds2ButtonCustomization)obj);
        }

        private boolean typedEquals(@NonNull Stripe3ds2ButtonCustomization uiCustomization) {
            return Objects.equals(this.mButtonCustomization, uiCustomization.mButtonCustomization);
        }

        public int hashCode() {
            return Objects.hash(this.mButtonCustomization);
        }

        public static final class Builder
        implements ObjectBuilder<Stripe3ds2ButtonCustomization> {
            @NonNull
            final ButtonCustomization mButtonCustomization = new StripeButtonCustomization();

            @NonNull
            public Builder setBackgroundColor(@NonNull String hexColor) throws RuntimeException {
                this.mButtonCustomization.setBackgroundColor(hexColor);
                return this;
            }

            @NonNull
            public Builder setCornerRadius(int cornerRadius) throws RuntimeException {
                this.mButtonCustomization.setCornerRadius(cornerRadius);
                return this;
            }

            @NonNull
            public Builder setTextFontName(@NonNull String fontName) throws RuntimeException {
                this.mButtonCustomization.setTextFontName(fontName);
                return this;
            }

            @NonNull
            public Builder setTextColor(@NonNull String hexColor) throws RuntimeException {
                this.mButtonCustomization.setTextColor(hexColor);
                return this;
            }

            @NonNull
            public Builder setTextFontSize(int fontSize) throws RuntimeException {
                this.mButtonCustomization.setTextFontSize(fontSize);
                return this;
            }

            @Override
            @NonNull
            public Stripe3ds2ButtonCustomization build() {
                return new Stripe3ds2ButtonCustomization(this.mButtonCustomization);
            }
        }
    }

    public static final class Stripe3ds2Config {
        static final int DEFAULT_TIMEOUT = 5;
        final int timeout;
        @NonNull
        final Stripe3ds2UiCustomization uiCustomization;

        private Stripe3ds2Config(@NonNull Builder builder) {
            this.timeout = this.checkValidTimeout(builder.mTimeout);
            this.uiCustomization = Objects.requireNonNull(builder.mUiCustomization);
        }

        private int checkValidTimeout(int timeout) {
            if (timeout < 5 || timeout > 99) {
                throw new IllegalArgumentException("Timeout value must be between 5 and 99, inclusive");
            }
            return timeout;
        }

        public static final class Builder
        implements ObjectBuilder<Stripe3ds2Config> {
            private int mTimeout = 5;
            private Stripe3ds2UiCustomization mUiCustomization = new Stripe3ds2UiCustomization.Builder().build();

            @NonNull
            public Builder setTimeout(@IntRange(from=5L, to=99L) int timeout) {
                this.mTimeout = timeout;
                return this;
            }

            @NonNull
            public Builder setUiCustomization(@NonNull Stripe3ds2UiCustomization uiCustomization) {
                this.mUiCustomization = uiCustomization;
                return this;
            }

            @Override
            @NonNull
            public Stripe3ds2Config build() {
                return new Stripe3ds2Config(this);
            }
        }
    }

    public static final class Builder
    implements ObjectBuilder<PaymentAuthConfig> {
        private Stripe3ds2Config mStripe3ds2Config;

        @NonNull
        public Builder set3ds2Config(@NonNull Stripe3ds2Config stripe3ds2Config) {
            this.mStripe3ds2Config = stripe3ds2Config;
            return this;
        }

        @Override
        @NonNull
        public PaymentAuthConfig build() {
            return new PaymentAuthConfig(this);
        }
    }
}

