/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.model.Address;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.model.StripeParamsModel;
import com.stripe.android.model.wallets.Wallet;
import com.stripe.android.model.wallets.WalletFactory;
import com.stripe.android.utils.ObjectUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class PaymentMethod
extends StripeModel
implements Parcelable {
    private static final String FIELD_ID = "id";
    private static final String FIELD_BILLING_DETAILS = "billing_details";
    private static final String FIELD_CREATED = "created";
    private static final String FIELD_CUSTOMER = "customer";
    private static final String FIELD_LIVEMODE = "livemode";
    private static final String FIELD_METADATA = "metadata";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_CARD = "card";
    private static final String FIELD_CARD_PRESENT = "card_present";
    private static final String FIELD_FPX = "fpx";
    private static final String FIELD_IDEAL = "ideal";
    @Nullable
    public final String id;
    @Nullable
    public final Long created;
    public final boolean liveMode;
    @Nullable
    public final String type;
    @Nullable
    public final BillingDetails billingDetails;
    @Nullable
    public final String customerId;
    @Nullable
    public final Map<String, String> metadata;
    @Nullable
    public final Card card;
    @Nullable
    public final CardPresent cardPresent;
    @Nullable
    public final Fpx fpx;
    @Nullable
    public final Ideal ideal;
    public static final Parcelable.Creator<PaymentMethod> CREATOR = new Parcelable.Creator<PaymentMethod>(){

        @NonNull
        public PaymentMethod createFromParcel(@NonNull Parcel in) {
            return new PaymentMethod(in);
        }

        public PaymentMethod[] newArray(int size) {
            return new PaymentMethod[size];
        }
    };

    private PaymentMethod(@NonNull Builder builder) {
        this.id = builder.mId;
        this.liveMode = builder.mLiveMode;
        this.type = builder.mType;
        this.created = builder.mCreated;
        this.billingDetails = builder.mBillingDetails;
        this.customerId = builder.mCustomerId;
        this.metadata = builder.mMetadata;
        this.card = builder.mCard;
        this.cardPresent = builder.mCardPresent;
        this.fpx = builder.mFpx;
        this.ideal = builder.mIdeal;
    }

    public boolean isValid() {
        return this.type != null;
    }

    @Nullable
    public static PaymentMethod fromString(@Nullable String jsonString) {
        if (jsonString == null) {
            return null;
        }
        try {
            return PaymentMethod.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static PaymentMethod fromJson(@Nullable JSONObject paymentMethod) {
        if (paymentMethod == null) {
            return null;
        }
        String type = StripeJsonUtils.optString(paymentMethod, FIELD_TYPE);
        Builder builder = new Builder().setId(StripeJsonUtils.optString(paymentMethod, FIELD_ID)).setType(type).setCreated(StripeJsonUtils.optLong(paymentMethod, FIELD_CREATED)).setBillingDetails(BillingDetails.fromJson(paymentMethod.optJSONObject(FIELD_BILLING_DETAILS))).setCustomerId(StripeJsonUtils.optString(paymentMethod, FIELD_CUSTOMER)).setLiveMode(Boolean.TRUE.equals(paymentMethod.optBoolean(FIELD_LIVEMODE))).setMetadata(StripeJsonUtils.optHash(paymentMethod, FIELD_METADATA));
        if (FIELD_CARD.equals(type)) {
            builder.setCard(Card.fromJson(paymentMethod.optJSONObject(FIELD_CARD)));
        } else if (FIELD_CARD_PRESENT.equals(type)) {
            builder.setCardPresent(CardPresent.EMPTY);
        } else if (FIELD_IDEAL.equals(type)) {
            builder.setIdeal(Ideal.fromJson(paymentMethod.optJSONObject(FIELD_IDEAL)));
        } else if (FIELD_FPX.equals(type)) {
            builder.setFpx(Fpx.fromJson(paymentMethod.optJSONObject(FIELD_FPX)));
        }
        return builder.build();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof PaymentMethod && this.typedEquals((PaymentMethod)obj);
    }

    private boolean typedEquals(@NonNull PaymentMethod paymentMethod) {
        return ObjectUtils.equals(this.id, paymentMethod.id) && ObjectUtils.equals(this.created, paymentMethod.created) && this.liveMode == paymentMethod.liveMode && ObjectUtils.equals(this.type, paymentMethod.type) && ObjectUtils.equals(this.billingDetails, paymentMethod.billingDetails) && ObjectUtils.equals(this.card, paymentMethod.card) && ObjectUtils.equals(this.cardPresent, paymentMethod.cardPresent) && ObjectUtils.equals(this.fpx, paymentMethod.fpx) && ObjectUtils.equals(this.ideal, paymentMethod.ideal) && ObjectUtils.equals(this.customerId, paymentMethod.customerId);
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hash(this.id, this.created, this.liveMode, this.type, this.billingDetails, this.card, this.cardPresent, this.fpx, this.ideal, this.customerId);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        if (this.created == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeLong(this.created.longValue());
        }
        dest.writeByte((byte)(this.liveMode ? 1 : 0));
        dest.writeString(this.type);
        dest.writeParcelable((Parcelable)this.billingDetails, flags);
        dest.writeParcelable((Parcelable)this.card, flags);
        dest.writeParcelable((Parcelable)this.cardPresent, flags);
        dest.writeParcelable((Parcelable)this.fpx, flags);
        dest.writeParcelable((Parcelable)this.ideal, flags);
        dest.writeString(this.customerId);
        dest.writeInt(this.metadata == null ? -1 : this.metadata.size());
        if (this.metadata != null) {
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                dest.writeString(entry.getKey());
                dest.writeString(entry.getValue());
            }
        }
    }

    private PaymentMethod(@NonNull Parcel in) {
        this.id = in.readString();
        this.created = in.readByte() == 0 ? null : Long.valueOf(in.readLong());
        this.liveMode = in.readByte() != 0;
        this.type = in.readString();
        this.billingDetails = (BillingDetails)in.readParcelable(BillingDetails.class.getClassLoader());
        this.card = (Card)in.readParcelable(Card.class.getClassLoader());
        this.cardPresent = (CardPresent)in.readParcelable(CardPresent.class.getClassLoader());
        this.fpx = (Fpx)in.readParcelable(Fpx.class.getClassLoader());
        this.ideal = (Ideal)in.readParcelable(Ideal.class.getClassLoader());
        this.customerId = in.readString();
        int mapSize = in.readInt();
        if (mapSize >= 0) {
            HashMap<String, String> metadata = new HashMap<String, String>(mapSize);
            for (int i = 0; i < mapSize; ++i) {
                String key = in.readString();
                String value = in.readString();
                if (key == null || value == null) continue;
                metadata.put(key, value);
            }
            this.metadata = metadata;
        } else {
            this.metadata = null;
        }
    }

    private static abstract class PaymentMethodTypeImpl
    extends StripeModel
    implements Parcelable {
        @NonNull
        public final Type type;

        private PaymentMethodTypeImpl(@NonNull Type type) {
            this.type = type;
        }

        private PaymentMethodTypeImpl(@NonNull Parcel in) {
            this.type = Type.valueOf(in.readString());
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.type.name());
        }
    }

    public static final class Fpx
    extends PaymentMethodTypeImpl {
        private static final String FIELD_ACCOUNT_HOLDER_TYPE = "account_holder_type";
        private static final String FIELD_BANK = "bank";
        @Nullable
        public final String bank;
        @Nullable
        public final String accountHolderType;
        public static final Parcelable.Creator<Fpx> CREATOR = new Parcelable.Creator<Fpx>(){

            public Fpx createFromParcel(@NonNull Parcel in) {
                return new Fpx(in);
            }

            public Fpx[] newArray(int size) {
                return new Fpx[size];
            }
        };

        private Fpx(@NonNull Builder builder) {
            super(Type.Fpx);
            this.bank = builder.mBank;
            this.accountHolderType = builder.mAccountHolderType;
        }

        private Fpx(@NonNull Parcel in) {
            super(in);
            this.bank = in.readString();
            this.accountHolderType = in.readString();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeString(this.bank);
            dest.writeString(this.accountHolderType);
        }

        @Nullable
        public static Fpx fromJson(@Nullable JSONObject fpx) {
            if (fpx == null) {
                return null;
            }
            return new Builder().setBank(StripeJsonUtils.optString(fpx, FIELD_BANK)).setAccountHolderType(StripeJsonUtils.optString(fpx, FIELD_ACCOUNT_HOLDER_TYPE)).build();
        }

        @Override
        public int hashCode() {
            return ObjectUtils.hash(this.bank, this.accountHolderType);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof Fpx && this.typedEquals((Fpx)obj);
        }

        private boolean typedEquals(@NonNull Fpx obj) {
            return ObjectUtils.equals(this.bank, obj.bank) && ObjectUtils.equals(this.accountHolderType, obj.accountHolderType);
        }

        public static final class Builder
        implements ObjectBuilder<Fpx> {
            private String mBank;
            private String mAccountHolderType;

            @NonNull
            public Builder setBank(@Nullable String bank) {
                this.mBank = bank;
                return this;
            }

            @NonNull
            public Builder setAccountHolderType(@Nullable String bankIdentifierCode) {
                this.mAccountHolderType = bankIdentifierCode;
                return this;
            }

            @Override
            @NonNull
            public Fpx build() {
                return new Fpx(this);
            }
        }
    }

    public static final class Ideal
    extends PaymentMethodTypeImpl {
        private static final String FIELD_BANK = "bank";
        private static final String FIELD_BIC = "bic";
        @Nullable
        public final String bank;
        @Nullable
        public final String bankIdentifierCode;
        public static final Parcelable.Creator<Ideal> CREATOR = new Parcelable.Creator<Ideal>(){

            public Ideal createFromParcel(@NonNull Parcel in) {
                return new Ideal(in);
            }

            public Ideal[] newArray(int size) {
                return new Ideal[size];
            }
        };

        private Ideal(@NonNull Builder builder) {
            super(Type.Ideal);
            this.bank = builder.mBank;
            this.bankIdentifierCode = builder.mBankIdentifierCode;
        }

        private Ideal(@NonNull Parcel in) {
            super(in);
            this.bank = in.readString();
            this.bankIdentifierCode = in.readString();
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeString(this.bank);
            dest.writeString(this.bankIdentifierCode);
        }

        @Nullable
        public static Ideal fromJson(@Nullable JSONObject ideal) {
            if (ideal == null) {
                return null;
            }
            return new Builder().setBank(StripeJsonUtils.optString(ideal, FIELD_BANK)).setBankIdentifierCode(StripeJsonUtils.optString(ideal, FIELD_BIC)).build();
        }

        @Override
        public int hashCode() {
            return ObjectUtils.hash(this.bank, this.bankIdentifierCode);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof Ideal && this.typedEquals((Ideal)obj);
        }

        private boolean typedEquals(@NonNull Ideal obj) {
            return ObjectUtils.equals(this.bank, obj.bank) && ObjectUtils.equals(this.bankIdentifierCode, obj.bankIdentifierCode);
        }

        public static final class Builder
        implements ObjectBuilder<Ideal> {
            private String mBank;
            private String mBankIdentifierCode;

            @NonNull
            public Builder setBank(@Nullable String bank) {
                this.mBank = bank;
                return this;
            }

            @NonNull
            public Builder setBankIdentifierCode(@Nullable String bankIdentifierCode) {
                this.mBankIdentifierCode = bankIdentifierCode;
                return this;
            }

            @Override
            @NonNull
            public Ideal build() {
                return new Ideal(this);
            }
        }
    }

    public static final class CardPresent
    extends PaymentMethodTypeImpl {
        public static final CardPresent EMPTY = new CardPresent();
        public static final Parcelable.Creator<CardPresent> CREATOR = new Parcelable.Creator<CardPresent>(){

            public CardPresent createFromParcel(@NonNull Parcel in) {
                return new CardPresent(in);
            }

            public CardPresent[] newArray(int size) {
                return new CardPresent[size];
            }
        };

        private CardPresent() {
            super(Type.CardPresent);
        }

        private CardPresent(@NonNull Parcel in) {
            super(in);
        }

        @Override
        public int hashCode() {
            return ObjectUtils.hash(new Object[]{this.type});
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof CardPresent && this.typedEquals((CardPresent)obj);
        }

        private boolean typedEquals(@NonNull CardPresent obj) {
            return ObjectUtils.equals((Object)this.type, (Object)obj.type);
        }
    }

    public static final class Card
    extends PaymentMethodTypeImpl {
        private static final String FIELD_BRAND = "brand";
        private static final String FIELD_CHECKS = "checks";
        private static final String FIELD_COUNTRY = "country";
        private static final String FIELD_EXP_MONTH = "exp_month";
        private static final String FIELD_EXP_YEAR = "exp_year";
        private static final String FIELD_FUNDING = "funding";
        private static final String FIELD_LAST4 = "last4";
        private static final String FIELD_THREE_D_SECURE_USAGE = "three_d_secure_usage";
        private static final String FIELD_WALLET = "wallet";
        @Nullable
        public final String brand;
        @Nullable
        public final Checks checks;
        @Nullable
        public final String country;
        @Nullable
        public final Integer expiryMonth;
        @Nullable
        public final Integer expiryYear;
        @Nullable
        public final String funding;
        @Nullable
        public final String last4;
        @Nullable
        public final ThreeDSecureUsage threeDSecureUsage;
        @Nullable
        public final Wallet wallet;
        public static final Parcelable.Creator<Card> CREATOR = new Parcelable.Creator<Card>(){

            public Card createFromParcel(@NonNull Parcel in) {
                return new Card(in);
            }

            public Card[] newArray(int size) {
                return new Card[size];
            }
        };

        private Card(@NonNull Builder builder) {
            super(Type.Card);
            this.brand = builder.mBrand;
            this.checks = builder.checks;
            this.country = builder.mCountry;
            this.expiryMonth = builder.mExpiryMonth;
            this.expiryYear = builder.mExpiryYear;
            this.funding = builder.mFunding;
            this.last4 = builder.mLast4;
            this.threeDSecureUsage = builder.mThreeDSecureUsage;
            this.wallet = builder.mWallet;
        }

        private Card(@NonNull Parcel in) {
            super(in);
            this.brand = in.readString();
            this.checks = (Checks)in.readParcelable(Checks.class.getClassLoader());
            this.country = in.readString();
            this.expiryMonth = in.readByte() == 0 ? null : Integer.valueOf(in.readInt());
            this.expiryYear = in.readByte() == 0 ? null : Integer.valueOf(in.readInt());
            this.funding = in.readString();
            this.last4 = in.readString();
            this.threeDSecureUsage = (ThreeDSecureUsage)in.readParcelable(ThreeDSecureUsage.class.getClassLoader());
            this.wallet = (Wallet)in.readParcelable(Wallet.class.getClassLoader());
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeString(this.brand);
            dest.writeParcelable((Parcelable)this.checks, flags);
            dest.writeString(this.country);
            if (this.expiryMonth == null) {
                dest.writeByte((byte)0);
            } else {
                dest.writeByte((byte)1);
                dest.writeInt(this.expiryMonth.intValue());
            }
            if (this.expiryYear == null) {
                dest.writeByte((byte)0);
            } else {
                dest.writeByte((byte)1);
                dest.writeInt(this.expiryYear.intValue());
            }
            dest.writeString(this.funding);
            dest.writeString(this.last4);
            dest.writeParcelable((Parcelable)this.threeDSecureUsage, flags);
            dest.writeParcelable((Parcelable)this.wallet, flags);
        }

        @Nullable
        public static Card fromJson(@Nullable JSONObject cardJson) {
            if (cardJson == null) {
                return null;
            }
            return new Builder().setBrand(StripeJsonUtils.optString(cardJson, FIELD_BRAND)).setChecks(Checks.fromJson(cardJson.optJSONObject(FIELD_CHECKS))).setCountry(StripeJsonUtils.optString(cardJson, FIELD_COUNTRY)).setExpiryMonth(StripeJsonUtils.optInteger(cardJson, FIELD_EXP_MONTH)).setExpiryYear(StripeJsonUtils.optInteger(cardJson, FIELD_EXP_YEAR)).setFunding(StripeJsonUtils.optString(cardJson, FIELD_FUNDING)).setLast4(StripeJsonUtils.optString(cardJson, FIELD_LAST4)).setThreeDSecureUsage(ThreeDSecureUsage.fromJson(cardJson.optJSONObject(FIELD_THREE_D_SECURE_USAGE))).setWallet(new WalletFactory().create(cardJson.optJSONObject(FIELD_WALLET))).build();
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj || obj instanceof Card && this.typedEquals((Card)obj);
        }

        private boolean typedEquals(@NonNull Card card) {
            return ObjectUtils.equals(this.brand, card.brand) && ObjectUtils.equals(this.checks, card.checks) && ObjectUtils.equals(this.country, card.country) && ObjectUtils.equals(this.expiryMonth, card.expiryMonth) && ObjectUtils.equals(this.expiryYear, card.expiryYear) && ObjectUtils.equals(this.funding, card.funding) && ObjectUtils.equals(this.last4, card.last4) && ObjectUtils.equals(this.threeDSecureUsage, card.threeDSecureUsage) && ObjectUtils.equals(this.wallet, card.wallet);
        }

        @Override
        public int hashCode() {
            return ObjectUtils.hash(this.brand, this.checks, this.country, this.expiryMonth, this.expiryYear, this.funding, this.last4, this.threeDSecureUsage, this.wallet);
        }

        public static final class ThreeDSecureUsage
        extends StripeModel
        implements Parcelable {
            private static final String FIELD_IS_SUPPORTED = "supported";
            public final boolean isSupported;
            public static final Parcelable.Creator<ThreeDSecureUsage> CREATOR = new Parcelable.Creator<ThreeDSecureUsage>(){

                public ThreeDSecureUsage createFromParcel(@NonNull Parcel in) {
                    return new ThreeDSecureUsage(in);
                }

                public ThreeDSecureUsage[] newArray(int size) {
                    return new ThreeDSecureUsage[size];
                }
            };

            private ThreeDSecureUsage(@NonNull Builder builder) {
                this.isSupported = builder.mIsSupported;
            }

            private ThreeDSecureUsage(@NonNull Parcel in) {
                this.isSupported = in.readByte() != 0;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeByte((byte)(this.isSupported ? 1 : 0));
            }

            @Nullable
            public static ThreeDSecureUsage fromJson(@Nullable JSONObject threeDSecureUsage) {
                if (threeDSecureUsage == null) {
                    return null;
                }
                return new Builder().setSupported(Boolean.TRUE.equals(StripeJsonUtils.optBoolean(threeDSecureUsage, FIELD_IS_SUPPORTED))).build();
            }

            @Override
            public int hashCode() {
                return ObjectUtils.hash(this.isSupported);
            }

            @Override
            public boolean equals(@Nullable Object obj) {
                return this == obj || obj instanceof ThreeDSecureUsage && this.typedEquals((ThreeDSecureUsage)obj);
            }

            private boolean typedEquals(@NonNull ThreeDSecureUsage threeDSecureUsage) {
                return this.isSupported == threeDSecureUsage.isSupported;
            }

            public static final class Builder
            implements ObjectBuilder<ThreeDSecureUsage> {
                private boolean mIsSupported;

                @NonNull
                public Builder setSupported(boolean supported) {
                    this.mIsSupported = supported;
                    return this;
                }

                @Override
                @NonNull
                public ThreeDSecureUsage build() {
                    return new ThreeDSecureUsage(this);
                }
            }
        }

        public static final class Checks
        extends StripeModel
        implements Parcelable {
            private static final String FIELD_ADDRESS_LINE1_CHECK = "address_line1_check";
            private static final String FIELD_ADDRESS_POSTAL_CODE_CHECK = "address_postal_code_check";
            private static final String FIELD_CVC_CHECK = "cvc_check";
            @Nullable
            public final String addressLine1Check;
            @Nullable
            public final String addressPostalCodeCheck;
            @Nullable
            public final String cvcCheck;
            public static final Parcelable.Creator<Checks> CREATOR = new Parcelable.Creator<Checks>(){

                public Checks createFromParcel(@NonNull Parcel in) {
                    return new Checks(in);
                }

                public Checks[] newArray(int size) {
                    return new Checks[size];
                }
            };

            private Checks(@NonNull Builder builder) {
                this.addressLine1Check = builder.addressLine1Check;
                this.addressPostalCodeCheck = builder.addressPostalCodeCheck;
                this.cvcCheck = builder.cvcCheck;
            }

            private Checks(@NonNull Parcel in) {
                this.addressLine1Check = in.readString();
                this.addressPostalCodeCheck = in.readString();
                this.cvcCheck = in.readString();
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                dest.writeString(this.addressLine1Check);
                dest.writeString(this.addressPostalCodeCheck);
                dest.writeString(this.cvcCheck);
            }

            @Nullable
            public static Checks fromJson(@Nullable JSONObject checksJson) {
                if (checksJson == null) {
                    return null;
                }
                return new Builder().setAddressLine1Check(StripeJsonUtils.optString(checksJson, FIELD_ADDRESS_LINE1_CHECK)).setAddressPostalCodeCheck(StripeJsonUtils.optString(checksJson, FIELD_ADDRESS_POSTAL_CODE_CHECK)).setCvcCheck(StripeJsonUtils.optString(checksJson, FIELD_CVC_CHECK)).build();
            }

            @Override
            public boolean equals(Object obj) {
                return this == obj || obj instanceof Checks && this.typedEquals((Checks)obj);
            }

            private boolean typedEquals(@NonNull Checks checks) {
                return ObjectUtils.equals(this.addressLine1Check, checks.addressLine1Check) && ObjectUtils.equals(this.addressPostalCodeCheck, checks.addressPostalCodeCheck) && ObjectUtils.equals(this.cvcCheck, checks.cvcCheck);
            }

            @Override
            public int hashCode() {
                return ObjectUtils.hash(this.addressLine1Check, this.addressPostalCodeCheck, this.cvcCheck);
            }

            public static final class Builder
            implements ObjectBuilder<Checks> {
                @Nullable
                private String addressLine1Check;
                @Nullable
                private String addressPostalCodeCheck;
                @Nullable
                private String cvcCheck;

                @NonNull
                public Builder setAddressLine1Check(@Nullable String addressLine1Check) {
                    this.addressLine1Check = addressLine1Check;
                    return this;
                }

                @NonNull
                public Builder setAddressPostalCodeCheck(@Nullable String addressPostalCodeCheck) {
                    this.addressPostalCodeCheck = addressPostalCodeCheck;
                    return this;
                }

                @NonNull
                public Builder setCvcCheck(@Nullable String cvcCheck) {
                    this.cvcCheck = cvcCheck;
                    return this;
                }

                @Override
                @NonNull
                public Checks build() {
                    return new Checks(this);
                }
            }
        }

        public static final class Builder
        implements ObjectBuilder<Card> {
            private String mBrand;
            private Checks checks;
            private String mCountry;
            private Integer mExpiryMonth;
            private Integer mExpiryYear;
            private String mFunding;
            private String mLast4;
            private ThreeDSecureUsage mThreeDSecureUsage;
            private Wallet mWallet;

            @NonNull
            public Builder setBrand(@Nullable String brand) {
                this.mBrand = brand;
                return this;
            }

            @NonNull
            public Builder setChecks(@Nullable Checks checks) {
                this.checks = checks;
                return this;
            }

            @NonNull
            public Builder setCountry(@Nullable String country) {
                this.mCountry = country;
                return this;
            }

            @NonNull
            public Builder setExpiryMonth(@Nullable Integer expiryMonth) {
                this.mExpiryMonth = expiryMonth;
                return this;
            }

            @NonNull
            public Builder setExpiryYear(@Nullable Integer expiryYear) {
                this.mExpiryYear = expiryYear;
                return this;
            }

            @NonNull
            public Builder setFunding(@Nullable String funding) {
                this.mFunding = funding;
                return this;
            }

            @NonNull
            public Builder setLast4(@Nullable String last4) {
                this.mLast4 = last4;
                return this;
            }

            @NonNull
            public Builder setThreeDSecureUsage(@Nullable ThreeDSecureUsage threeDSecureUsage) {
                this.mThreeDSecureUsage = threeDSecureUsage;
                return this;
            }

            @NonNull
            public Builder setWallet(@Nullable Wallet wallet) {
                this.mWallet = wallet;
                return this;
            }

            @Override
            @NonNull
            public Card build() {
                return new Card(this);
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Brand {
            public static final String AMERICAN_EXPRESS = "amex";
            public static final String DISCOVER = "discover";
            public static final String JCB = "jcb";
            public static final String DINERS_CLUB = "diners";
            public static final String VISA = "visa";
            public static final String MASTERCARD = "mastercard";
            public static final String UNIONPAY = "unionpay";
            public static final String UNKNOWN = "unknown";
        }
    }

    public static final class BillingDetails
    extends StripeModel
    implements StripeParamsModel,
    Parcelable {
        static final String FIELD_ADDRESS = "address";
        static final String FIELD_EMAIL = "email";
        static final String FIELD_NAME = "name";
        static final String FIELD_PHONE = "phone";
        @Nullable
        public final Address address;
        public final String email;
        public final String name;
        public final String phone;
        public static final Parcelable.Creator<BillingDetails> CREATOR = new Parcelable.Creator<BillingDetails>(){

            public BillingDetails createFromParcel(@NonNull Parcel in) {
                return new BillingDetails(in);
            }

            public BillingDetails[] newArray(int size) {
                return new BillingDetails[size];
            }
        };

        private BillingDetails(@NonNull Builder builder) {
            this.address = builder.mAddress;
            this.email = builder.mEmail;
            this.name = builder.mName;
            this.phone = builder.mPhone;
        }

        private BillingDetails(@NonNull Parcel in) {
            this.address = (Address)in.readParcelable(Address.class.getClassLoader());
            this.email = in.readString();
            this.name = in.readString();
            this.phone = in.readString();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeParcelable((Parcelable)this.address, flags);
            dest.writeString(this.email);
            dest.writeString(this.name);
            dest.writeString(this.phone);
        }

        @Override
        @NonNull
        public Map<String, Object> toParamMap() {
            HashMap<String, Object> billingDetails = new HashMap<String, Object>();
            if (this.address != null) {
                billingDetails.put(FIELD_ADDRESS, this.address.toParamMap());
            }
            if (this.email != null) {
                billingDetails.put(FIELD_EMAIL, this.email);
            }
            if (this.name != null) {
                billingDetails.put(FIELD_NAME, this.name);
            }
            if (this.phone != null) {
                billingDetails.put(FIELD_PHONE, this.phone);
            }
            return billingDetails;
        }

        @Nullable
        public static BillingDetails fromJson(@Nullable JSONObject billingDetails) {
            if (billingDetails == null) {
                return null;
            }
            return new Builder().setAddress(Address.fromJson(billingDetails.optJSONObject(FIELD_ADDRESS))).setEmail(StripeJsonUtils.optString(billingDetails, FIELD_EMAIL)).setName(StripeJsonUtils.optString(billingDetails, FIELD_NAME)).setPhone(StripeJsonUtils.optString(billingDetails, FIELD_PHONE)).build();
        }

        @Override
        public int hashCode() {
            return ObjectUtils.hash(this.address, this.email, this.name, this.phone);
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return this == obj || obj instanceof BillingDetails && this.typedEquals((BillingDetails)obj);
        }

        private boolean typedEquals(@NonNull BillingDetails obj) {
            return ObjectUtils.equals(this.address, obj.address) && ObjectUtils.equals(this.email, obj.email) && ObjectUtils.equals(this.name, obj.name) && ObjectUtils.equals(this.phone, obj.phone);
        }

        public static final class Builder
        implements ObjectBuilder<BillingDetails> {
            private Address mAddress;
            private String mEmail;
            private String mName;
            private String mPhone;

            @NonNull
            public Builder setAddress(@Nullable Address address) {
                this.mAddress = address;
                return this;
            }

            @NonNull
            public Builder setEmail(@Nullable String email) {
                this.mEmail = email;
                return this;
            }

            @NonNull
            public Builder setName(@Nullable String name) {
                this.mName = name;
                return this;
            }

            @NonNull
            public Builder setPhone(@Nullable String phone) {
                this.mPhone = phone;
                return this;
            }

            @Override
            @NonNull
            public BillingDetails build() {
                return new BillingDetails(this);
            }
        }
    }

    public static final class Builder
    implements ObjectBuilder<PaymentMethod> {
        private String mId;
        private Long mCreated;
        private boolean mLiveMode;
        private String mType;
        private BillingDetails mBillingDetails;
        private Map<String, String> mMetadata;
        private String mCustomerId;
        private Card mCard;
        private CardPresent mCardPresent;
        private Ideal mIdeal;
        private Fpx mFpx;

        @NonNull
        public Builder setId(@Nullable String id) {
            this.mId = id;
            return this;
        }

        @NonNull
        public Builder setCreated(@Nullable Long created) {
            this.mCreated = created;
            return this;
        }

        @NonNull
        public Builder setLiveMode(boolean liveMode) {
            this.mLiveMode = liveMode;
            return this;
        }

        @NonNull
        public Builder setMetadata(@Nullable Map<String, String> metadata) {
            this.mMetadata = metadata;
            return this;
        }

        @NonNull
        public Builder setType(@Nullable String type) {
            this.mType = type;
            return this;
        }

        @NonNull
        public Builder setBillingDetails(@Nullable BillingDetails billingDetails) {
            this.mBillingDetails = billingDetails;
            return this;
        }

        @NonNull
        public Builder setCard(@Nullable Card card) {
            this.mCard = card;
            return this;
        }

        @NonNull
        public Builder setCardPresent(@Nullable CardPresent cardPresent) {
            this.mCardPresent = cardPresent;
            return this;
        }

        @NonNull
        public Builder setCustomerId(@Nullable String customerId) {
            this.mCustomerId = customerId;
            return this;
        }

        @NonNull
        public Builder setIdeal(@Nullable Ideal ideal) {
            this.mIdeal = ideal;
            return this;
        }

        @NonNull
        public Builder setFpx(@Nullable Fpx fpx) {
            this.mFpx = fpx;
            return this;
        }

        @Override
        @NonNull
        public PaymentMethod build() {
            return new PaymentMethod(this);
        }
    }

    public static enum Type {
        Card("card"),
        CardPresent("card_present"),
        Fpx("fpx", false),
        Ideal("ideal");

        @NonNull
        public final String code;
        public final boolean isReusable;

        private Type(String code) {
            this(code, true);
        }

        private Type(String code, boolean isReusable) {
            this.code = code;
            this.isReusable = isReusable;
        }

        @NonNull
        public String toString() {
            return this.code;
        }

        @Nullable
        public static Type lookup(@Nullable String code) {
            for (Type type : Type.values()) {
                if (!type.code.equals(code)) continue;
                return type;
            }
            return null;
        }
    }
}

