/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.LocalBroadcastManager;
import com.stripe.android.ApiRequest;
import com.stripe.android.AppInfo;
import com.stripe.android.CustomerEphemeralKey;
import com.stripe.android.EphemeralKeyManager;
import com.stripe.android.EphemeralKeyProvider;
import com.stripe.android.OperationIdFactory;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.Stripe;
import com.stripe.android.StripeApiRepository;
import com.stripe.android.StripeError;
import com.stripe.android.StripeRepository;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.Customer;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.Source;
import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CustomerSession {
    public static final String ACTION_API_EXCEPTION = "action_api_exception";
    public static final String EXTRA_EXCEPTION = "exception";
    public static final String EVENT_SHIPPING_INFO_SAVED = "shipping_info_saved";
    private static final String ACTION_ADD_SOURCE = "add_source";
    private static final String ACTION_DELETE_SOURCE = "delete_source";
    private static final String ACTION_ATTACH_PAYMENT_METHOD = "attach_payment_method";
    private static final String ACTION_DETACH_PAYMENT_METHOD = "detach_payment_method";
    private static final String ACTION_GET_PAYMENT_METHODS = "get_payment_methods";
    private static final String ACTION_SET_DEFAULT_SOURCE = "default_source";
    private static final String ACTION_SET_CUSTOMER_SHIPPING_INFO = "set_shipping_info";
    private static final String KEY_PAYMENT_METHOD = "payment_method";
    private static final String KEY_PAYMENT_METHOD_TYPE = "payment_method_type";
    private static final String KEY_SOURCE = "source";
    private static final String KEY_SOURCE_TYPE = "source_type";
    private static final String KEY_SHIPPING_INFO = "shipping_info";
    private static final Set<String> VALID_TOKENS = new HashSet<String>(Arrays.asList("AddPaymentMethodActivity", "PaymentMethodsActivity", "PaymentFlowActivity", "PaymentSession", "ShippingInfoScreen", "ShippingMethodScreen"));
    private static final int THREAD_POOL_SIZE = 3;
    private static final int KEEP_ALIVE_TIME = 2;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    private static final long KEY_REFRESH_BUFFER_IN_SECONDS = 30L;
    private static final long CUSTOMER_CACHE_DURATION_MILLISECONDS = TimeUnit.MINUTES.toMillis(1L);
    private static CustomerSession mInstance;
    @Nullable
    private Customer mCustomer;
    private long mCustomerCacheTime;
    @NonNull
    private final LocalBroadcastManager mLocalBroadcastManager;
    @NonNull
    private final Map<String, RetrievalListener> mCustomerListeners = new HashMap<String, RetrievalListener>();
    @NonNull
    private final OperationIdFactory mOperationIdFactory = new OperationIdFactory();
    @NonNull
    private final EphemeralKeyManager<CustomerEphemeralKey> mEphemeralKeyManager;
    @NonNull
    private final Handler mUiThreadHandler;
    @NonNull
    private final Set<String> mProductUsageTokens;
    @Nullable
    private final Calendar mProxyNowCalendar;
    @NonNull
    private final ThreadPoolExecutor mThreadPoolExecutor;
    @NonNull
    private final StripeRepository mStripeRepository;
    @NonNull
    private final String mPublishableKey;
    @Nullable
    private final String mStripeAccountId;

    public static void initCustomerSession(@NonNull Context context, @NonNull EphemeralKeyProvider ephemeralKeyProvider, @Nullable String stripeAccountId, boolean shouldPrefetchEphemeralKey) {
        CustomerSession.setInstance(new CustomerSession(context, ephemeralKeyProvider, Stripe.getAppInfo(), PaymentConfiguration.getInstance().getPublishableKey(), stripeAccountId, shouldPrefetchEphemeralKey));
    }

    public static void initCustomerSession(@NonNull Context context, @NonNull EphemeralKeyProvider ephemeralKeyProvider, @Nullable String stripeAccountId) {
        CustomerSession.initCustomerSession(context, ephemeralKeyProvider, stripeAccountId, true);
    }

    public static void initCustomerSession(@NonNull Context context, @NonNull EphemeralKeyProvider ephemeralKeyProvider, boolean shouldPrefetchEphemeralKey) {
        CustomerSession.initCustomerSession(context, ephemeralKeyProvider, null, shouldPrefetchEphemeralKey);
    }

    public static void initCustomerSession(@NonNull Context context, @NonNull EphemeralKeyProvider ephemeralKeyProvider) {
        CustomerSession.initCustomerSession(context, ephemeralKeyProvider, null);
    }

    @NonNull
    public static CustomerSession getInstance() {
        if (mInstance == null) {
            throw new IllegalStateException("Attempted to get instance of CustomerSession without initialization.");
        }
        return mInstance;
    }

    @VisibleForTesting
    static void setInstance(@Nullable CustomerSession customerSession) {
        mInstance = customerSession;
    }

    public static void endCustomerSession() {
        CustomerSession.clearInstance();
    }

    @VisibleForTesting
    static void clearInstance() {
        if (mInstance != null) {
            CustomerSession.mInstance.mCustomerListeners.clear();
        }
        CustomerSession.cancelCallbacks();
        CustomerSession.setInstance(null);
    }

    public static void cancelCallbacks() {
        if (mInstance == null) {
            return;
        }
        CustomerSession.mInstance.mThreadPoolExecutor.shutdownNow();
    }

    private CustomerSession(@NonNull Context context, @NonNull EphemeralKeyProvider keyProvider, @Nullable AppInfo appInfo, @NonNull String publishableKey, @Nullable String stripeAccountId, boolean shouldPrefetchEphemeralKey) {
        this(context, keyProvider, null, CustomerSession.createThreadPoolExecutor(), new StripeApiRepository(context, appInfo), publishableKey, stripeAccountId, shouldPrefetchEphemeralKey);
    }

    @VisibleForTesting
    CustomerSession(@NonNull Context context, @NonNull EphemeralKeyProvider keyProvider, @Nullable Calendar proxyNowCalendar, @NonNull ThreadPoolExecutor threadPoolExecutor, @NonNull StripeRepository stripeRepository, @NonNull String publishableKey, @Nullable String stripeAccountId, boolean shouldPrefetchEphemeralKey) {
        this.mLocalBroadcastManager = LocalBroadcastManager.getInstance((Context)context);
        this.mThreadPoolExecutor = threadPoolExecutor;
        this.mProxyNowCalendar = proxyNowCalendar;
        this.mProductUsageTokens = new HashSet<String>();
        this.mStripeRepository = stripeRepository;
        this.mStripeAccountId = stripeAccountId;
        this.mPublishableKey = publishableKey;
        this.mUiThreadHandler = new CustomerSessionHandler(new CustomerSessionHandler.Listener(){

            @Override
            public void onCustomerRetrieved(@Nullable Customer customer, @NonNull String operationId) {
                CustomerSession.this.mCustomer = customer;
                CustomerSession.this.mCustomerCacheTime = CustomerSession.this.getCalendarInstance().getTimeInMillis();
                CustomerRetrievalListener listener = CustomerSession.this.getCustomerRetrievalListener(operationId);
                if (listener != null && customer != null) {
                    listener.onCustomerRetrieved(customer);
                }
            }

            @Override
            public void onSourceRetrieved(@Nullable Source source, @NonNull String operationId) {
                SourceRetrievalListener listener = CustomerSession.this.getSourceRetrievalListener(operationId);
                if (listener != null && source != null) {
                    listener.onSourceRetrieved(source);
                }
            }

            @Override
            public void onPaymentMethodRetrieved(@Nullable PaymentMethod paymentMethod, @NonNull String operationId) {
                PaymentMethodRetrievalListener listener = CustomerSession.this.getPaymentMethodRetrievalListener(operationId);
                if (listener != null && paymentMethod != null) {
                    listener.onPaymentMethodRetrieved(paymentMethod);
                }
            }

            @Override
            public void onPaymentMethodsRetrieved(@NonNull List<PaymentMethod> paymentMethods, @NonNull String operationId) {
                PaymentMethodsRetrievalListener listener = CustomerSession.this.getPaymentMethodsRetrievalListener(operationId);
                if (listener != null) {
                    listener.onPaymentMethodsRetrieved(paymentMethods);
                }
            }

            @Override
            public void onCustomerShippingInfoSaved(@Nullable Customer customer) {
                CustomerSession.this.mCustomer = customer;
                CustomerSession.this.mLocalBroadcastManager.sendBroadcast(new Intent(CustomerSession.EVENT_SHIPPING_INFO_SAVED));
            }

            @Override
            public void onError(@NonNull StripeException exception, @NonNull String operationId) {
                CustomerSession.this.handleRetrievalError(operationId, exception);
            }
        });
        this.mEphemeralKeyManager = new EphemeralKeyManager<CustomerEphemeralKey>(keyProvider, this.createKeyListener(), 30L, proxyNowCalendar, this.mOperationIdFactory, new CustomerEphemeralKey.Factory(), shouldPrefetchEphemeralKey);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void addProductUsageTokenIfValid(@Nullable String token) {
        if (VALID_TOKENS.contains(token)) {
            this.mProductUsageTokens.add(token);
        }
    }

    public void retrieveCurrentCustomer(@NonNull CustomerRetrievalListener listener) {
        Customer cachedCustomer = this.getCachedCustomer();
        if (cachedCustomer != null) {
            listener.onCustomerRetrieved(cachedCustomer);
        } else {
            this.mCustomer = null;
            String operationId = this.mOperationIdFactory.create();
            this.mCustomerListeners.put(operationId, listener);
            this.mEphemeralKeyManager.retrieveEphemeralKey(operationId, null, null);
        }
    }

    public void updateCurrentCustomer(@NonNull CustomerRetrievalListener listener) {
        this.mCustomer = null;
        String operationId = this.mOperationIdFactory.create();
        this.mCustomerListeners.put(operationId, listener);
        this.mEphemeralKeyManager.retrieveEphemeralKey(operationId, null, null);
    }

    @Nullable
    public Customer getCachedCustomer() {
        if (this.canUseCachedCustomer()) {
            return this.mCustomer;
        }
        return null;
    }

    public void addCustomerSource(@NonNull String sourceId, @NonNull String sourceType, @NonNull SourceRetrievalListener listener) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_SOURCE, sourceId);
        arguments.put(KEY_SOURCE_TYPE, sourceType);
        String operationId = this.mOperationIdFactory.create();
        this.mCustomerListeners.put(operationId, listener);
        this.mEphemeralKeyManager.retrieveEphemeralKey(operationId, ACTION_ADD_SOURCE, arguments);
    }

    public void deleteCustomerSource(@NonNull String sourceId, @NonNull SourceRetrievalListener listener) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_SOURCE, sourceId);
        String operationId = this.mOperationIdFactory.create();
        this.mCustomerListeners.put(operationId, listener);
        this.mEphemeralKeyManager.retrieveEphemeralKey(operationId, ACTION_DELETE_SOURCE, arguments);
    }

    public void attachPaymentMethod(@NonNull String paymentMethodId, @NonNull PaymentMethodRetrievalListener listener) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_PAYMENT_METHOD, paymentMethodId);
        String operationId = this.mOperationIdFactory.create();
        this.mCustomerListeners.put(operationId, listener);
        this.mEphemeralKeyManager.retrieveEphemeralKey(operationId, ACTION_ATTACH_PAYMENT_METHOD, arguments);
    }

    public void detachPaymentMethod(@NonNull String paymentMethodId, @NonNull PaymentMethodRetrievalListener listener) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_PAYMENT_METHOD, paymentMethodId);
        String operationId = this.mOperationIdFactory.create();
        this.mCustomerListeners.put(operationId, listener);
        this.mEphemeralKeyManager.retrieveEphemeralKey(operationId, ACTION_DETACH_PAYMENT_METHOD, arguments);
    }

    public void getPaymentMethods(@NonNull PaymentMethod.Type paymentMethodType, @NonNull PaymentMethodsRetrievalListener listener) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_PAYMENT_METHOD_TYPE, paymentMethodType.code);
        String operationId = this.mOperationIdFactory.create();
        this.mCustomerListeners.put(operationId, listener);
        this.mEphemeralKeyManager.retrieveEphemeralKey(operationId, ACTION_GET_PAYMENT_METHODS, arguments);
    }

    public void setCustomerShippingInformation(@NonNull ShippingInformation shippingInformation) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_SHIPPING_INFO, shippingInformation);
        this.mEphemeralKeyManager.retrieveEphemeralKey(this.mOperationIdFactory.create(), ACTION_SET_CUSTOMER_SHIPPING_INFO, arguments);
    }

    public void setCustomerDefaultSource(@NonNull String sourceId, @NonNull String sourceType, @NonNull CustomerRetrievalListener listener) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_SOURCE, sourceId);
        arguments.put(KEY_SOURCE_TYPE, sourceType);
        String operationId = this.mOperationIdFactory.create();
        this.mCustomerListeners.put(operationId, listener);
        this.mEphemeralKeyManager.retrieveEphemeralKey(operationId, ACTION_SET_DEFAULT_SOURCE, arguments);
    }

    void resetUsageTokens() {
        this.mProductUsageTokens.clear();
    }

    @Nullable
    @VisibleForTesting
    Customer getCustomer() {
        return this.mCustomer;
    }

    @VisibleForTesting
    long getCustomerCacheTime() {
        return this.mCustomerCacheTime;
    }

    @VisibleForTesting
    Set<String> getProductUsageTokens() {
        return this.mProductUsageTokens;
    }

    private boolean canUseCachedCustomer() {
        long currentTime = this.getCalendarInstance().getTimeInMillis();
        return this.mCustomer != null && currentTime - this.mCustomerCacheTime < CUSTOMER_CACHE_DURATION_MILLISECONDS;
    }

    @NonNull
    private Runnable createAddCustomerSourceRunnable(final @NonNull CustomerEphemeralKey key, final @NonNull String sourceId, final @NonNull String sourceType, @NonNull String operationId) {
        return new CustomerSessionRunnable<Source>(this.mUiThreadHandler, this.mLocalBroadcastManager, 3, operationId){

            @Override
            @Nullable
            public Source createMessageObject() throws StripeException {
                return CustomerSession.this.addCustomerSourceWithKey(key, sourceId, sourceType);
            }
        };
    }

    @NonNull
    private Runnable createDeleteCustomerSourceRunnable(final @NonNull CustomerEphemeralKey key, final @NonNull String sourceId, @NonNull String operationId) {
        return new CustomerSessionRunnable<Source>(this.mUiThreadHandler, this.mLocalBroadcastManager, 3, operationId){

            @Override
            @Nullable
            public Source createMessageObject() throws StripeException {
                return CustomerSession.this.deleteCustomerSourceWithKey(key, sourceId);
            }
        };
    }

    @NonNull
    private Runnable createAttachPaymentMethodRunnable(final @NonNull CustomerEphemeralKey key, final @NonNull String paymentMethodId, @NonNull String operationId) {
        return new CustomerSessionRunnable<PaymentMethod>(this.mUiThreadHandler, this.mLocalBroadcastManager, 4, operationId){

            @Override
            @Nullable
            public PaymentMethod createMessageObject() throws StripeException {
                return CustomerSession.this.attachCustomerPaymentMethodWithKey(key, paymentMethodId);
            }
        };
    }

    @NonNull
    private Runnable createDetachPaymentMethodRunnable(final @NonNull CustomerEphemeralKey key, final @NonNull String paymentMethodId, @NonNull String operationId) {
        return new CustomerSessionRunnable<PaymentMethod>(this.mUiThreadHandler, this.mLocalBroadcastManager, 4, operationId){

            @Override
            @Nullable
            public PaymentMethod createMessageObject() throws StripeException {
                return CustomerSession.this.detachCustomerPaymentMethodWithKey(key, paymentMethodId);
            }
        };
    }

    @NonNull
    private Runnable createGetPaymentMethodsRunnable(final @NonNull CustomerEphemeralKey key, final @NonNull String paymentMethodType, @NonNull String operationId) {
        return new CustomerSessionRunnable<List<PaymentMethod>>(this.mUiThreadHandler, this.mLocalBroadcastManager, 6, operationId){

            @Override
            @NonNull
            public List<PaymentMethod> createMessageObject() throws StripeException {
                return CustomerSession.this.getCustomerPaymentMethodsWithKey(key, paymentMethodType);
            }
        };
    }

    @NonNull
    private Runnable createSetCustomerSourceDefaultRunnable(final @NonNull CustomerEphemeralKey key, final @NonNull String sourceId, final @NonNull String sourceType, @NonNull String operationId) {
        return new CustomerSessionRunnable<Customer>(this.mUiThreadHandler, this.mLocalBroadcastManager, 2, operationId){

            @Override
            @Nullable
            public Customer createMessageObject() throws StripeException {
                return CustomerSession.this.setCustomerSourceDefaultWithKey(key, sourceId, sourceType);
            }
        };
    }

    @NonNull
    private Runnable createSetCustomerShippingInformationRunnable(final @NonNull CustomerEphemeralKey key, final @NonNull ShippingInformation shippingInformation, @NonNull String operationId) {
        return new CustomerSessionRunnable<Customer>(this.mUiThreadHandler, this.mLocalBroadcastManager, 5, operationId){

            @Override
            @Nullable
            public Customer createMessageObject() throws StripeException {
                return CustomerSession.this.setCustomerShippingInfoWithKey(key, shippingInformation);
            }
        };
    }

    @NonNull
    private Runnable createUpdateCustomerRunnable(final @NonNull CustomerEphemeralKey key, @NonNull String operationId) {
        return new CustomerSessionRunnable<Customer>(this.mUiThreadHandler, this.mLocalBroadcastManager, 2, operationId){

            @Override
            @Nullable
            public Customer createMessageObject() throws StripeException {
                return CustomerSession.this.retrieveCustomerWithKey(key);
            }
        };
    }

    private void executeRunnable(@NonNull Runnable runnable) {
        this.mThreadPoolExecutor.execute(runnable);
    }

    @NonNull
    private EphemeralKeyManager.KeyManagerListener<CustomerEphemeralKey> createKeyListener() {
        return new EphemeralKeyManager.KeyManagerListener<CustomerEphemeralKey>(){

            @Override
            public void onKeyUpdate(@NonNull CustomerEphemeralKey ephemeralKey, @NonNull String operationId, @Nullable String actionString, @Nullable Map<String, Object> arguments) {
                if (actionString == null) {
                    CustomerSession.this.executeRunnable(CustomerSession.this.createUpdateCustomerRunnable(ephemeralKey, operationId));
                    return;
                }
                if (arguments == null) {
                    return;
                }
                Runnable runnable = CustomerSession.ACTION_ADD_SOURCE.equals(actionString) && arguments.containsKey(CustomerSession.KEY_SOURCE) && arguments.containsKey(CustomerSession.KEY_SOURCE_TYPE) ? CustomerSession.this.createAddCustomerSourceRunnable(ephemeralKey, (String)Objects.requireNonNull(arguments.get(CustomerSession.KEY_SOURCE)), (String)Objects.requireNonNull(arguments.get(CustomerSession.KEY_SOURCE_TYPE)), operationId) : (CustomerSession.ACTION_DELETE_SOURCE.equals(actionString) && arguments.containsKey(CustomerSession.KEY_SOURCE) ? CustomerSession.this.createDeleteCustomerSourceRunnable(ephemeralKey, (String)Objects.requireNonNull(arguments.get(CustomerSession.KEY_SOURCE)), operationId) : (CustomerSession.ACTION_ATTACH_PAYMENT_METHOD.equals(actionString) && arguments.containsKey(CustomerSession.KEY_PAYMENT_METHOD) ? CustomerSession.this.createAttachPaymentMethodRunnable(ephemeralKey, (String)Objects.requireNonNull(arguments.get(CustomerSession.KEY_PAYMENT_METHOD)), operationId) : (CustomerSession.ACTION_DETACH_PAYMENT_METHOD.equals(actionString) && arguments.containsKey(CustomerSession.KEY_PAYMENT_METHOD) ? CustomerSession.this.createDetachPaymentMethodRunnable(ephemeralKey, (String)Objects.requireNonNull(arguments.get(CustomerSession.KEY_PAYMENT_METHOD)), operationId) : (CustomerSession.ACTION_GET_PAYMENT_METHODS.equals(actionString) ? CustomerSession.this.createGetPaymentMethodsRunnable(ephemeralKey, (String)Objects.requireNonNull(arguments.get(CustomerSession.KEY_PAYMENT_METHOD_TYPE)), operationId) : (CustomerSession.ACTION_SET_DEFAULT_SOURCE.equals(actionString) && arguments.containsKey(CustomerSession.KEY_SOURCE) && arguments.containsKey(CustomerSession.KEY_SOURCE_TYPE) ? CustomerSession.this.createSetCustomerSourceDefaultRunnable(ephemeralKey, (String)Objects.requireNonNull(arguments.get(CustomerSession.KEY_SOURCE)), (String)Objects.requireNonNull(arguments.get(CustomerSession.KEY_SOURCE_TYPE)), operationId) : (CustomerSession.ACTION_SET_CUSTOMER_SHIPPING_INFO.equals(actionString) && arguments.containsKey(CustomerSession.KEY_SHIPPING_INFO) ? CustomerSession.this.createSetCustomerShippingInformationRunnable(ephemeralKey, (ShippingInformation)Objects.requireNonNull(arguments.get(CustomerSession.KEY_SHIPPING_INFO)), operationId) : null))))));
                if (runnable != null) {
                    CustomerSession.this.executeRunnable(runnable);
                    CustomerSession.this.resetUsageTokens();
                }
            }

            @Override
            public void onKeyError(@NonNull String operationId, int httpCode, @NonNull String errorMessage) {
                RetrievalListener retrievalListener = (RetrievalListener)CustomerSession.this.mCustomerListeners.remove(operationId);
                if (retrievalListener != null) {
                    retrievalListener.onError(httpCode, errorMessage, null);
                }
            }
        };
    }

    private void handleRetrievalError(@NonNull String operationId, @NonNull StripeException exception) {
        RetrievalListener listener = this.mCustomerListeners.remove(operationId);
        if (listener != null) {
            listener.onError(exception.getStatusCode(), exception.getLocalizedMessage(), exception.getStripeError());
        }
        this.resetUsageTokens();
    }

    @NonNull
    private static ThreadPoolExecutor createThreadPoolExecutor() {
        return new ThreadPoolExecutor(3, 3, 2L, KEEP_ALIVE_TIME_UNIT, new LinkedBlockingQueue<Runnable>());
    }

    @NonNull
    private Calendar getCalendarInstance() {
        return this.mProxyNowCalendar == null ? Calendar.getInstance() : this.mProxyNowCalendar;
    }

    @Nullable
    private Source addCustomerSourceWithKey(@NonNull CustomerEphemeralKey key, @NonNull String sourceId, @NonNull String sourceType) throws StripeException {
        return this.mStripeRepository.addCustomerSource(key.getCustomerId(), this.mPublishableKey, new ArrayList<String>(this.mProductUsageTokens), sourceId, sourceType, ApiRequest.Options.create(key.getSecret(), this.mStripeAccountId));
    }

    @Nullable
    private Source deleteCustomerSourceWithKey(@NonNull CustomerEphemeralKey key, @NonNull String sourceId) throws StripeException {
        return this.mStripeRepository.deleteCustomerSource(key.getCustomerId(), this.mPublishableKey, new ArrayList<String>(this.mProductUsageTokens), sourceId, ApiRequest.Options.create(key.getSecret(), this.mStripeAccountId));
    }

    @Nullable
    private PaymentMethod attachCustomerPaymentMethodWithKey(@NonNull CustomerEphemeralKey key, @NonNull String paymentMethodId) throws StripeException {
        return this.mStripeRepository.attachPaymentMethod(key.getCustomerId(), this.mPublishableKey, new ArrayList<String>(this.mProductUsageTokens), paymentMethodId, ApiRequest.Options.create(key.getSecret(), this.mStripeAccountId));
    }

    @Nullable
    private PaymentMethod detachCustomerPaymentMethodWithKey(@NonNull CustomerEphemeralKey key, @NonNull String paymentMethodId) throws StripeException {
        return this.mStripeRepository.detachPaymentMethod(this.mPublishableKey, new ArrayList<String>(this.mProductUsageTokens), paymentMethodId, ApiRequest.Options.create(key.getSecret(), this.mStripeAccountId));
    }

    @NonNull
    private List<PaymentMethod> getCustomerPaymentMethodsWithKey(@NonNull CustomerEphemeralKey key, @NonNull String paymentMethodType) throws StripeException {
        return this.mStripeRepository.getPaymentMethods(key.getCustomerId(), paymentMethodType, this.mPublishableKey, new ArrayList<String>(this.mProductUsageTokens), ApiRequest.Options.create(key.getSecret(), this.mStripeAccountId));
    }

    @Nullable
    private Customer setCustomerShippingInfoWithKey(@NonNull CustomerEphemeralKey key, @NonNull ShippingInformation shippingInformation) throws StripeException {
        return this.mStripeRepository.setCustomerShippingInfo(key.getCustomerId(), this.mPublishableKey, new ArrayList<String>(this.mProductUsageTokens), shippingInformation, ApiRequest.Options.create(key.getSecret(), this.mStripeAccountId));
    }

    @Nullable
    private Customer setCustomerSourceDefaultWithKey(@NonNull CustomerEphemeralKey key, @NonNull String sourceId, @NonNull String sourceType) throws StripeException {
        return this.mStripeRepository.setDefaultCustomerSource(key.getCustomerId(), this.mPublishableKey, new ArrayList<String>(this.mProductUsageTokens), sourceId, sourceType, ApiRequest.Options.create(key.getSecret(), this.mStripeAccountId));
    }

    @Nullable
    private Customer retrieveCustomerWithKey(@NonNull CustomerEphemeralKey key) throws StripeException {
        return this.mStripeRepository.retrieveCustomer(key.getCustomerId(), ApiRequest.Options.create(key.getSecret(), this.mStripeAccountId));
    }

    @Nullable
    private CustomerRetrievalListener getCustomerRetrievalListener(@NonNull String operationId) {
        return (CustomerRetrievalListener)this.mCustomerListeners.remove(operationId);
    }

    @Nullable
    private SourceRetrievalListener getSourceRetrievalListener(@NonNull String operationId) {
        return (SourceRetrievalListener)this.mCustomerListeners.remove(operationId);
    }

    @Nullable
    private PaymentMethodRetrievalListener getPaymentMethodRetrievalListener(@NonNull String operationId) {
        return (PaymentMethodRetrievalListener)this.mCustomerListeners.remove(operationId);
    }

    @Nullable
    private PaymentMethodsRetrievalListener getPaymentMethodsRetrievalListener(@NonNull String operationId) {
        return (PaymentMethodsRetrievalListener)this.mCustomerListeners.remove(operationId);
    }

    private static final class CustomerSessionHandler
    extends Handler {
        @NonNull
        private final Listener mListener;

        CustomerSessionHandler(@NonNull Listener listener) {
            super(Looper.getMainLooper());
            this.mListener = listener;
        }

        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            CustomerSessionRunnable.MessageData messageData = (CustomerSessionRunnable.MessageData)msg.obj;
            Object obj = messageData.obj;
            String operationId = messageData.operationId;
            switch (msg.what) {
                case 2: {
                    this.mListener.onCustomerRetrieved((Customer)obj, operationId);
                    break;
                }
                case 3: {
                    this.mListener.onSourceRetrieved((Source)obj, operationId);
                    break;
                }
                case 4: {
                    this.mListener.onPaymentMethodRetrieved((PaymentMethod)obj, operationId);
                    break;
                }
                case 5: {
                    this.mListener.onCustomerShippingInfoSaved((Customer)obj);
                    break;
                }
                case 6: {
                    this.mListener.onPaymentMethodsRetrieved(Objects.requireNonNull((List)obj), operationId);
                    break;
                }
                case 1: {
                    if (!(obj instanceof StripeException)) break;
                    this.mListener.onError((StripeException)obj, operationId);
                    break;
                }
            }
        }

        static interface Listener {
            public void onCustomerRetrieved(@Nullable Customer var1, @NonNull String var2);

            public void onSourceRetrieved(@Nullable Source var1, @NonNull String var2);

            public void onPaymentMethodRetrieved(@Nullable PaymentMethod var1, @NonNull String var2);

            public void onPaymentMethodsRetrieved(@NonNull List<PaymentMethod> var1, @NonNull String var2);

            public void onCustomerShippingInfoSaved(@Nullable Customer var1);

            public void onError(@NonNull StripeException var1, @NonNull String var2);
        }
    }

    private static abstract class CustomerSessionRunnable<T>
    implements Runnable {
        @NonNull
        private final Handler mUiThreadHandler;
        @NonNull
        private final LocalBroadcastManager mLocalBroadcastManager;
        private final int mMessageCode;
        @NonNull
        private final String mOperationId;

        private CustomerSessionRunnable(@NonNull Handler uiThreadHandler, @NonNull LocalBroadcastManager localBroadcastManager, int messageCode, @NonNull String operationId) {
            this.mUiThreadHandler = uiThreadHandler;
            this.mLocalBroadcastManager = localBroadcastManager;
            this.mMessageCode = messageCode;
            this.mOperationId = operationId;
        }

        @Nullable
        abstract T createMessageObject() throws StripeException;

        @Override
        public final void run() {
            try {
                this.sendMessage(this.createMessageObject());
            }
            catch (StripeException stripeEx) {
                this.sendErrorMessage(stripeEx);
                this.sendErrorIntent(stripeEx);
            }
        }

        private void sendMessage(@Nullable T messageObject) {
            this.mUiThreadHandler.sendMessage(this.mUiThreadHandler.obtainMessage(this.mMessageCode, new MessageData<T>(this.mOperationId, messageObject)));
        }

        private void sendErrorMessage(@NonNull StripeException stripeEx) {
            this.mUiThreadHandler.sendMessage(this.mUiThreadHandler.obtainMessage(1, new MessageData<StripeException>(this.mOperationId, stripeEx)));
        }

        private void sendErrorIntent(@NonNull StripeException exception) {
            Bundle bundle = new Bundle();
            bundle.putSerializable(CustomerSession.EXTRA_EXCEPTION, (Serializable)exception);
            Intent intent = new Intent(CustomerSession.ACTION_API_EXCEPTION).putExtras(bundle);
            this.mLocalBroadcastManager.sendBroadcast(intent);
        }

        static class MessageData<T> {
            @NonNull
            private final String operationId;
            @Nullable
            private final T obj;

            MessageData(@NonNull String operationId, @Nullable T obj) {
                this.operationId = operationId;
                this.obj = obj;
            }
        }
    }

    public static abstract class ActivityPaymentMethodRetrievalListener<A extends Activity>
    implements PaymentMethodRetrievalListener {
        @NonNull
        private final WeakReference<A> mActivityRef;

        public ActivityPaymentMethodRetrievalListener(@NonNull A activity) {
            this.mActivityRef = new WeakReference<A>(activity);
        }

        @Nullable
        protected A getActivity() {
            return (A)((Activity)this.mActivityRef.get());
        }
    }

    public static abstract class ActivitySourceRetrievalListener<A extends Activity>
    implements SourceRetrievalListener {
        @NonNull
        private final WeakReference<A> mActivityRef;

        public ActivitySourceRetrievalListener(@NonNull A activity) {
            this.mActivityRef = new WeakReference<A>(activity);
        }

        @Nullable
        protected A getActivity() {
            return (A)((Activity)this.mActivityRef.get());
        }
    }

    public static abstract class ActivityPaymentMethodsRetrievalListener<A extends Activity>
    implements PaymentMethodsRetrievalListener {
        @NonNull
        private final WeakReference<A> mActivityRef;

        public ActivityPaymentMethodsRetrievalListener(@NonNull A activity) {
            this.mActivityRef = new WeakReference<A>(activity);
        }

        @Nullable
        protected A getActivity() {
            return (A)((Activity)this.mActivityRef.get());
        }
    }

    static interface RetrievalListener {
        public void onError(int var1, @NonNull String var2, @Nullable StripeError var3);
    }

    public static interface PaymentMethodsRetrievalListener
    extends RetrievalListener {
        public void onPaymentMethodsRetrieved(@NonNull List<PaymentMethod> var1);
    }

    public static interface PaymentMethodRetrievalListener
    extends RetrievalListener {
        public void onPaymentMethodRetrieved(@NonNull PaymentMethod var1);
    }

    public static interface SourceRetrievalListener
    extends RetrievalListener {
        public void onSourceRetrieved(@NonNull Source var1);
    }

    public static interface CustomerRetrievalListener
    extends RetrievalListener {
        public void onCustomerRetrieved(@NonNull Customer var1);
    }

    public static abstract class ActivityCustomerRetrievalListener<A extends Activity>
    implements CustomerRetrievalListener {
        @NonNull
        private final WeakReference<A> mActivityRef;

        public ActivityCustomerRetrievalListener(@NonNull A activity) {
            this.mActivityRef = new WeakReference<A>(activity);
        }

        @Nullable
        protected A getActivity() {
            return (A)((Activity)this.mActivityRef.get());
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MessageCode {
        public static final int ERROR = 1;
        public static final int CUSTOMER_RETRIEVED = 2;
        public static final int SOURCE_RETRIEVED = 3;
        public static final int PAYMENT_METHOD_RETRIEVED = 4;
        public static final int CUSTOMER_SHIPPING_INFO_SAVED = 5;
        public static final int PAYMENT_METHODS_RETRIEVED = 6;
    }
}

