/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.stripe.android.R;
import com.stripe.android.model.ShippingMethod;
import com.stripe.android.view.PaymentUtils;
import com.stripe.android.view.ViewUtils;
import java.util.Currency;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/stripe/android/view/ShippingMethodView;", "Landroid/widget/RelativeLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "amount", "Landroid/widget/TextView;", "checkmark", "Landroid/widget/ImageView;", "detail", "label", "selectedColorInt", "unselectedTextColorPrimaryInt", "unselectedTextColorSecondaryInt", "setSelected", "", "selected", "", "setShippingMethod", "shippingMethod", "Lcom/stripe/android/model/ShippingMethod;", "stripe_release"})
public final class ShippingMethodView
extends RelativeLayout {
    private final TextView label;
    private final TextView detail;
    private final TextView amount;
    private final ImageView checkmark;
    @ColorInt
    private final int selectedColorInt;
    @ColorInt
    private final int unselectedTextColorSecondaryInt;
    @ColorInt
    private final int unselectedTextColorPrimaryInt;
    private HashMap _$_findViewCache;

    public void setSelected(boolean selected) {
        if (selected) {
            this.label.setTextColor(this.selectedColorInt);
            this.detail.setTextColor(this.selectedColorInt);
            this.amount.setTextColor(this.selectedColorInt);
            this.checkmark.setVisibility(0);
        } else {
            this.label.setTextColor(this.unselectedTextColorPrimaryInt);
            this.detail.setTextColor(this.unselectedTextColorSecondaryInt);
            this.amount.setTextColor(this.unselectedTextColorPrimaryInt);
            this.checkmark.setVisibility(4);
        }
    }

    public final void setShippingMethod(@NotNull ShippingMethod shippingMethod) {
        Intrinsics.checkParameterIsNotNull((Object)shippingMethod, (String)"shippingMethod");
        this.label.setText((CharSequence)shippingMethod.getLabel());
        this.detail.setText((CharSequence)shippingMethod.getDetail());
        long l = shippingMethod.getAmount();
        Currency currency = shippingMethod.getCurrency();
        Intrinsics.checkExpressionValueIsNotNull((Object)currency, (String)"shippingMethod.currency");
        String string2 = this.getContext().getString(R.string.price_free);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(R.string.price_free)");
        this.amount.setText((CharSequence)PaymentUtils.formatPriceStringUsingFree(l, currency, string2));
    }

    @JvmOverloads
    public ShippingMethodView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        View.inflate((Context)context, (int)R.layout.shipping_method_view, (ViewGroup)((ViewGroup)this));
        View view = this.findViewById(R.id.tv_label_smv);
        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"findViewById(R.id.tv_label_smv)");
        this.label = (TextView)view;
        View view2 = this.findViewById(R.id.tv_detail_smv);
        Intrinsics.checkExpressionValueIsNotNull((Object)view2, (String)"findViewById(R.id.tv_detail_smv)");
        this.detail = (TextView)view2;
        View view3 = this.findViewById(R.id.tv_amount_smv);
        Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"findViewById(R.id.tv_amount_smv)");
        this.amount = (TextView)view3;
        View view4 = this.findViewById(R.id.iv_selected_icon);
        Intrinsics.checkExpressionValueIsNotNull((Object)view4, (String)"findViewById(R.id.iv_selected_icon)");
        this.checkmark = (ImageView)view4;
        int rawSelectedColorInt = ViewUtils.getThemeAccentColor((Context)context).data;
        int rawUnselectedTextColorPrimaryInt = ViewUtils.getThemeTextColorPrimary((Context)context).data;
        int rawUnselectedTextColorSecondaryInt = ViewUtils.getThemeTextColorSecondary((Context)context).data;
        this.selectedColorInt = ViewUtils.isColorTransparent(rawSelectedColorInt) ? ContextCompat.getColor((Context)context, (int)R.color.accent_color_default) : rawSelectedColorInt;
        this.unselectedTextColorPrimaryInt = ViewUtils.isColorTransparent(rawUnselectedTextColorPrimaryInt) ? ContextCompat.getColor((Context)context, (int)R.color.color_text_unselected_primary_default) : rawUnselectedTextColorPrimaryInt;
        this.unselectedTextColorSecondaryInt = ViewUtils.isColorTransparent(rawUnselectedTextColorSecondaryInt) ? ContextCompat.getColor((Context)context, (int)R.color.color_text_unselected_secondary_default) : rawUnselectedTextColorSecondaryInt;
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(16);
        params.height = ViewUtils.getPxFromDp(context, this.getResources().getDimensionPixelSize(R.dimen.shipping_method_view_height));
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public /* synthetic */ ShippingMethodView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public ShippingMethodView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ShippingMethodView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

