/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeSourceTypeModel;
import com.stripe.android.utils.ObjectUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public final class SourceSepaDebitData
extends StripeSourceTypeModel {
    private static final String FIELD_BANK_CODE = "bank_code";
    private static final String FIELD_BRANCH_CODE = "branch_code";
    private static final String FIELD_COUNTRY = "country";
    private static final String FIELD_FINGERPRINT = "fingerprint";
    private static final String FIELD_LAST4 = "last4";
    private static final String FIELD_MANDATE_REFERENCE = "mandate_reference";
    private static final String FIELD_MANDATE_URL = "mandate_url";
    private static final Set<String> STANDARD_FIELDS = new HashSet<String>(Arrays.asList("bank_code", "branch_code", "country", "fingerprint", "last4", "mandate_reference", "mandate_url"));
    @Nullable
    private final String mBankCode;
    @Nullable
    private final String mBranchCode;
    @Nullable
    private final String mCountry;
    @Nullable
    private final String mFingerPrint;
    @Nullable
    private final String mLast4;
    @Nullable
    private final String mMandateReference;
    @Nullable
    private final String mMandateUrl;

    private SourceSepaDebitData(@NonNull Builder builder) {
        super(builder);
        this.mBankCode = builder.mBankCode;
        this.mBranchCode = builder.mBranchCode;
        this.mCountry = builder.mCountry;
        this.mFingerPrint = builder.mFingerPrint;
        this.mLast4 = builder.mLast4;
        this.mMandateReference = builder.mMandateReference;
        this.mMandateUrl = builder.mMandateUrl;
    }

    @Nullable
    public static SourceSepaDebitData fromJson(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        Builder sepaData = new Builder().setBankCode(StripeJsonUtils.optString(jsonObject, FIELD_BANK_CODE)).setBranchCode(StripeJsonUtils.optString(jsonObject, FIELD_BRANCH_CODE)).setCountry(StripeJsonUtils.optString(jsonObject, FIELD_COUNTRY)).setFingerPrint(StripeJsonUtils.optString(jsonObject, FIELD_FINGERPRINT)).setLast4(StripeJsonUtils.optString(jsonObject, FIELD_LAST4)).setMandateReference(StripeJsonUtils.optString(jsonObject, FIELD_MANDATE_REFERENCE)).setMandateUrl(StripeJsonUtils.optString(jsonObject, FIELD_MANDATE_URL));
        Map<String, Object> nonStandardFields = SourceSepaDebitData.jsonObjectToMapWithoutKeys(jsonObject, STANDARD_FIELDS);
        if (nonStandardFields != null) {
            sepaData.setAdditionalFields(nonStandardFields);
        }
        return sepaData.build();
    }

    @Nullable
    public String getBankCode() {
        return this.mBankCode;
    }

    @Nullable
    public String getBranchCode() {
        return this.mBranchCode;
    }

    @Nullable
    public String getCountry() {
        return this.mCountry;
    }

    @Nullable
    public String getFingerPrint() {
        return this.mFingerPrint;
    }

    @Nullable
    public String getLast4() {
        return this.mLast4;
    }

    @Nullable
    public String getMandateReference() {
        return this.mMandateReference;
    }

    @Nullable
    public String getMandateUrl() {
        return this.mMandateUrl;
    }

    @Nullable
    @VisibleForTesting
    static SourceSepaDebitData fromString(String jsonString) {
        try {
            return SourceSepaDebitData.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException badJson) {
            return null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof SourceSepaDebitData && this.typedEquals((SourceSepaDebitData)obj);
    }

    private boolean typedEquals(@NonNull SourceSepaDebitData obj) {
        return super.typedEquals(obj) && ObjectUtils.equals(this.mBankCode, obj.mBankCode) && ObjectUtils.equals(this.mBranchCode, obj.mBranchCode) && ObjectUtils.equals(this.mCountry, obj.mCountry) && ObjectUtils.equals(this.mFingerPrint, obj.mFingerPrint) && ObjectUtils.equals(this.mLast4, obj.mLast4) && ObjectUtils.equals(this.mMandateReference, obj.mMandateReference) && ObjectUtils.equals(this.mMandateUrl, obj.mMandateUrl);
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hash(super.hashCode(), this.mBankCode, this.mBranchCode, this.mCountry, this.mFingerPrint, this.mLast4, this.mMandateReference, this.mMandateUrl);
    }

    public static final class Builder
    extends StripeSourceTypeModel.BaseBuilder {
        private String mBankCode;
        private String mBranchCode;
        private String mCountry;
        private String mFingerPrint;
        private String mLast4;
        private String mMandateReference;
        private String mMandateUrl;

        @NonNull
        Builder setBankCode(String bankCode) {
            this.mBankCode = bankCode;
            return this;
        }

        @NonNull
        Builder setBranchCode(String branchCode) {
            this.mBranchCode = branchCode;
            return this;
        }

        @NonNull
        Builder setCountry(String country) {
            this.mCountry = country;
            return this;
        }

        @NonNull
        Builder setFingerPrint(String fingerPrint) {
            this.mFingerPrint = fingerPrint;
            return this;
        }

        @NonNull
        Builder setLast4(String last4) {
            this.mLast4 = last4;
            return this;
        }

        @NonNull
        Builder setMandateReference(String mandateReference) {
            this.mMandateReference = mandateReference;
            return this;
        }

        @NonNull
        Builder setMandateUrl(String mandateUrl) {
            this.mMandateUrl = mandateUrl;
            return this;
        }

        @NonNull
        public SourceSepaDebitData build() {
            return new SourceSepaDebitData(this);
        }
    }
}

