/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.model.ConfirmStripeIntentParams;
import com.stripe.android.model.PaymentMethodCreateParams;
import com.stripe.android.utils.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class ConfirmSetupIntentParams
implements ConfirmStripeIntentParams {
    @NonNull
    private final String mClientSecret;
    @Nullable
    private final String mPaymentMethodId;
    @Nullable
    private final PaymentMethodCreateParams mPaymentMethodCreateParams;
    @Nullable
    private final String mReturnUrl;
    private final boolean mUseStripeSdk;

    private ConfirmSetupIntentParams(@NonNull Builder builder) {
        this.mClientSecret = builder.mClientSecret;
        this.mReturnUrl = builder.mReturnUrl;
        this.mPaymentMethodId = builder.mPaymentMethodId;
        this.mPaymentMethodCreateParams = builder.mPaymentMethodCreateParams;
        this.mUseStripeSdk = builder.mShouldUseSdk;
    }

    @NonNull
    public static ConfirmSetupIntentParams create(@NonNull String paymentMethodId, @NonNull String clientSecret, @Nullable String returnUrl) {
        return new Builder(clientSecret).setReturnUrl(returnUrl).setPaymentMethodId(paymentMethodId).build();
    }

    @NonNull
    public static ConfirmSetupIntentParams create(@NonNull String paymentMethodId, @NonNull String clientSecret) {
        return new Builder(clientSecret).setPaymentMethodId(paymentMethodId).build();
    }

    @NonNull
    public static ConfirmSetupIntentParams create(@NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull String clientSecret, @Nullable String returnUrl) {
        return new Builder(clientSecret).setPaymentMethodCreateParams(paymentMethodCreateParams).setReturnUrl(returnUrl).build();
    }

    @NonNull
    public static ConfirmSetupIntentParams create(@NonNull PaymentMethodCreateParams paymentMethodCreateParams, @NonNull String clientSecret) {
        return ConfirmSetupIntentParams.create(paymentMethodCreateParams, clientSecret, null);
    }

    @Override
    @NonNull
    public String getClientSecret() {
        return this.mClientSecret;
    }

    @Override
    public boolean shouldUseStripeSdk() {
        return this.mUseStripeSdk;
    }

    @Override
    @NonNull
    public ConfirmSetupIntentParams withShouldUseStripeSdk(boolean shouldUseStripeSdk) {
        return this.toBuilder().setShouldUseSdk(shouldUseStripeSdk).build();
    }

    @Override
    @NonNull
    public Map<String, Object> toParamMap() {
        HashMap<String, Object> networkReadyMap = new HashMap<String, Object>();
        if (this.mPaymentMethodCreateParams != null) {
            networkReadyMap.put("payment_method_data", this.mPaymentMethodCreateParams.toParamMap());
        } else if (this.mPaymentMethodId != null) {
            networkReadyMap.put("payment_method", this.mPaymentMethodId);
        }
        networkReadyMap.put("client_secret", this.mClientSecret);
        if (this.mReturnUrl != null) {
            networkReadyMap.put("return_url", this.mReturnUrl);
        }
        if (this.mUseStripeSdk) {
            networkReadyMap.put("use_stripe_sdk", true);
        }
        return networkReadyMap;
    }

    @Nullable
    public PaymentMethodCreateParams getPaymentMethodCreateParams() {
        return this.mPaymentMethodCreateParams;
    }

    @NonNull
    @VisibleForTesting
    Builder toBuilder() {
        return new Builder(this.mClientSecret).setReturnUrl(this.mReturnUrl).setPaymentMethodId(this.mPaymentMethodId).setPaymentMethodCreateParams(this.mPaymentMethodCreateParams).setShouldUseSdk(this.mUseStripeSdk);
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof ConfirmSetupIntentParams && this.typedEquals((ConfirmSetupIntentParams)obj);
    }

    private boolean typedEquals(@NonNull ConfirmSetupIntentParams params) {
        return ObjectUtils.equals(this.mReturnUrl, params.mReturnUrl) && ObjectUtils.equals(this.mClientSecret, params.mClientSecret) && ObjectUtils.equals(this.mPaymentMethodId, params.mPaymentMethodId) && ObjectUtils.equals(this.mPaymentMethodCreateParams, params.mPaymentMethodCreateParams) && ObjectUtils.equals(this.mUseStripeSdk, params.mUseStripeSdk);
    }

    public int hashCode() {
        return ObjectUtils.hash(this.mReturnUrl, this.mClientSecret, this.mPaymentMethodId, this.mUseStripeSdk);
    }

    @VisibleForTesting
    static final class Builder
    implements ObjectBuilder<ConfirmSetupIntentParams> {
        @NonNull
        private final String mClientSecret;
        @Nullable
        private String mPaymentMethodId;
        @Nullable
        private PaymentMethodCreateParams mPaymentMethodCreateParams;
        @Nullable
        private String mReturnUrl;
        private boolean mShouldUseSdk;

        private Builder(@NonNull String clientSecret) {
            this.mClientSecret = Objects.requireNonNull(clientSecret);
        }

        @NonNull
        private Builder setPaymentMethodId(@NonNull String paymentMethodId) {
            this.mPaymentMethodId = paymentMethodId;
            return this;
        }

        @NonNull
        private Builder setPaymentMethodCreateParams(@NonNull PaymentMethodCreateParams paymentMethodCreateParams) {
            this.mPaymentMethodCreateParams = paymentMethodCreateParams;
            return this;
        }

        @NonNull
        private Builder setReturnUrl(@Nullable String returnUrl) {
            this.mReturnUrl = returnUrl;
            return this;
        }

        @NonNull
        private Builder setShouldUseSdk(boolean shouldUseSdk) {
            this.mShouldUseSdk = shouldUseSdk;
            return this;
        }

        @Override
        @NonNull
        public ConfirmSetupIntentParams build() {
            return new ConfirmSetupIntentParams(this);
        }
    }
}

