/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.ApiKeyValidator;
import com.stripe.android.utils.ObjectUtils;
import java.util.Objects;

public final class PaymentConfiguration
implements Parcelable {
    @Nullable
    private static PaymentConfiguration mInstance;
    @NonNull
    private final String mPublishableKey;
    public static final Parcelable.Creator<PaymentConfiguration> CREATOR;

    private PaymentConfiguration(@NonNull String publishableKey) {
        this.mPublishableKey = ApiKeyValidator.get().requireValid(publishableKey);
    }

    private PaymentConfiguration(@NonNull Parcel in) {
        this.mPublishableKey = Objects.requireNonNull(in.readString());
    }

    @NonNull
    public static PaymentConfiguration getInstance() {
        if (mInstance == null) {
            throw new IllegalStateException("Attempted to get instance of PaymentConfiguration without initialization.");
        }
        return mInstance;
    }

    public static void init(@NonNull String publishableKey) {
        mInstance = new PaymentConfiguration(publishableKey);
    }

    @NonNull
    public String getPublishableKey() {
        return this.mPublishableKey;
    }

    @VisibleForTesting
    static void clearInstance() {
        mInstance = null;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mPublishableKey);
    }

    public int hashCode() {
        return ObjectUtils.hash(this.mPublishableKey);
    }

    public boolean equals(@Nullable Object obj) {
        return super.equals(obj) || obj instanceof PaymentConfiguration && this.typedEquals((PaymentConfiguration)obj);
    }

    private boolean typedEquals(@NonNull PaymentConfiguration obj) {
        return ObjectUtils.equals(this.mPublishableKey, obj.mPublishableKey);
    }

    static {
        CREATOR = new Parcelable.Creator<PaymentConfiguration>(){

            public PaymentConfiguration createFromParcel(@NonNull Parcel in) {
                return new PaymentConfiguration(in);
            }

            public PaymentConfiguration[] newArray(int size) {
                return new PaymentConfiguration[size];
            }
        };
    }
}

