/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.support.annotation.NonNull;
import com.stripe.android.ApiKeyValidator;
import com.stripe.android.ApiVersion;
import com.stripe.android.PaymentConfiguration;
import org.json.JSONException;
import org.json.JSONObject;

public final class GooglePayConfig {
    @NonNull
    private final String mPublishableKey;
    @NonNull
    private final String mApiVersion;

    public GooglePayConfig() {
        this(PaymentConfiguration.getInstance().getPublishableKey());
    }

    public GooglePayConfig(@NonNull String publishableKey) {
        this.mPublishableKey = ApiKeyValidator.get().requireValid(publishableKey);
        this.mApiVersion = ApiVersion.get().getCode();
    }

    @NonNull
    public JSONObject getTokenizationSpecification() throws JSONException {
        return new JSONObject().put("type", (Object)"PAYMENT_GATEWAY").put("parameters", (Object)new JSONObject().put("gateway", (Object)"stripe").put("stripe:version", (Object)this.mApiVersion).put("stripe:publishableKey", (Object)this.mPublishableKey));
    }
}

