/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.wallets;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.wallets.AmexExpressCheckoutWallet;
import com.stripe.android.model.wallets.ApplePayWallet;
import com.stripe.android.model.wallets.GooglePayWallet;
import com.stripe.android.model.wallets.MasterpassWallet;
import com.stripe.android.model.wallets.SamsungPayWallet;
import com.stripe.android.model.wallets.VisaCheckoutWallet;
import com.stripe.android.model.wallets.Wallet;
import org.json.JSONObject;

public final class WalletFactory {
    @Nullable
    public Wallet create(@Nullable JSONObject walletJson) {
        if (walletJson == null) {
            return null;
        }
        Wallet.Type walletType = Wallet.Type.fromCode(StripeJsonUtils.optString(walletJson, "type"));
        if (walletType == null) {
            return null;
        }
        return this.create(walletType, walletJson);
    }

    @Nullable
    private Wallet create(@NonNull Wallet.Type walletType, @NonNull JSONObject walletJson) {
        Wallet.Builder walletBuilder;
        JSONObject walletTypeJson = walletJson.optJSONObject(walletType.code);
        if (walletTypeJson == null) {
            return null;
        }
        switch (walletType) {
            case AmexExpressCheckout: {
                walletBuilder = AmexExpressCheckoutWallet.fromJson();
                break;
            }
            case ApplePay: {
                walletBuilder = ApplePayWallet.fromJson();
                break;
            }
            case GooglePay: {
                walletBuilder = GooglePayWallet.fromJson();
                break;
            }
            case Masterpass: {
                walletBuilder = MasterpassWallet.fromJson(walletTypeJson);
                break;
            }
            case SamsungPay: {
                walletBuilder = SamsungPayWallet.fromJson();
                break;
            }
            case VisaCheckout: {
                walletBuilder = VisaCheckoutWallet.fromJson(walletTypeJson);
                break;
            }
            default: {
                return null;
            }
        }
        String dynamicLast4 = StripeJsonUtils.optString(walletJson, "dynamic_last4");
        return walletBuilder.setDynamicLast4(dynamicLast4).build();
    }
}

