/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.utils.ObjectUtils;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class PaymentIntent
extends StripeModel
implements StripeIntent {
    private static final String VALUE_PAYMENT_INTENT = "payment_intent";
    private static final String FIELD_ID = "id";
    private static final String FIELD_OBJECT = "object";
    private static final String FIELD_AMOUNT = "amount";
    private static final String FIELD_CREATED = "created";
    private static final String FIELD_CANCELED_AT = "canceled_at";
    private static final String FIELD_CANCELLATION_REASON = "cancellation_reason";
    private static final String FIELD_CAPTURE_METHOD = "capture_method";
    private static final String FIELD_CLIENT_SECRET = "client_secret";
    private static final String FIELD_CONFIRMATION_METHOD = "confirmation_method";
    private static final String FIELD_CURRENCY = "currency";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_LAST_PAYMENT_ERROR = "last_payment_error";
    private static final String FIELD_LIVEMODE = "livemode";
    private static final String FIELD_NEXT_ACTION = "next_action";
    private static final String FIELD_PAYMENT_METHOD_ID = "payment_method_id";
    private static final String FIELD_PAYMENT_METHOD_TYPES = "payment_method_types";
    private static final String FIELD_RECEIPT_EMAIL = "receipt_email";
    private static final String FIELD_SOURCE = "source";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_SETUP_FUTURE_USAGE = "setup_future_usage";
    private static final String FIELD_NEXT_ACTION_TYPE = "type";
    @Nullable
    private final String mId;
    @Nullable
    private final String mObjectType;
    @NonNull
    private final List<String> mPaymentMethodTypes;
    @Nullable
    private final Long mAmount;
    private final long mCanceledAt;
    @Nullable
    private final CancellationReason mCancellationReason;
    @Nullable
    private final String mCaptureMethod;
    @Nullable
    private final String mClientSecret;
    @Nullable
    private final String mConfirmationMethod;
    private final long mCreated;
    @Nullable
    private final String mCurrency;
    @Nullable
    private final String mDescription;
    private final boolean mLiveMode;
    @Nullable
    private final Map<String, Object> mNextAction;
    @Nullable
    private final StripeIntent.NextActionType mNextActionType;
    @Nullable
    private final String mPaymentMethodId;
    @Nullable
    private final String mReceiptEmail;
    @Nullable
    private final String mSource;
    @Nullable
    private final StripeIntent.Status mStatus;
    @Nullable
    private final StripeIntent.Usage mSetupFutureUsage;
    @Nullable
    private final Error mLastPaymentError;

    @Override
    @Nullable
    public String getId() {
        return this.mId;
    }

    @Override
    @NonNull
    public List<String> getPaymentMethodTypes() {
        return this.mPaymentMethodTypes;
    }

    @Nullable
    public Long getAmount() {
        return this.mAmount;
    }

    public long getCanceledAt() {
        return this.mCanceledAt;
    }

    @Nullable
    public CancellationReason getCancellationReason() {
        return this.mCancellationReason;
    }

    @Nullable
    public String getCaptureMethod() {
        return this.mCaptureMethod;
    }

    @Override
    @Nullable
    public String getClientSecret() {
        return this.mClientSecret;
    }

    @Nullable
    public String getConfirmationMethod() {
        return this.mConfirmationMethod;
    }

    @Override
    public long getCreated() {
        return this.mCreated;
    }

    @Nullable
    public String getCurrency() {
        return this.mCurrency;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public boolean isLiveMode() {
        return this.mLiveMode;
    }

    @Override
    @Nullable
    public String getPaymentMethodId() {
        return this.mPaymentMethodId;
    }

    @Override
    public boolean requiresAction() {
        return this.mStatus == StripeIntent.Status.RequiresAction;
    }

    @Override
    public boolean requiresConfirmation() {
        return this.mStatus == StripeIntent.Status.RequiresConfirmation;
    }

    @Nullable
    public Map<String, Object> getNextAction() {
        return this.mNextAction;
    }

    @Override
    @Nullable
    public StripeIntent.NextActionType getNextActionType() {
        return this.mNextActionType;
    }

    @Nullable
    public Uri getRedirectUrl() {
        StripeIntent.RedirectData redirectData = this.getRedirectData();
        if (redirectData == null) {
            return null;
        }
        return redirectData.url;
    }

    @Override
    @Nullable
    public StripeIntent.SdkData getStripeSdkData() {
        if (this.mNextAction == null || StripeIntent.NextActionType.UseStripeSdk != this.mNextActionType) {
            return null;
        }
        return new StripeIntent.SdkData((Map)this.mNextAction.get(StripeIntent.NextActionType.UseStripeSdk.code));
    }

    @Override
    @Nullable
    public StripeIntent.RedirectData getRedirectData() {
        Object redirectToUrl;
        if (StripeIntent.NextActionType.RedirectToUrl != this.mNextActionType) {
            return null;
        }
        Map<String, Object> nextAction = StripeIntent.Status.RequiresAction == this.mStatus ? this.mNextAction : null;
        if (nextAction == null) {
            return null;
        }
        StripeIntent.NextActionType nextActionType = StripeIntent.NextActionType.fromCode((String)nextAction.get(FIELD_NEXT_ACTION_TYPE));
        if (StripeIntent.NextActionType.RedirectToUrl == nextActionType && (redirectToUrl = nextAction.get(nextActionType.code)) instanceof Map) {
            return StripeIntent.RedirectData.create((Map)redirectToUrl);
        }
        return null;
    }

    @Nullable
    public String getReceiptEmail() {
        return this.mReceiptEmail;
    }

    @Deprecated
    @Nullable
    public String getSource() {
        return this.mSource;
    }

    @Override
    @Nullable
    public StripeIntent.Status getStatus() {
        return this.mStatus;
    }

    @Nullable
    public Error getLastPaymentError() {
        return this.mLastPaymentError;
    }

    private PaymentIntent(@Nullable String id, @Nullable String objectType, @NonNull List<String> paymentMethodTypes, @Nullable Long amount, long canceledAt, @Nullable CancellationReason cancellationReason, @Nullable String captureMethod, @Nullable String clientSecret, @Nullable String confirmationMethod, long created, @Nullable String currency, @Nullable String description, boolean liveMode, @Nullable Map<String, Object> nextAction, @Nullable String paymentMethodId, @Nullable String receiptEmail, @Nullable String source, @Nullable StripeIntent.Status status, @Nullable StripeIntent.Usage setupFutureUsage, @Nullable Error lastPaymentError) {
        this.mId = id;
        this.mObjectType = objectType;
        this.mPaymentMethodTypes = paymentMethodTypes;
        this.mAmount = amount;
        this.mCanceledAt = canceledAt;
        this.mCancellationReason = cancellationReason;
        this.mCaptureMethod = captureMethod;
        this.mClientSecret = clientSecret;
        this.mConfirmationMethod = confirmationMethod;
        this.mCreated = created;
        this.mCurrency = currency;
        this.mDescription = description;
        this.mLiveMode = liveMode;
        this.mNextAction = nextAction;
        this.mPaymentMethodId = paymentMethodId;
        this.mReceiptEmail = receiptEmail;
        this.mSource = source;
        this.mStatus = status;
        this.mSetupFutureUsage = setupFutureUsage;
        this.mNextActionType = this.mNextAction != null ? StripeIntent.NextActionType.fromCode((String)this.mNextAction.get(FIELD_NEXT_ACTION_TYPE)) : null;
        this.mLastPaymentError = lastPaymentError;
    }

    @NonNull
    public static String parseIdFromClientSecret(@NonNull String clientSecret) {
        return clientSecret.split("_secret")[0];
    }

    @Nullable
    public static PaymentIntent fromString(@Nullable String jsonString) {
        try {
            return PaymentIntent.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static PaymentIntent fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null || !VALUE_PAYMENT_INTENT.equals(jsonObject.optString(FIELD_OBJECT))) {
            return null;
        }
        String id = StripeJsonUtils.optString(jsonObject, FIELD_ID);
        String objectType = StripeJsonUtils.optString(jsonObject, FIELD_OBJECT);
        List<String> paymentMethodTypes = PaymentIntent.jsonArrayToList(jsonObject.optJSONArray(FIELD_PAYMENT_METHOD_TYPES));
        Long amount = StripeJsonUtils.optLong(jsonObject, FIELD_AMOUNT);
        long canceledAt = jsonObject.optLong(FIELD_CANCELED_AT);
        CancellationReason cancellationReason = CancellationReason.fromCode(StripeJsonUtils.optString(jsonObject, FIELD_CANCELLATION_REASON));
        String captureMethod = StripeJsonUtils.optString(jsonObject, FIELD_CAPTURE_METHOD);
        String clientSecret = StripeJsonUtils.optString(jsonObject, FIELD_CLIENT_SECRET);
        String confirmationMethod = StripeJsonUtils.optString(jsonObject, FIELD_CONFIRMATION_METHOD);
        long created = jsonObject.optLong(FIELD_CREATED);
        String currency = StripeJsonUtils.optCurrency(jsonObject, FIELD_CURRENCY);
        String description = StripeJsonUtils.optString(jsonObject, FIELD_DESCRIPTION);
        boolean livemode = Boolean.TRUE.equals(StripeJsonUtils.optBoolean(jsonObject, FIELD_LIVEMODE));
        String paymentMethodId = StripeJsonUtils.optString(jsonObject, FIELD_PAYMENT_METHOD_ID);
        String receiptEmail = StripeJsonUtils.optString(jsonObject, FIELD_RECEIPT_EMAIL);
        StripeIntent.Status status = StripeIntent.Status.fromCode(StripeJsonUtils.optString(jsonObject, FIELD_STATUS));
        StripeIntent.Usage setupFutureUsage = StripeIntent.Usage.fromCode(StripeJsonUtils.optString(jsonObject, FIELD_SETUP_FUTURE_USAGE));
        Map<String, Object> nextAction = StripeJsonUtils.optMap(jsonObject, FIELD_NEXT_ACTION);
        String source = StripeJsonUtils.optString(jsonObject, FIELD_SOURCE);
        Error lastPaymentError = Error.fromJson(jsonObject.optJSONObject(FIELD_LAST_PAYMENT_ERROR));
        return new PaymentIntent(id, objectType, paymentMethodTypes, amount, canceledAt, cancellationReason, captureMethod, clientSecret, confirmationMethod, created, currency, description, livemode, nextAction, paymentMethodId, receiptEmail, source, status, setupFutureUsage, lastPaymentError);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof PaymentIntent && this.typedEquals((PaymentIntent)obj);
    }

    private boolean typedEquals(@NonNull PaymentIntent paymentIntent) {
        return ObjectUtils.equals(this.mId, paymentIntent.mId) && ObjectUtils.equals(this.mObjectType, paymentIntent.mObjectType) && ObjectUtils.equals(this.mAmount, paymentIntent.mAmount) && ObjectUtils.equals(this.mCanceledAt, paymentIntent.mCanceledAt) && ObjectUtils.equals((Object)this.mCancellationReason, (Object)paymentIntent.mCancellationReason) && ObjectUtils.equals(this.mCaptureMethod, paymentIntent.mCaptureMethod) && ObjectUtils.equals(this.mClientSecret, paymentIntent.mClientSecret) && ObjectUtils.equals(this.mConfirmationMethod, paymentIntent.mConfirmationMethod) && ObjectUtils.equals(this.mCreated, paymentIntent.mCreated) && ObjectUtils.equals(this.mCurrency, paymentIntent.mCurrency) && ObjectUtils.equals(this.mDescription, paymentIntent.mDescription) && ObjectUtils.equals(this.mLiveMode, paymentIntent.mLiveMode) && ObjectUtils.equals(this.mPaymentMethodId, paymentIntent.mPaymentMethodId) && ObjectUtils.equals(this.mReceiptEmail, paymentIntent.mReceiptEmail) && ObjectUtils.equals(this.mSource, paymentIntent.mSource) && ObjectUtils.equals((Object)this.mStatus, (Object)paymentIntent.mStatus) && ObjectUtils.equals((Object)this.mSetupFutureUsage, (Object)paymentIntent.mSetupFutureUsage) && ObjectUtils.equals(this.mPaymentMethodTypes, paymentIntent.mPaymentMethodTypes) && ObjectUtils.equals(this.mNextAction, paymentIntent.mNextAction) && ObjectUtils.equals((Object)this.mNextActionType, (Object)paymentIntent.mNextActionType) && ObjectUtils.equals(this.mLastPaymentError, paymentIntent.mLastPaymentError);
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hash(new Object[]{this.mId, this.mObjectType, this.mAmount, this.mCanceledAt, this.mCancellationReason, this.mCaptureMethod, this.mClientSecret, this.mConfirmationMethod, this.mCreated, this.mCurrency, this.mDescription, this.mLiveMode, this.mReceiptEmail, this.mSource, this.mStatus, this.mPaymentMethodTypes, this.mNextAction, this.mNextActionType, this.mPaymentMethodId, this.mSetupFutureUsage, this.mLastPaymentError});
    }

    public static enum CancellationReason {
        Duplicate("duplicate"),
        Fraudulent("fraudulent"),
        RequestedByCustomer("requested_by_customer"),
        Abandoned("abandoned"),
        FailedInvoice("failed_invoice"),
        VoidInvoice("void_invoice"),
        Automatic("automatic");

        @NonNull
        private final String code;

        private CancellationReason(String code) {
            this.code = code;
        }

        @Nullable
        private static CancellationReason fromCode(@Nullable String code) {
            for (CancellationReason cancellationReason : CancellationReason.values()) {
                if (!cancellationReason.code.equals(code)) continue;
                return cancellationReason;
            }
            return null;
        }
    }

    public static final class Error {
        private static final String FIELD_CHARGE = "charge";
        private static final String FIELD_CODE = "code";
        private static final String FIELD_DECLINE_CODE = "decline_code";
        private static final String FIELD_DOC_URL = "doc_url";
        private static final String FIELD_MESSAGE = "message";
        private static final String FIELD_PARAM = "param";
        private static final String FIELD_PAYMENT_METHOD = "payment_method";
        private static final String FIELD_TYPE = "type";
        @Nullable
        public final String charge;
        @Nullable
        public final String code;
        @Nullable
        public final String declineCode;
        @Nullable
        public final String docUrl;
        @Nullable
        public final String message;
        @Nullable
        public final String param;
        @Nullable
        public final PaymentMethod paymentMethod;
        @Nullable
        public final Type type;

        private Error(@NonNull Builder builder) {
            this.charge = builder.mCharge;
            this.code = builder.mCode;
            this.declineCode = builder.mDeclineCode;
            this.docUrl = builder.mDocUrl;
            this.message = builder.mMessage;
            this.param = builder.mParam;
            this.paymentMethod = builder.mPaymentMethod;
            this.type = builder.mType;
        }

        @Nullable
        private static Error fromJson(@Nullable JSONObject errorJson) {
            if (errorJson == null) {
                return null;
            }
            return new Builder().setCharge(StripeJsonUtils.optString(errorJson, FIELD_CHARGE)).setCode(StripeJsonUtils.optString(errorJson, FIELD_CODE)).setDeclineCode(StripeJsonUtils.optString(errorJson, FIELD_DECLINE_CODE)).setDocUrl(StripeJsonUtils.optString(errorJson, FIELD_DOC_URL)).setMessage(StripeJsonUtils.optString(errorJson, FIELD_MESSAGE)).setParam(StripeJsonUtils.optString(errorJson, FIELD_PARAM)).setPaymentMethod(PaymentMethod.fromJson(errorJson.optJSONObject(FIELD_PAYMENT_METHOD))).setType(Type.fromCode(StripeJsonUtils.optString(errorJson, "type"))).build();
        }

        public int hashCode() {
            return ObjectUtils.hash(new Object[]{this.charge, this.code, this.declineCode, this.docUrl, this.message, this.param, this.paymentMethod, this.type});
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj) || obj instanceof Error && this.typedEquals((Error)obj);
        }

        private boolean typedEquals(@NonNull Error error) {
            return ObjectUtils.equals(this.charge, error.charge) && ObjectUtils.equals(this.code, error.code) && ObjectUtils.equals(this.declineCode, error.declineCode) && ObjectUtils.equals(this.docUrl, error.docUrl) && ObjectUtils.equals(this.message, error.message) && ObjectUtils.equals(this.param, error.param) && ObjectUtils.equals(this.paymentMethod, error.paymentMethod) && ObjectUtils.equals((Object)this.type, (Object)error.type);
        }

        public static enum Type {
            ApiConnectionError("api_connection_error"),
            ApiError("api_error"),
            AuthenticationError("authentication_error"),
            CardError("card_error"),
            IdempotencyError("idempotency_error"),
            InvalidRequestError("invalid_request_error"),
            RateLimitError("rate_limit_error");

            @NonNull
            public final String code;

            private Type(String code) {
                this.code = code;
            }

            @Nullable
            private static Type fromCode(@Nullable String typeCode) {
                for (Type type : Type.values()) {
                    if (!type.code.equals(typeCode)) continue;
                    return type;
                }
                return null;
            }
        }

        private static final class Builder
        implements ObjectBuilder<Error> {
            @Nullable
            private String mCharge;
            @Nullable
            private String mCode;
            @Nullable
            private String mDeclineCode;
            @Nullable
            private String mDocUrl;
            @Nullable
            private String mMessage;
            @Nullable
            private String mParam;
            @Nullable
            private PaymentMethod mPaymentMethod;
            @Nullable
            private Type mType;

            private Builder() {
            }

            @NonNull
            private Builder setCharge(@Nullable String charge) {
                this.mCharge = charge;
                return this;
            }

            @NonNull
            private Builder setCode(@Nullable String code) {
                this.mCode = code;
                return this;
            }

            @NonNull
            private Builder setDeclineCode(@Nullable String declineCode) {
                this.mDeclineCode = declineCode;
                return this;
            }

            @NonNull
            private Builder setDocUrl(@Nullable String docUrl) {
                this.mDocUrl = docUrl;
                return this;
            }

            @NonNull
            private Builder setMessage(@Nullable String message) {
                this.mMessage = message;
                return this;
            }

            @NonNull
            private Builder setParam(@Nullable String mParam) {
                this.mParam = mParam;
                return this;
            }

            @NonNull
            private Builder setPaymentMethod(@Nullable PaymentMethod paymentMethod) {
                this.mPaymentMethod = paymentMethod;
                return this;
            }

            @NonNull
            private Builder setType(@Nullable Type type) {
                this.mType = type;
                return this;
            }

            @Override
            @NonNull
            public Error build() {
                return new Error(this);
            }
        }
    }
}

