/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.utils.ObjectUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public final class SetupIntent
extends StripeModel
implements StripeIntent {
    private static final String VALUE_SETUP_INTENT = "setup_intent";
    private static final String FIELD_ID = "id";
    private static final String FIELD_OBJECT = "object";
    private static final String FIELD_CREATED = "created";
    private static final String FIELD_CLIENT_SECRET = "client_secret";
    private static final String FIELD_CUSTOMER = "customer";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_LAST_SETUP_ERROR = "last_setup_error";
    private static final String FIELD_LIVEMODE = "livemode";
    private static final String FIELD_NEXT_ACTION = "next_action";
    private static final String FIELD_PAYMENT_METHOD_TYPES = "payment_method_types";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_USAGE = "usage";
    private static final String FIELD_PAYMENT_METHOD = "payment_method";
    private static final String FIELD_NEXT_ACTION_TYPE = "type";
    @Nullable
    private final String mId;
    @Nullable
    private final String mObjectType;
    private final long mCreated;
    @Nullable
    private final String mClientSecret;
    @Nullable
    private final String mCustomerId;
    @Nullable
    private final String mDescription;
    private final boolean mLiveMode;
    @Nullable
    private final Map<String, Object> mNextAction;
    @Nullable
    private final StripeIntent.NextActionType mNextActionType;
    @Nullable
    private final String mPaymentMethodId;
    @NonNull
    private final List<String> mPaymentMethodTypes;
    @Nullable
    private final StripeIntent.Status mStatus;
    @Nullable
    private final StripeIntent.Usage mUsage;
    @Nullable
    private final Error mLastSetupError;

    private SetupIntent(@NonNull Builder builder) {
        this.mId = builder.mId;
        this.mObjectType = builder.mObjectType;
        this.mCreated = builder.mCreated;
        this.mClientSecret = builder.mClientSecret;
        this.mCustomerId = builder.mCustomerId;
        this.mDescription = builder.mDescription;
        this.mLiveMode = builder.mLiveMode;
        this.mNextAction = builder.mNextAction;
        this.mNextActionType = this.mNextAction != null ? StripeIntent.NextActionType.fromCode((String)this.mNextAction.get(FIELD_NEXT_ACTION_TYPE)) : null;
        this.mPaymentMethodId = builder.mPaymentMethodId;
        this.mPaymentMethodTypes = Objects.requireNonNull(builder.mPaymentMethodTypes);
        this.mStatus = builder.mStatus;
        this.mUsage = builder.mUsage;
        this.mLastSetupError = builder.mLastSetupError;
    }

    @NonNull
    public static String parseIdFromClientSecret(@NonNull String clientSecret) {
        return clientSecret.split("_secret")[0];
    }

    @Override
    @Nullable
    public String getId() {
        return this.mId;
    }

    public long getCreated() {
        return this.mCreated;
    }

    @Nullable
    public String getCustomerId() {
        return this.mCustomerId;
    }

    @Nullable
    public String getDescription() {
        return this.mDescription;
    }

    @Nullable
    public Error getLastSetupError() {
        return this.mLastSetupError;
    }

    @Override
    public boolean isLiveMode() {
        return this.mLiveMode;
    }

    @Nullable
    public String getPaymentMethodId() {
        return this.mPaymentMethodId;
    }

    @NonNull
    public List<String> getPaymentMethodTypes() {
        return this.mPaymentMethodTypes;
    }

    @Nullable
    public StripeIntent.Usage getUsage() {
        return this.mUsage;
    }

    @Override
    public boolean requiresAction() {
        return this.mStatus == StripeIntent.Status.RequiresAction;
    }

    @Override
    public boolean requiresConfirmation() {
        return this.mStatus == StripeIntent.Status.RequiresConfirmation;
    }

    @Override
    @Nullable
    public StripeIntent.NextActionType getNextActionType() {
        return this.mNextActionType;
    }

    @Override
    @Nullable
    public StripeIntent.RedirectData getRedirectData() {
        Object redirectToUrl;
        if (StripeIntent.NextActionType.RedirectToUrl != this.mNextActionType) {
            return null;
        }
        Map<String, Object> nextAction = StripeIntent.Status.RequiresAction == this.mStatus ? this.mNextAction : null;
        if (nextAction == null) {
            return null;
        }
        StripeIntent.NextActionType nextActionType = StripeIntent.NextActionType.fromCode((String)nextAction.get(FIELD_NEXT_ACTION_TYPE));
        if (StripeIntent.NextActionType.RedirectToUrl == nextActionType && (redirectToUrl = nextAction.get(nextActionType.code)) instanceof Map) {
            return StripeIntent.RedirectData.create((Map)redirectToUrl);
        }
        return null;
    }

    @Override
    @Nullable
    public String getClientSecret() {
        return this.mClientSecret;
    }

    @Nullable
    public Uri getRedirectUrl() {
        StripeIntent.RedirectData redirectData = this.getRedirectData();
        if (redirectData == null) {
            return null;
        }
        return redirectData.url;
    }

    @Override
    @Nullable
    public StripeIntent.SdkData getStripeSdkData() {
        if (this.mNextAction == null || StripeIntent.NextActionType.UseStripeSdk != this.mNextActionType) {
            return null;
        }
        return new StripeIntent.SdkData((Map)this.mNextAction.get(StripeIntent.NextActionType.UseStripeSdk.code));
    }

    @Override
    @Nullable
    public StripeIntent.Status getStatus() {
        return this.mStatus;
    }

    @Nullable
    public static SetupIntent fromString(@Nullable String jsonString) {
        try {
            return SetupIntent.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static SetupIntent fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null || !VALUE_SETUP_INTENT.equals(jsonObject.optString(FIELD_OBJECT))) {
            return null;
        }
        return new Builder().setId(StripeJsonUtils.optString(jsonObject, FIELD_ID)).setObjectType(StripeJsonUtils.optString(jsonObject, FIELD_OBJECT)).setCreated(jsonObject.optLong(FIELD_CREATED)).setClientSecret(StripeJsonUtils.optString(jsonObject, FIELD_CLIENT_SECRET)).setCustomerId(StripeJsonUtils.optString(jsonObject, FIELD_CUSTOMER)).setDescription(StripeJsonUtils.optString(jsonObject, FIELD_DESCRIPTION)).setLiveMode(jsonObject.optBoolean(FIELD_LIVEMODE)).setPaymentMethodId(StripeJsonUtils.optString(jsonObject, FIELD_PAYMENT_METHOD)).setPaymentMethodTypes(SetupIntent.jsonArrayToList(jsonObject.optJSONArray(FIELD_PAYMENT_METHOD_TYPES))).setStatus(StripeIntent.Status.fromCode(StripeJsonUtils.optString(jsonObject, FIELD_STATUS))).setUsage(StripeIntent.Usage.fromCode(StripeJsonUtils.optString(jsonObject, FIELD_USAGE))).setNextAction(StripeJsonUtils.optMap(jsonObject, FIELD_NEXT_ACTION)).setLastSetupError(Error.fromJson(jsonObject.optJSONObject(FIELD_LAST_SETUP_ERROR))).build();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof SetupIntent && this.typedEquals((SetupIntent)obj);
    }

    private boolean typedEquals(@NonNull SetupIntent setupIntent) {
        return ObjectUtils.equals(this.mId, setupIntent.mId) && ObjectUtils.equals(this.mObjectType, setupIntent.mObjectType) && ObjectUtils.equals(this.mClientSecret, setupIntent.mClientSecret) && ObjectUtils.equals(this.mCreated, setupIntent.mCreated) && ObjectUtils.equals(this.mCustomerId, setupIntent.mCustomerId) && ObjectUtils.equals(this.mDescription, setupIntent.mDescription) && ObjectUtils.equals(this.mLastSetupError, setupIntent.mLastSetupError) && ObjectUtils.equals(this.mLiveMode, setupIntent.mLiveMode) && ObjectUtils.equals((Object)this.mStatus, (Object)setupIntent.mStatus) && ObjectUtils.equals((Object)this.mUsage, (Object)setupIntent.mUsage) && ObjectUtils.equals(this.mPaymentMethodId, setupIntent.mPaymentMethodId) && ObjectUtils.equals(this.mPaymentMethodTypes, setupIntent.mPaymentMethodTypes) && ObjectUtils.equals(this.mNextAction, setupIntent.mNextAction) && ObjectUtils.equals((Object)this.mNextActionType, (Object)setupIntent.mNextActionType);
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hash(new Object[]{this.mId, this.mObjectType, this.mCustomerId, this.mClientSecret, this.mCreated, this.mDescription, this.mLastSetupError, this.mLiveMode, this.mStatus, this.mPaymentMethodId, this.mPaymentMethodTypes, this.mNextAction, this.mNextActionType, this.mUsage});
    }

    public static final class Error {
        private static final String FIELD_CODE = "code";
        private static final String FIELD_DECLINE_CODE = "decline_code";
        private static final String FIELD_DOC_URL = "doc_url";
        private static final String FIELD_MESSAGE = "message";
        private static final String FIELD_PARAM = "param";
        private static final String FIELD_PAYMENT_METHOD = "payment_method";
        private static final String FIELD_TYPE = "type";
        @Nullable
        public final String code;
        @Nullable
        public final String declineCode;
        @Nullable
        public final String docUrl;
        @Nullable
        public final String message;
        @Nullable
        public final String param;
        @Nullable
        public final PaymentMethod paymentMethod;
        @Nullable
        public final Type type;

        private Error(@NonNull Builder builder) {
            this.code = builder.mCode;
            this.declineCode = builder.mDeclineCode;
            this.docUrl = builder.mDocUrl;
            this.message = builder.mMessage;
            this.param = builder.mParam;
            this.paymentMethod = builder.mPaymentMethod;
            this.type = builder.mType;
        }

        @Nullable
        private static Error fromJson(@Nullable JSONObject errorJson) {
            if (errorJson == null) {
                return null;
            }
            return new Builder().setCode(StripeJsonUtils.optString(errorJson, FIELD_CODE)).setDeclineCode(StripeJsonUtils.optString(errorJson, FIELD_DECLINE_CODE)).setDocUrl(StripeJsonUtils.optString(errorJson, FIELD_DOC_URL)).setMessage(StripeJsonUtils.optString(errorJson, FIELD_MESSAGE)).setParam(StripeJsonUtils.optString(errorJson, FIELD_PARAM)).setPaymentMethod(PaymentMethod.fromJson(errorJson.optJSONObject("payment_method"))).setType(Type.fromCode(StripeJsonUtils.optString(errorJson, "type"))).build();
        }

        public int hashCode() {
            return ObjectUtils.hash(new Object[]{this.code, this.declineCode, this.docUrl, this.message, this.param, this.paymentMethod, this.type});
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj) || obj instanceof Error && this.typedEquals((Error)obj);
        }

        private boolean typedEquals(@NonNull Error error) {
            return ObjectUtils.equals(this.code, error.code) && ObjectUtils.equals(this.declineCode, error.declineCode) && ObjectUtils.equals(this.docUrl, error.docUrl) && ObjectUtils.equals(this.message, error.message) && ObjectUtils.equals(this.param, error.param) && ObjectUtils.equals(this.paymentMethod, error.paymentMethod) && ObjectUtils.equals((Object)this.type, (Object)error.type);
        }

        public static enum Type {
            ApiConnectionError("api_connection_error"),
            ApiError("api_error"),
            AuthenticationError("authentication_error"),
            CardError("card_error"),
            IdempotencyError("idempotency_error"),
            InvalidRequestError("invalid_request_error"),
            RateLimitError("rate_limit_error");

            @NonNull
            public final String code;

            private Type(String code) {
                this.code = code;
            }

            @Nullable
            private static Type fromCode(@Nullable String typeCode) {
                for (Type type : Type.values()) {
                    if (!type.code.equals(typeCode)) continue;
                    return type;
                }
                return null;
            }
        }

        private static final class Builder
        implements ObjectBuilder<Error> {
            @Nullable
            private String mCode;
            @Nullable
            private String mDeclineCode;
            @Nullable
            private String mDocUrl;
            @Nullable
            private String mMessage;
            @Nullable
            private String mParam;
            @Nullable
            private PaymentMethod mPaymentMethod;
            @Nullable
            private Type mType;

            private Builder() {
            }

            @NonNull
            private Builder setCode(@Nullable String code) {
                this.mCode = code;
                return this;
            }

            @NonNull
            private Builder setDeclineCode(@Nullable String declineCode) {
                this.mDeclineCode = declineCode;
                return this;
            }

            @NonNull
            private Builder setDocUrl(@Nullable String docUrl) {
                this.mDocUrl = docUrl;
                return this;
            }

            @NonNull
            private Builder setMessage(@Nullable String message) {
                this.mMessage = message;
                return this;
            }

            @NonNull
            private Builder setParam(@Nullable String mParam) {
                this.mParam = mParam;
                return this;
            }

            @NonNull
            private Builder setPaymentMethod(@Nullable PaymentMethod paymentMethod) {
                this.mPaymentMethod = paymentMethod;
                return this;
            }

            @NonNull
            private Builder setType(@Nullable Type type) {
                this.mType = type;
                return this;
            }

            @Override
            @NonNull
            public Error build() {
                return new Error(this);
            }
        }
    }

    private static final class Builder
    implements ObjectBuilder<SetupIntent> {
        @Nullable
        private String mId;
        @Nullable
        private String mObjectType;
        private long mCreated;
        @Nullable
        private String mClientSecret;
        @Nullable
        private String mCustomerId;
        @Nullable
        private String mDescription;
        private boolean mLiveMode;
        @Nullable
        private Map<String, Object> mNextAction;
        @Nullable
        private String mPaymentMethodId;
        private List<String> mPaymentMethodTypes;
        @Nullable
        private StripeIntent.Status mStatus;
        @Nullable
        private StripeIntent.Usage mUsage;
        @Nullable
        private Error mLastSetupError;

        private Builder() {
        }

        @NonNull
        Builder setId(@Nullable String id) {
            this.mId = id;
            return this;
        }

        @NonNull
        Builder setObjectType(@Nullable String objectType) {
            this.mObjectType = objectType;
            return this;
        }

        @NonNull
        Builder setCreated(long created) {
            this.mCreated = created;
            return this;
        }

        @NonNull
        Builder setClientSecret(@Nullable String clientSecret) {
            this.mClientSecret = clientSecret;
            return this;
        }

        @NonNull
        Builder setCustomerId(@Nullable String customerId) {
            this.mCustomerId = customerId;
            return this;
        }

        @NonNull
        Builder setDescription(@Nullable String description) {
            this.mDescription = description;
            return this;
        }

        @NonNull
        Builder setLastSetupError(@Nullable Error lastSetupError) {
            this.mLastSetupError = lastSetupError;
            return this;
        }

        @NonNull
        Builder setLiveMode(boolean liveMode) {
            this.mLiveMode = liveMode;
            return this;
        }

        @NonNull
        Builder setNextAction(@Nullable Map<String, Object> nextAction) {
            this.mNextAction = nextAction;
            return this;
        }

        @NonNull
        Builder setPaymentMethodId(@Nullable String paymentMethodId) {
            this.mPaymentMethodId = paymentMethodId;
            return this;
        }

        @NonNull
        Builder setPaymentMethodTypes(@NonNull List<String> paymentMethodTypes) {
            this.mPaymentMethodTypes = paymentMethodTypes;
            return this;
        }

        @NonNull
        Builder setStatus(@Nullable StripeIntent.Status status) {
            this.mStatus = status;
            return this;
        }

        @NonNull
        Builder setUsage(@Nullable StripeIntent.Usage usage) {
            this.mUsage = usage;
            return this;
        }

        @Override
        @NonNull
        public SetupIntent build() {
            return new SetupIntent(this);
        }
    }
}

