/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.stripe.android.R;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.view.MaskedCardView;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

final class PaymentMethodsAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final int TYPE_CARD = 0;
    private static final int NO_SELECTION = -1;
    @NonNull
    private final List<PaymentMethod> mPaymentMethods = new ArrayList<PaymentMethod>();
    private int mSelectedIndex = -1;

    PaymentMethodsAdapter() {
        this.setHasStableIds(true);
    }

    void setPaymentMethods(@NonNull List<PaymentMethod> paymentMethods) {
        PaymentMethod selectedPaymentMethod = this.getSelectedPaymentMethod();
        String selectedPaymentMethodId = selectedPaymentMethod != null ? selectedPaymentMethod.id : null;
        this.mPaymentMethods.clear();
        this.mPaymentMethods.addAll(paymentMethods);
        if (selectedPaymentMethodId == null || !this.setSelectedPaymentMethod(selectedPaymentMethodId)) {
            this.setSelectedIndex(this.getNewestPaymentMethodIndex());
        }
        this.notifyDataSetChanged();
    }

    private int getNewestPaymentMethodIndex() {
        int index = -1;
        long created = 0L;
        for (int i = 0; i < this.mPaymentMethods.size(); ++i) {
            PaymentMethod paymentMethod = this.mPaymentMethods.get(i);
            if (paymentMethod.created == null || paymentMethod.created <= created) continue;
            created = paymentMethod.created;
            index = i;
        }
        return index;
    }

    public int getItemCount() {
        return this.mPaymentMethods.size();
    }

    public int getItemViewType(int position) {
        String type = this.mPaymentMethods.get((int)position).type;
        if (PaymentMethod.Type.Card.code.equals(type)) {
            return 0;
        }
        return super.getItemViewType(position);
    }

    public long getItemId(int position) {
        return Objects.requireNonNull(this.mPaymentMethods.get((int)position).id).hashCode();
    }

    public void onBindViewHolder(final @NonNull ViewHolder holder, int position) {
        holder.setPaymentMethod(this.mPaymentMethods.get(position));
        holder.setSelected(position == this.mSelectedIndex);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                int currentPosition = holder.getAdapterPosition();
                if (currentPosition != PaymentMethodsAdapter.this.mSelectedIndex) {
                    holder.toggleSelected();
                    PaymentMethodsAdapter.this.setSelectedIndex(currentPosition);
                    PaymentMethodsAdapter.this.notifyDataSetChanged();
                }
            }
        });
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType != 0) {
            throw new IllegalArgumentException("Unsupported type: " + viewType);
        }
        int layoutRes = R.layout.masked_card_row;
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(layoutRes, parent, false);
        return new ViewHolder(itemView);
    }

    boolean setSelectedPaymentMethod(@NonNull String paymentMethodId) {
        for (int i = 0; i < this.mPaymentMethods.size(); ++i) {
            if (!paymentMethodId.equals(this.mPaymentMethods.get((int)i).id)) continue;
            this.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    @Nullable
    PaymentMethod getSelectedPaymentMethod() {
        if (this.mSelectedIndex == -1) {
            return null;
        }
        return this.mPaymentMethods.get(this.mSelectedIndex);
    }

    void setSelectedIndex(int selectedIndex) {
        this.mSelectedIndex = selectedIndex;
    }

    static class ViewHolder
    extends RecyclerView.ViewHolder {
        @NonNull
        private final MaskedCardView mCardView;

        private ViewHolder(@NonNull View itemView) {
            super(itemView);
            this.mCardView = (MaskedCardView)itemView.findViewById(R.id.masked_card_item);
        }

        private void setPaymentMethod(@NonNull PaymentMethod paymentMethod) {
            this.mCardView.setPaymentMethod(paymentMethod);
        }

        private void setSelected(boolean selected) {
            this.mCardView.setSelected(selected);
        }

        private void toggleSelected() {
            this.mCardView.toggleSelected();
        }
    }
}

