/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.utils.ObjectUtils;
import com.stripe.android.view.ActivityStarter;
import com.stripe.android.view.AddPaymentMethodActivity;
import java.util.Objects;

public class AddPaymentMethodActivityStarter
extends ActivityStarter<AddPaymentMethodActivity, Args> {
    AddPaymentMethodActivityStarter(@NonNull Activity activity) {
        super(activity, AddPaymentMethodActivity.class, Args.DEFAULT);
    }

    public static final class Args
    implements ActivityStarter.Args {
        private static final Args DEFAULT = new Builder().build();
        final boolean shouldUpdateCustomer;
        final boolean shouldRequirePostalCode;
        final boolean isPaymentSessionActive;
        final boolean shouldInitCustomerSessionTokens;
        @NonNull
        final PaymentMethod.Type paymentMethodType;
        @Nullable
        final PaymentConfiguration paymentConfiguration;
        public static final Parcelable.Creator<Args> CREATOR = new Parcelable.Creator<Args>(){

            public Args createFromParcel(@NonNull Parcel in) {
                return new Args(in);
            }

            public Args[] newArray(int size) {
                return new Args[size];
            }
        };

        @NonNull
        public static Args create(@NonNull Intent intent) {
            Args args = (Args)intent.getParcelableExtra("EXTRA_ARGS");
            return Objects.requireNonNull(args);
        }

        private Args(@NonNull Builder builder) {
            this.shouldUpdateCustomer = builder.mShouldUpdateCustomer;
            this.shouldRequirePostalCode = builder.mShouldRequirePostalCode;
            this.isPaymentSessionActive = builder.mIsPaymentSessionActive;
            this.shouldInitCustomerSessionTokens = builder.mShouldInitCustomerSessionTokens;
            this.paymentMethodType = ObjectUtils.getOrDefault(builder.mPaymentMethodType, PaymentMethod.Type.Card);
            this.paymentConfiguration = builder.mPaymentConfiguration;
        }

        private Args(@NonNull Parcel in) {
            this.shouldUpdateCustomer = in.readInt() == 1;
            this.shouldRequirePostalCode = in.readInt() == 1;
            this.isPaymentSessionActive = in.readInt() == 1;
            this.shouldInitCustomerSessionTokens = in.readInt() == 1;
            this.paymentMethodType = PaymentMethod.Type.valueOf(in.readString());
            this.paymentConfiguration = (PaymentConfiguration)in.readParcelable(PaymentConfiguration.class.getClassLoader());
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.shouldUpdateCustomer ? 1 : 0);
            dest.writeInt(this.shouldRequirePostalCode ? 1 : 0);
            dest.writeInt(this.isPaymentSessionActive ? 1 : 0);
            dest.writeInt(this.shouldInitCustomerSessionTokens ? 1 : 0);
            dest.writeString(this.paymentMethodType.name());
            dest.writeParcelable((Parcelable)this.paymentConfiguration, 0);
        }

        public int hashCode() {
            return ObjectUtils.hash(new Object[]{this.shouldUpdateCustomer, this.shouldRequirePostalCode, this.isPaymentSessionActive, this.shouldInitCustomerSessionTokens, this.paymentMethodType, this.paymentConfiguration});
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj) || obj instanceof Args && this.typedEquals((Args)obj);
        }

        private boolean typedEquals(@NonNull Args args) {
            return ObjectUtils.equals(this.shouldUpdateCustomer, args.shouldUpdateCustomer) && ObjectUtils.equals(this.shouldRequirePostalCode, args.shouldRequirePostalCode) && ObjectUtils.equals(this.isPaymentSessionActive, args.isPaymentSessionActive) && ObjectUtils.equals(this.shouldInitCustomerSessionTokens, args.shouldInitCustomerSessionTokens) && ObjectUtils.equals((Object)this.paymentMethodType, (Object)args.paymentMethodType) && ObjectUtils.equals(this.paymentConfiguration, args.paymentConfiguration);
        }

        public static final class Builder
        implements ObjectBuilder<Args> {
            private boolean mShouldUpdateCustomer;
            private boolean mShouldRequirePostalCode;
            private boolean mIsPaymentSessionActive = false;
            private boolean mShouldInitCustomerSessionTokens = true;
            @Nullable
            private PaymentMethod.Type mPaymentMethodType;
            @Nullable
            private PaymentConfiguration mPaymentConfiguration;

            @NonNull
            Builder setShouldUpdateCustomer(boolean shouldUpdateCustomer) {
                this.mShouldUpdateCustomer = shouldUpdateCustomer;
                return this;
            }

            @NonNull
            Builder setShouldRequirePostalCode(boolean shouldRequirePostalCode) {
                this.mShouldRequirePostalCode = shouldRequirePostalCode;
                return this;
            }

            @NonNull
            Builder setIsPaymentSessionActive(boolean isPaymentSessionActive) {
                this.mIsPaymentSessionActive = isPaymentSessionActive;
                return this;
            }

            @NonNull
            Builder setShouldInitCustomerSessionTokens(boolean shouldInitCustomerSessionTokens) {
                this.mShouldInitCustomerSessionTokens = shouldInitCustomerSessionTokens;
                return this;
            }

            @NonNull
            Builder setPaymentMethodType(@NonNull PaymentMethod.Type paymentMethodType) {
                this.mPaymentMethodType = paymentMethodType;
                return this;
            }

            @NonNull
            Builder setPaymentConfiguration(@Nullable PaymentConfiguration paymentConfiguration) {
                this.mPaymentConfiguration = paymentConfiguration;
                return this;
            }

            @Override
            @NonNull
            public Args build() {
                return new Args(this);
            }
        }
    }
}

