/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.StripeUid;
import com.stripe.android.Supplier;
import com.stripe.android.UidSupplier;
import com.stripe.android.model.Card;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;

public class StripeNetworkUtils {
    private static final String FIELD_MUID = "muid";
    private static final String FIELD_GUID = "guid";
    @NonNull
    private final String mPackageName;
    @NonNull
    private final Supplier<StripeUid> mUidSupplier;

    StripeNetworkUtils(@NonNull Context context) {
        this(context.getPackageName(), new UidSupplier(context));
    }

    @VisibleForTesting
    StripeNetworkUtils(@NonNull String packageName, @NonNull Supplier<StripeUid> uidSupplier) {
        this.mPackageName = packageName;
        this.mUidSupplier = uidSupplier;
    }

    @NonNull
    Map<String, Object> createCardTokenParams(@NonNull Card card) {
        HashMap<String, Object> tokenParams = new HashMap<String, Object>();
        HashMap<String, Object> cardParams = new HashMap<String, Object>();
        ((AbstractMap)cardParams).put("number", StripeTextUtils.nullIfBlank(card.getNumber()));
        ((AbstractMap)cardParams).put("cvc", StripeTextUtils.nullIfBlank(card.getCVC()));
        ((AbstractMap)cardParams).put("exp_month", card.getExpMonth());
        ((AbstractMap)cardParams).put("exp_year", card.getExpYear());
        ((AbstractMap)cardParams).put("name", StripeTextUtils.nullIfBlank(card.getName()));
        ((AbstractMap)cardParams).put("currency", StripeTextUtils.nullIfBlank(card.getCurrency()));
        ((AbstractMap)cardParams).put("address_line1", StripeTextUtils.nullIfBlank(card.getAddressLine1()));
        ((AbstractMap)cardParams).put("address_line2", StripeTextUtils.nullIfBlank(card.getAddressLine2()));
        ((AbstractMap)cardParams).put("address_city", StripeTextUtils.nullIfBlank(card.getAddressCity()));
        ((AbstractMap)cardParams).put("address_zip", StripeTextUtils.nullIfBlank(card.getAddressZip()));
        ((AbstractMap)cardParams).put("address_state", StripeTextUtils.nullIfBlank(card.getAddressState()));
        ((AbstractMap)cardParams).put("address_country", StripeTextUtils.nullIfBlank(card.getAddressCountry()));
        tokenParams.put("product_usage", card.getLoggingTokens());
        tokenParams.put("card", cardParams);
        tokenParams.putAll(this.createUidParams());
        return tokenParams;
    }

    void addUidToConfirmPaymentIntentParams(@NonNull Map<String, ?> confirmPaymentIntentParams) {
        Object sourceData = confirmPaymentIntentParams.get("source_data");
        if (sourceData instanceof Map) {
            ((Map)sourceData).putAll(this.createUidParams());
        } else {
            Object paymentMethodData = confirmPaymentIntentParams.get("payment_method_data");
            if (paymentMethodData instanceof Map) {
                ((Map)paymentMethodData).putAll(this.createUidParams());
            }
        }
    }

    @NonNull
    Map<String, String> createUidParams() {
        String muid;
        String hashMuid;
        String guid = this.mUidSupplier.get().value;
        if (StripeTextUtils.isBlank(guid)) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> uidParams = new HashMap<String, String>(2);
        String hashGuid = StripeTextUtils.shaHashInput(guid);
        if (!StripeTextUtils.isBlank(hashGuid)) {
            uidParams.put(FIELD_GUID, hashGuid);
        }
        if (!StripeTextUtils.isBlank(hashMuid = StripeTextUtils.shaHashInput(muid = this.mPackageName + guid))) {
            uidParams.put(FIELD_MUID, hashMuid);
        }
        return uidParams;
    }
}

