/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import java.util.Objects;

public abstract class ActivityStarter<T> {
    @NonNull
    private final Activity mActivity;
    @Nullable
    private final Fragment mFragment;
    @NonNull
    private final Class<T> mTargetClass;

    public ActivityStarter(@NonNull Activity activity, @NonNull Class<T> targetClass) {
        this.mActivity = activity;
        this.mFragment = null;
        this.mTargetClass = targetClass;
    }

    public ActivityStarter(@NonNull Fragment fragment, @NonNull Class<T> targetClass) {
        this.mActivity = fragment.requireActivity();
        this.mFragment = fragment;
        this.mTargetClass = targetClass;
    }

    public final void startForResult(int requestCode) {
        this.startForResult(requestCode, new Bundle());
    }

    public final void startForResult(int requestCode, @NonNull Bundle bundle) {
        Intent intent = this.newIntent();
        intent.putExtras(bundle);
        if (this.mFragment != null) {
            Objects.requireNonNull(this.mFragment).startActivityForResult(intent, requestCode);
        } else {
            this.mActivity.startActivityForResult(intent, requestCode);
        }
    }

    @NonNull
    public final Intent newIntent() {
        return new Intent((Context)this.mActivity, this.mTargetClass);
    }
}

