/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.AnalyticsDataFactory;
import com.stripe.android.ApiOperation;
import com.stripe.android.ApiRequest;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.FireAndForgetRequestExecutor;
import com.stripe.android.PaymentAuthConfig;
import com.stripe.android.PaymentAuthWebViewStarter;
import com.stripe.android.PaymentIntentResult;
import com.stripe.android.PaymentRelayStarter;
import com.stripe.android.SetupIntentResult;
import com.stripe.android.Stripe3ds2AuthParams;
import com.stripe.android.Stripe3ds2CompletionStarter;
import com.stripe.android.StripeApiHandler;
import com.stripe.android.StripeFireAndForgetRequestExecutor;
import com.stripe.android.StripeSSLSocketFactory;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.ConfirmSetupIntentParams;
import com.stripe.android.model.ConfirmStripeIntentParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.Stripe3ds2AuthResult;
import com.stripe.android.model.Stripe3ds2Fingerprint;
import com.stripe.android.model.Stripe3dsRedirect;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.stripe3ds2.init.ConfigParameters;
import com.stripe.android.stripe3ds2.init.StripeConfigParameters;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2Service;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2ServiceImpl;
import com.stripe.android.stripe3ds2.transaction.AuthenticationRequestParameters;
import com.stripe.android.stripe3ds2.transaction.ChallengeParameters;
import com.stripe.android.stripe3ds2.transaction.ChallengeStatusReceiver;
import com.stripe.android.stripe3ds2.transaction.CompletionEvent;
import com.stripe.android.stripe3ds2.transaction.MessageVersionRegistry;
import com.stripe.android.stripe3ds2.transaction.ProtocolErrorEvent;
import com.stripe.android.stripe3ds2.transaction.RuntimeErrorEvent;
import com.stripe.android.stripe3ds2.transaction.StripeChallengeParameters;
import com.stripe.android.stripe3ds2.transaction.StripeChallengeStatusReceiver;
import com.stripe.android.stripe3ds2.transaction.Transaction;
import com.stripe.android.stripe3ds2.views.ChallengeProgressDialogActivity;
import com.stripe.android.view.AuthActivityStarter;
import java.security.cert.CertificateException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;

class PaymentController {
    static final int PAYMENT_REQUEST_CODE = 50000;
    static final int SETUP_REQUEST_CODE = 50001;
    @NonNull
    private final StripeThreeDs2Service mThreeDs2Service;
    @NonNull
    private final StripeApiHandler mApiHandler;
    @NonNull
    private final MessageVersionRegistry mMessageVersionRegistry;
    @NonNull
    private final PaymentAuthConfig mConfig;
    @NonNull
    private final FireAndForgetRequestExecutor mAnalyticsRequestExecutor;
    @NonNull
    private final AnalyticsDataFactory mAnalyticsDataFactory;

    PaymentController(@NonNull Context context, @NonNull StripeApiHandler apiHandler) {
        this(context, (StripeThreeDs2Service)new StripeThreeDs2ServiceImpl(context, (SSLSocketFactory)new StripeSSLSocketFactory()), apiHandler, new MessageVersionRegistry(), PaymentAuthConfig.get(), new StripeFireAndForgetRequestExecutor(), new AnalyticsDataFactory(context.getApplicationContext()));
    }

    @VisibleForTesting
    PaymentController(@NonNull Context context, @NonNull StripeThreeDs2Service threeDs2Service, @NonNull StripeApiHandler apiHandler, @NonNull MessageVersionRegistry messageVersionRegistry, @NonNull PaymentAuthConfig config, @NonNull FireAndForgetRequestExecutor analyticsRequestExecutor, @NonNull AnalyticsDataFactory analyticsDataFactory) {
        this.mConfig = config;
        this.mThreeDs2Service = threeDs2Service;
        this.mThreeDs2Service.initialize(context, (ConfigParameters)new StripeConfigParameters(), null, config.stripe3ds2Config.uiCustomization.getUiCustomization());
        this.mApiHandler = apiHandler;
        this.mMessageVersionRegistry = messageVersionRegistry;
        this.mAnalyticsRequestExecutor = analyticsRequestExecutor;
        this.mAnalyticsDataFactory = analyticsDataFactory;
    }

    void startConfirmAndAuth(@NonNull AuthActivityStarter.Host host, @NonNull ConfirmStripeIntentParams confirmStripeIntentParams, @NonNull ApiRequest.Options requestOptions) {
        new ConfirmStripeIntentTask(this.mApiHandler, confirmStripeIntentParams, requestOptions, new ConfirmStripeIntentCallback(host, requestOptions, this, PaymentController.getRequestCode(confirmStripeIntentParams))).execute(new Void[0]);
    }

    void startAuth(final @NonNull AuthActivityStarter.Host host, @NonNull String clientSecret, final @NonNull ApiRequest.Options requestOptions) {
        new RetrieveIntentTask(this.mApiHandler, clientSecret, requestOptions, new ApiResultCallback<StripeIntent>(){

            @Override
            public void onSuccess(@NonNull StripeIntent stripeIntent) {
                PaymentController.this.handleNextAction(host, stripeIntent, requestOptions);
            }

            @Override
            public void onError(@NonNull Exception e) {
                PaymentController.handleError(host, 50000, e);
            }
        }).execute(new Void[0]);
    }

    boolean shouldHandlePaymentResult(int requestCode, @Nullable Intent data) {
        return requestCode == 50000 && data != null;
    }

    boolean shouldHandleSetupResult(int requestCode, @Nullable Intent data) {
        return requestCode == 50001 && data != null;
    }

    void handlePaymentResult(@NonNull Intent data, @NonNull ApiRequest.Options requestOptions, final @NonNull ApiResultCallback<PaymentIntentResult> callback) {
        Exception authException = (Exception)data.getSerializableExtra("exception");
        if (authException != null) {
            callback.onError(authException);
            return;
        }
        final int flowOutcome = data.getIntExtra("flow_outcome", 0);
        new RetrieveIntentTask(this.mApiHandler, this.getClientSecret(data), requestOptions, new ApiResultCallback<StripeIntent>(){

            @Override
            public void onSuccess(@NonNull StripeIntent stripeIntent) {
                if (stripeIntent instanceof PaymentIntent) {
                    callback.onSuccess(new PaymentIntentResult.Builder().setPaymentIntent((PaymentIntent)stripeIntent).setOutcome(flowOutcome).build());
                }
            }

            @Override
            public void onError(@NonNull Exception e) {
                callback.onError(e);
            }
        }).execute(new Void[0]);
    }

    void handleSetupResult(@NonNull Intent data, @NonNull ApiRequest.Options requestOptions, final @NonNull ApiResultCallback<SetupIntentResult> callback) {
        Exception authException = (Exception)data.getSerializableExtra("exception");
        if (authException != null) {
            callback.onError(authException);
            return;
        }
        final int flowOutcome = data.getIntExtra("flow_outcome", 0);
        new RetrieveIntentTask(this.mApiHandler, this.getClientSecret(data), requestOptions, new ApiResultCallback<StripeIntent>(){

            @Override
            public void onSuccess(@NonNull StripeIntent stripeIntent) {
                if (stripeIntent instanceof SetupIntent) {
                    callback.onSuccess(new SetupIntentResult.Builder().setSetupIntent((SetupIntent)stripeIntent).setOutcome(flowOutcome).build());
                }
            }

            @Override
            public void onError(@NonNull Exception e) {
                callback.onError(e);
            }
        }).execute(new Void[0]);
    }

    @VisibleForTesting
    @NonNull
    String getClientSecret(@NonNull Intent data) {
        return data.getStringExtra("client_secret");
    }

    @VisibleForTesting
    void handleNextAction(@NonNull AuthActivityStarter.Host host, @NonNull StripeIntent stripeIntent, @NonNull ApiRequest.Options requestOptions) {
        if (stripeIntent.requiresAction()) {
            StripeIntent.NextActionType nextActionType = stripeIntent.getNextActionType();
            if (StripeIntent.NextActionType.UseStripeSdk == nextActionType) {
                StripeIntent.SdkData sdkData = Objects.requireNonNull(stripeIntent.getStripeSdkData());
                if (sdkData.is3ds2()) {
                    this.mAnalyticsRequestExecutor.executeAsync(ApiRequest.createAnalyticsRequest(this.mAnalyticsDataFactory.createAuthParams("3ds2_fingerprint", StripeTextUtils.emptyIfNull(stripeIntent.getId()), requestOptions.apiKey), requestOptions, null));
                    try {
                        this.begin3ds2Auth(host, stripeIntent, Stripe3ds2Fingerprint.create(sdkData), requestOptions);
                    }
                    catch (CertificateException e) {
                        PaymentController.handleError(host, PaymentController.getRequestCode(stripeIntent), e);
                    }
                } else if (sdkData.is3ds1()) {
                    PaymentController.beginWebAuth(host, PaymentController.getRequestCode(stripeIntent), Objects.requireNonNull(stripeIntent.getClientSecret()), Stripe3dsRedirect.create(sdkData).getUrl(), null);
                } else {
                    this.bypassAuth(host, stripeIntent);
                }
            } else if (StripeIntent.NextActionType.RedirectToUrl == nextActionType) {
                this.mAnalyticsRequestExecutor.executeAsync(ApiRequest.createAnalyticsRequest(this.mAnalyticsDataFactory.createAuthParams("url_redirect_next_action", StripeTextUtils.emptyIfNull(stripeIntent.getId()), requestOptions.apiKey), requestOptions, null));
                StripeIntent.RedirectData redirectData = Objects.requireNonNull(stripeIntent.getRedirectData());
                PaymentController.beginWebAuth(host, PaymentController.getRequestCode(stripeIntent), Objects.requireNonNull(stripeIntent.getClientSecret()), redirectData.url.toString(), redirectData.returnUrl);
            } else {
                this.bypassAuth(host, stripeIntent);
            }
        } else {
            this.bypassAuth(host, stripeIntent);
        }
    }

    static int getRequestCode(@NonNull StripeIntent intent) {
        if (intent instanceof PaymentIntent) {
            return 50000;
        }
        return 50001;
    }

    static int getRequestCode(@NonNull ConfirmStripeIntentParams params) {
        if (params instanceof ConfirmPaymentIntentParams) {
            return 50000;
        }
        return 50001;
    }

    private void bypassAuth(@NonNull AuthActivityStarter.Host host, @NonNull StripeIntent stripeIntent) {
        new PaymentRelayStarter(host, PaymentController.getRequestCode(stripeIntent)).start(new PaymentRelayStarter.Data(stripeIntent));
    }

    private void begin3ds2Auth(@NonNull AuthActivityStarter.Host host, @NonNull StripeIntent stripeIntent, @NonNull Stripe3ds2Fingerprint stripe3ds2Fingerprint, @NonNull ApiRequest.Options requestOptions) {
        Activity activity = host.getActivity();
        if (activity == null) {
            return;
        }
        Transaction transaction = this.mThreeDs2Service.createTransaction(stripe3ds2Fingerprint.directoryServer.id, this.mMessageVersionRegistry.getCurrent(), stripeIntent.isLiveMode(), stripe3ds2Fingerprint.directoryServer.name, stripe3ds2Fingerprint.directoryServerEncryption.rootCerts, stripe3ds2Fingerprint.directoryServerEncryption.directoryServerPublicKey, stripe3ds2Fingerprint.directoryServerEncryption.keyId);
        ChallengeProgressDialogActivity.show((Context)activity, (String)stripe3ds2Fingerprint.directoryServer.name);
        StripeIntent.RedirectData redirectData = stripeIntent.getRedirectData();
        String returnUrl = redirectData != null ? redirectData.returnUrl : null;
        AuthenticationRequestParameters areqParams = transaction.getAuthenticationRequestParameters();
        int timeout = this.mConfig.stripe3ds2Config.timeout;
        Stripe3ds2AuthParams authParams = new Stripe3ds2AuthParams(stripe3ds2Fingerprint.source, areqParams.getSDKAppID(), areqParams.getSDKReferenceNumber(), areqParams.getSDKTransactionID(), areqParams.getDeviceData(), areqParams.getSDKEphemeralPublicKey(), areqParams.getMessageVersion(), timeout, returnUrl);
        this.mApiHandler.start3ds2Auth(authParams, StripeTextUtils.emptyIfNull(stripeIntent.getId()), requestOptions, new Stripe3ds2AuthCallback(host, this.mApiHandler, transaction, timeout, stripeIntent, stripe3ds2Fingerprint.source, requestOptions, this.mAnalyticsRequestExecutor, this.mAnalyticsDataFactory));
    }

    private static void beginWebAuth(@NonNull AuthActivityStarter.Host host, int requestCode, @NonNull String clientSecret, @NonNull String authUrl, @Nullable String returnUrl) {
        new PaymentAuthWebViewStarter(host, requestCode).start(new PaymentAuthWebViewStarter.Data(clientSecret, authUrl, returnUrl));
    }

    private static void handleError(@NonNull AuthActivityStarter.Host host, int requestCode, @NonNull Exception exception) {
        new PaymentRelayStarter(host, requestCode).start(new PaymentRelayStarter.Data(exception));
    }

    static final class PaymentAuth3ds2ChallengeStatusReceiver
    extends StripeChallengeStatusReceiver {
        private static final String VALUE_YES = "Y";
        @NonNull
        private final AuthActivityStarter.Host mHost;
        @NonNull
        private final AuthActivityStarter<Stripe3ds2CompletionStarter.StartData> mStarter;
        @NonNull
        private final StripeApiHandler mApiHandler;
        @NonNull
        private final StripeIntent mStripeIntent;
        @NonNull
        private final String mSourceId;
        @NonNull
        private final ApiRequest.Options mRequestOptions;
        @NonNull
        private final FireAndForgetRequestExecutor mAnalyticsRequestExecutor;
        @NonNull
        private final AnalyticsDataFactory mAnalyticsDataFactory;
        @NonNull
        private final Transaction mTransaction;

        @NonNull
        static PaymentAuth3ds2ChallengeStatusReceiver create(@NonNull AuthActivityStarter.Host host, @NonNull StripeApiHandler apiHandler, @NonNull StripeIntent stripeIntent, @NonNull String sourceId, @NonNull ApiRequest.Options requestOptions, @NonNull FireAndForgetRequestExecutor analyticsRequestExecutor, @NonNull AnalyticsDataFactory analyticsDataFactory, @NonNull Transaction transaction) {
            return new PaymentAuth3ds2ChallengeStatusReceiver(host, new Stripe3ds2CompletionStarter(host, PaymentController.getRequestCode(stripeIntent)), apiHandler, stripeIntent, sourceId, requestOptions, analyticsRequestExecutor, analyticsDataFactory, transaction);
        }

        PaymentAuth3ds2ChallengeStatusReceiver(@NonNull AuthActivityStarter.Host host, @NonNull AuthActivityStarter<Stripe3ds2CompletionStarter.StartData> starter, @NonNull StripeApiHandler apiHandler, @NonNull StripeIntent stripeIntent, @NonNull String sourceId, @NonNull ApiRequest.Options requestOptions, @NonNull FireAndForgetRequestExecutor analyticsRequestExecutor, @NonNull AnalyticsDataFactory analyticsDataFactory, @NonNull Transaction transaction) {
            this.mHost = host;
            this.mStarter = starter;
            this.mApiHandler = apiHandler;
            this.mStripeIntent = stripeIntent;
            this.mSourceId = sourceId;
            this.mRequestOptions = requestOptions;
            this.mAnalyticsRequestExecutor = analyticsRequestExecutor;
            this.mAnalyticsDataFactory = analyticsDataFactory;
            this.mTransaction = transaction;
        }

        public void completed(@NonNull CompletionEvent completionEvent, @NonNull String uiTypeCode) {
            super.completed(completionEvent, uiTypeCode);
            this.mAnalyticsRequestExecutor.executeAsync(ApiRequest.createAnalyticsRequest(this.mAnalyticsDataFactory.create3ds2ChallengeParams("3ds2_challenge_flow_completed", StripeTextUtils.emptyIfNull(this.mStripeIntent.getId()), uiTypeCode, this.mRequestOptions.apiKey), this.mRequestOptions, null));
            this.notifyCompletion(new Stripe3ds2CompletionStarter.StartData(this.mStripeIntent, VALUE_YES.equals(completionEvent.getTransactionStatus()) ? 0 : 1));
        }

        public void cancelled(@NonNull String uiTypeCode) {
            super.cancelled(uiTypeCode);
            this.mAnalyticsRequestExecutor.executeAsync(ApiRequest.createAnalyticsRequest(this.mAnalyticsDataFactory.create3ds2ChallengeParams("3ds2_challenge_flow_canceled", StripeTextUtils.emptyIfNull(this.mStripeIntent.getId()), uiTypeCode, this.mRequestOptions.apiKey), this.mRequestOptions, null));
            this.notifyCompletion(new Stripe3ds2CompletionStarter.StartData(this.mStripeIntent, 2));
        }

        public void timedout(@NonNull String uiTypeCode) {
            super.timedout(uiTypeCode);
            this.mAnalyticsRequestExecutor.executeAsync(ApiRequest.createAnalyticsRequest(this.mAnalyticsDataFactory.create3ds2ChallengeParams("3ds2_challenge_flow_timed_out", StripeTextUtils.emptyIfNull(this.mStripeIntent.getId()), uiTypeCode, this.mRequestOptions.apiKey), this.mRequestOptions, null));
            this.notifyCompletion(new Stripe3ds2CompletionStarter.StartData(this.mStripeIntent, 3));
        }

        public void protocolError(@NonNull ProtocolErrorEvent protocolErrorEvent) {
            super.protocolError(protocolErrorEvent);
            this.mAnalyticsRequestExecutor.executeAsync(ApiRequest.createAnalyticsRequest(this.mAnalyticsDataFactory.create3ds2ChallengeErrorParams(StripeTextUtils.emptyIfNull(this.mStripeIntent.getId()), protocolErrorEvent, this.mRequestOptions.apiKey), this.mRequestOptions, null));
            this.notifyCompletion(new Stripe3ds2CompletionStarter.StartData(this.mStripeIntent, 4));
        }

        public void runtimeError(@NonNull RuntimeErrorEvent runtimeErrorEvent) {
            super.runtimeError(runtimeErrorEvent);
            this.mAnalyticsRequestExecutor.executeAsync(ApiRequest.createAnalyticsRequest(this.mAnalyticsDataFactory.create3ds2ChallengeErrorParams(StripeTextUtils.emptyIfNull(this.mStripeIntent.getId()), runtimeErrorEvent, this.mRequestOptions.apiKey), this.mRequestOptions, null));
            this.notifyCompletion(new Stripe3ds2CompletionStarter.StartData(this.mStripeIntent, 5));
        }

        private void notifyCompletion(final @NonNull Stripe3ds2CompletionStarter.StartData startData) {
            this.mAnalyticsRequestExecutor.executeAsync(ApiRequest.createAnalyticsRequest(this.mAnalyticsDataFactory.create3ds2ChallengeParams("3ds2_challenge_flow_presented", StripeTextUtils.emptyIfNull(this.mStripeIntent.getId()), StripeTextUtils.emptyIfNull(this.mTransaction.getInitialChallengeUiType()), this.mRequestOptions.apiKey), this.mRequestOptions, null));
            this.mApiHandler.complete3ds2Auth(this.mSourceId, this.mRequestOptions, new ApiResultCallback<Boolean>(){

                @Override
                public void onSuccess(@NonNull Boolean result) {
                    PaymentAuth3ds2ChallengeStatusReceiver.this.mStarter.start(startData);
                }

                @Override
                public void onError(@NonNull Exception e) {
                    PaymentController.handleError(PaymentAuth3ds2ChallengeStatusReceiver.this.mHost, PaymentController.getRequestCode(PaymentAuth3ds2ChallengeStatusReceiver.this.mStripeIntent), e);
                }
            });
        }
    }

    static final class Stripe3ds2AuthCallback
    implements ApiResultCallback<Stripe3ds2AuthResult> {
        @NonNull
        private final AuthActivityStarter.Host mHost;
        @NonNull
        private final StripeApiHandler mApiHandler;
        @NonNull
        private final Transaction mTransaction;
        private final int mMaxTimeout;
        @NonNull
        private final StripeIntent mStripeIntent;
        @NonNull
        private final String mSourceId;
        @NonNull
        private final ApiRequest.Options mRequestOptions;
        @NonNull
        private final PaymentRelayStarter mPaymentRelayStarter;
        @NonNull
        private final Handler mBackgroundHandler;
        @NonNull
        private final FireAndForgetRequestExecutor mAnalyticsRequestExecutor;
        @NonNull
        private final AnalyticsDataFactory mAnalyticsDataFactory;

        private Stripe3ds2AuthCallback(@NonNull AuthActivityStarter.Host host, @NonNull StripeApiHandler apiHandler, @NonNull Transaction transaction, int maxTimeout, @NonNull StripeIntent stripeIntent, @NonNull String sourceId, @NonNull ApiRequest.Options requestOptions, @NonNull FireAndForgetRequestExecutor analyticsRequestExecutor, @NonNull AnalyticsDataFactory analyticsDataFactory) {
            this(host, apiHandler, transaction, maxTimeout, stripeIntent, sourceId, requestOptions, new PaymentRelayStarter(host, PaymentController.getRequestCode(stripeIntent)), analyticsRequestExecutor, analyticsDataFactory);
        }

        @VisibleForTesting
        Stripe3ds2AuthCallback(@NonNull AuthActivityStarter.Host host, @NonNull StripeApiHandler apiHandler, @NonNull Transaction transaction, int maxTimeout, @NonNull StripeIntent stripeIntent, @NonNull String sourceId, @NonNull ApiRequest.Options requestOptions, @NonNull PaymentRelayStarter paymentRelayStarter, @NonNull FireAndForgetRequestExecutor analyticsRequestExecutor, @NonNull AnalyticsDataFactory analyticsDataFactory) {
            this.mHost = host;
            this.mApiHandler = apiHandler;
            this.mTransaction = transaction;
            this.mMaxTimeout = maxTimeout;
            this.mStripeIntent = stripeIntent;
            this.mSourceId = sourceId;
            this.mRequestOptions = requestOptions;
            this.mPaymentRelayStarter = paymentRelayStarter;
            this.mAnalyticsRequestExecutor = analyticsRequestExecutor;
            this.mAnalyticsDataFactory = analyticsDataFactory;
            HandlerThread handlerThread = new HandlerThread(Stripe3ds2AuthCallback.class.getSimpleName());
            handlerThread.start();
            this.mBackgroundHandler = new Handler(handlerThread.getLooper());
        }

        @Override
        public void onSuccess(@NonNull Stripe3ds2AuthResult result) {
            Stripe3ds2AuthResult.Ares ares = result.ares;
            if (ares != null) {
                if (ares.shouldChallenge()) {
                    this.startChallengeFlow(ares);
                } else {
                    this.startFrictionlessFlow();
                }
            } else if (result.fallbackRedirectUrl != null) {
                PaymentController.beginWebAuth(this.mHost, PaymentController.getRequestCode(this.mStripeIntent), Objects.requireNonNull(this.mStripeIntent.getClientSecret()), result.fallbackRedirectUrl, null);
            } else {
                Stripe3ds2AuthResult.ThreeDS2Error error = result.error;
                String errorMessage = error != null ? "Code: " + error.errorCode + ", Detail: " + error.errorDetail + ", Description: " + error.errorDescription + ", Component: " + error.errorComponent : "Invalid 3DS2 authentication response";
                this.onError(new RuntimeException("Error encountered during 3DS2 authentication request. " + errorMessage));
            }
        }

        @Override
        public void onError(@NonNull Exception e) {
            this.mPaymentRelayStarter.start(new PaymentRelayStarter.Data(e));
        }

        private void startFrictionlessFlow() {
            this.mAnalyticsRequestExecutor.executeAsync(ApiRequest.createAnalyticsRequest(this.mAnalyticsDataFactory.createAuthParams("3ds2_frictionless_flow", StripeTextUtils.emptyIfNull(this.mStripeIntent.getId()), this.mRequestOptions.apiKey), this.mRequestOptions, null));
            this.mPaymentRelayStarter.start(new PaymentRelayStarter.Data(this.mStripeIntent));
        }

        private void startChallengeFlow(@NonNull Stripe3ds2AuthResult.Ares ares) {
            final StripeChallengeParameters challengeParameters = new StripeChallengeParameters();
            challengeParameters.setAcsSignedContent(ares.acsSignedContent);
            challengeParameters.set3DSServerTransactionID(ares.threeDSServerTransId);
            challengeParameters.setAcsTransactionID(ares.acsTransId);
            this.mBackgroundHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Activity activity = Stripe3ds2AuthCallback.this.mHost.getActivity();
                    if (activity == null) {
                        return;
                    }
                    Stripe3ds2AuthCallback.this.mTransaction.doChallenge(activity, (ChallengeParameters)challengeParameters, (ChallengeStatusReceiver)PaymentAuth3ds2ChallengeStatusReceiver.create(Stripe3ds2AuthCallback.this.mHost, Stripe3ds2AuthCallback.this.mApiHandler, Stripe3ds2AuthCallback.this.mStripeIntent, Stripe3ds2AuthCallback.this.mSourceId, Stripe3ds2AuthCallback.this.mRequestOptions, Stripe3ds2AuthCallback.this.mAnalyticsRequestExecutor, Stripe3ds2AuthCallback.this.mAnalyticsDataFactory, Stripe3ds2AuthCallback.this.mTransaction), Stripe3ds2AuthCallback.this.mMaxTimeout);
                }
            }, TimeUnit.SECONDS.toMillis(2L));
        }
    }

    private static final class ConfirmStripeIntentCallback
    implements ApiResultCallback<StripeIntent> {
        @NonNull
        private final AuthActivityStarter.Host mHost;
        @NonNull
        private final ApiRequest.Options mRequestOptions;
        @NonNull
        private final PaymentController mPaymentController;
        private final int mRequestCode;

        private ConfirmStripeIntentCallback(@NonNull AuthActivityStarter.Host host, @NonNull ApiRequest.Options requestOptions, @NonNull PaymentController paymentController, int requestCode) {
            this.mHost = host;
            this.mRequestOptions = requestOptions;
            this.mPaymentController = paymentController;
            this.mRequestCode = requestCode;
        }

        @Override
        public void onSuccess(@NonNull StripeIntent stripeIntent) {
            this.mPaymentController.handleNextAction(this.mHost, stripeIntent, this.mRequestOptions);
        }

        @Override
        public void onError(@NonNull Exception e) {
            PaymentController.handleError(this.mHost, this.mRequestCode, e);
        }
    }

    private static final class ConfirmStripeIntentTask
    extends ApiOperation<StripeIntent> {
        @NonNull
        private final StripeApiHandler mApiHandler;
        @NonNull
        private final ConfirmStripeIntentParams mParams;
        @NonNull
        private final ApiRequest.Options mRequestOptions;

        private ConfirmStripeIntentTask(@NonNull StripeApiHandler apiHandler, @NonNull ConfirmStripeIntentParams params, @NonNull ApiRequest.Options requestOptions, @NonNull ApiResultCallback<StripeIntent> callback) {
            super(callback);
            this.mApiHandler = apiHandler;
            this.mRequestOptions = requestOptions;
            this.mParams = params.withShouldUseStripeSdk(true);
        }

        @Override
        @Nullable
        StripeIntent getResult() throws StripeException {
            if (this.mParams instanceof ConfirmPaymentIntentParams) {
                return this.mApiHandler.confirmPaymentIntent((ConfirmPaymentIntentParams)this.mParams, this.mRequestOptions);
            }
            if (this.mParams instanceof ConfirmSetupIntentParams) {
                return this.mApiHandler.confirmSetupIntent((ConfirmSetupIntentParams)this.mParams, this.mRequestOptions);
            }
            return null;
        }
    }

    private static final class RetrieveIntentTask
    extends ApiOperation<StripeIntent> {
        @NonNull
        private final StripeApiHandler mApiHandler;
        @NonNull
        private final String mClientSecret;
        @NonNull
        private final ApiRequest.Options mRequestOptions;

        private RetrieveIntentTask(@NonNull StripeApiHandler apiHandler, @NonNull String clientSecret, @NonNull ApiRequest.Options requestOptions, @NonNull ApiResultCallback<StripeIntent> callback) {
            super(callback);
            this.mApiHandler = apiHandler;
            this.mClientSecret = clientSecret;
            this.mRequestOptions = requestOptions;
        }

        @Override
        @Nullable
        StripeIntent getResult() throws StripeException {
            if (this.mClientSecret.startsWith("pi_")) {
                return this.mApiHandler.retrievePaymentIntent(this.mClientSecret, this.mRequestOptions);
            }
            if (this.mClientSecret.startsWith("seti_")) {
                return this.mApiHandler.retrieveSetupIntent(this.mClientSecret, this.mRequestOptions);
            }
            return null;
        }
    }
}

