/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.ObjectBuilder;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.utils.ObjectUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class Address
extends StripeModel
implements Parcelable {
    private static final String FIELD_CITY = "city";
    private static final String FIELD_COUNTRY = "country";
    private static final String FIELD_LINE_1 = "line1";
    private static final String FIELD_LINE_2 = "line2";
    private static final String FIELD_POSTAL_CODE = "postal_code";
    private static final String FIELD_STATE = "state";
    @Nullable
    private final String mCity;
    @Nullable
    private final String mCountry;
    @Nullable
    private final String mLine1;
    @Nullable
    private final String mLine2;
    @Nullable
    private final String mPostalCode;
    @Nullable
    private final String mState;
    public static final Parcelable.Creator<Address> CREATOR = new Parcelable.Creator<Address>(){

        public Address createFromParcel(Parcel in) {
            return new Address(in);
        }

        public Address[] newArray(int size) {
            return new Address[size];
        }
    };

    private Address(@Nullable String city, @Nullable String country, @Nullable String line1, @Nullable String line2, @Nullable String postalCode, @Nullable String state) {
        this.mCity = city;
        this.mCountry = country;
        this.mLine1 = line1;
        this.mLine2 = line2;
        this.mPostalCode = postalCode;
        this.mState = state;
    }

    private Address(@NonNull Builder addressBuilder) {
        this(addressBuilder.mCity, addressBuilder.mCountry, addressBuilder.mLine1, addressBuilder.mLine2, addressBuilder.mPostalCode, addressBuilder.mState);
    }

    protected Address(@NonNull Parcel in) {
        this.mCity = in.readString();
        this.mCountry = in.readString();
        this.mLine1 = in.readString();
        this.mLine2 = in.readString();
        this.mPostalCode = in.readString();
        this.mState = in.readString();
    }

    @Nullable
    public String getCity() {
        return this.mCity;
    }

    @Nullable
    public String getCountry() {
        return this.mCountry;
    }

    @Nullable
    public String getLine1() {
        return this.mLine1;
    }

    @Nullable
    public String getLine2() {
        return this.mLine2;
    }

    @Nullable
    public String getPostalCode() {
        return this.mPostalCode;
    }

    @Nullable
    public String getState() {
        return this.mState;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.mCity != null) {
            ((AbstractMap)map).put(FIELD_CITY, this.mCity);
        }
        if (this.mCountry != null) {
            ((AbstractMap)map).put(FIELD_COUNTRY, this.mCountry);
        }
        if (this.mLine1 != null) {
            ((AbstractMap)map).put(FIELD_LINE_1, this.mLine1);
        }
        if (this.mLine2 != null) {
            ((AbstractMap)map).put(FIELD_LINE_2, this.mLine2);
        }
        if (this.mPostalCode != null) {
            ((AbstractMap)map).put(FIELD_POSTAL_CODE, this.mPostalCode);
        }
        if (this.mState != null) {
            ((AbstractMap)map).put(FIELD_STATE, this.mState);
        }
        StripeNetworkUtils.removeNullAndEmptyParams(map);
        return map;
    }

    @Nullable
    public static Address fromString(@Nullable String jsonString) {
        try {
            return Address.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static Address fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        String city = StripeJsonUtils.optString(jsonObject, FIELD_CITY);
        String country = StripeJsonUtils.optString(jsonObject, FIELD_COUNTRY);
        String line1 = StripeJsonUtils.optString(jsonObject, FIELD_LINE_1);
        String line2 = StripeJsonUtils.optString(jsonObject, FIELD_LINE_2);
        String postalCode = StripeJsonUtils.optString(jsonObject, FIELD_POSTAL_CODE);
        String state = StripeJsonUtils.optString(jsonObject, FIELD_STATE);
        return new Address(city, country, line1, line2, postalCode, state);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Address && this.typedEquals((Address)obj);
    }

    private boolean typedEquals(@NonNull Address address) {
        return ObjectUtils.equals(this.mCity, address.mCity) && ObjectUtils.equals(this.mCountry, address.mCountry) && ObjectUtils.equals(this.mLine1, address.mLine1) && ObjectUtils.equals(this.mLine2, address.mLine2) && ObjectUtils.equals(this.mPostalCode, address.mPostalCode) && ObjectUtils.equals(this.mState, address.mState);
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hash(this.mCity, this.mCountry, this.mLine1, this.mLine2, this.mPostalCode, this.mState);
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mCity);
        out.writeString(this.mCountry);
        out.writeString(this.mLine1);
        out.writeString(this.mLine2);
        out.writeString(this.mPostalCode);
        out.writeString(this.mState);
    }

    public int describeContents() {
        return 0;
    }

    public static class Builder
    implements ObjectBuilder<Address> {
        private String mCity;
        private String mCountry;
        private String mLine1;
        private String mLine2;
        private String mPostalCode;
        private String mState;

        @NonNull
        public Builder setCity(@Nullable String city) {
            this.mCity = city;
            return this;
        }

        @NonNull
        public Builder setCountry(@NonNull String country) {
            this.mCountry = country.toUpperCase(Locale.ROOT);
            return this;
        }

        @NonNull
        public Builder setLine1(@Nullable String line1) {
            this.mLine1 = line1;
            return this;
        }

        @NonNull
        public Builder setLine2(@Nullable String line2) {
            this.mLine2 = line2;
            return this;
        }

        @NonNull
        public Builder setPostalCode(@Nullable String postalCode) {
            this.mPostalCode = postalCode;
            return this;
        }

        @NonNull
        public Builder setState(@Nullable String state) {
            this.mState = state;
            return this;
        }

        @Override
        @NonNull
        public Address build() {
            return new Address(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequiredBillingAddressFields {
        public static final int NONE = 0;
        public static final int ZIP = 1;
        public static final int FULL = 2;
        public static final int NAME = 3;
    }
}

