/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.ConnectionFactory;
import com.stripe.android.FireAndForgetRequestExecutor;
import com.stripe.android.StripeRequest;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.InvalidRequestException;
import java.io.Closeable;
import java.io.IOException;
import java.net.HttpURLConnection;

final class StripeFireAndForgetRequestExecutor
implements FireAndForgetRequestExecutor {
    @NonNull
    private final ConnectionFactory mConnectionFactory = new ConnectionFactory();
    @NonNull
    private final Handler mHandler;

    StripeFireAndForgetRequestExecutor() {
        HandlerThread handlerThread = new HandlerThread(StripeFireAndForgetRequestExecutor.class.getSimpleName());
        handlerThread.start();
        this.mHandler = new Handler(handlerThread.getLooper());
    }

    @VisibleForTesting
    int execute(@NonNull StripeRequest request) throws APIConnectionException, InvalidRequestException {
        HttpURLConnection conn = null;
        try {
            conn = this.mConnectionFactory.create(request);
            int responseCode = conn.getResponseCode();
            this.closeConnection(conn, responseCode);
            int n = responseCode;
            return n;
        }
        catch (IOException e) {
            throw APIConnectionException.create(request.getBaseUrl(), e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private void closeConnection(@NonNull HttpURLConnection conn, int responseCode) throws IOException {
        if (responseCode >= 200 && responseCode < 300) {
            this.closeStream(conn.getInputStream());
        } else {
            this.closeStream(conn.getErrorStream());
        }
    }

    private void closeStream(@Nullable Closeable stream) throws IOException {
        if (stream != null) {
            stream.close();
        }
    }

    @Override
    public void executeAsync(final @NonNull StripeRequest request) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    StripeFireAndForgetRequestExecutor.this.execute(request);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

