/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.utils.ObjectUtils;
import com.stripe.android.view.ActivityStarter;
import com.stripe.android.view.PaymentRelayActivity;
import java.lang.ref.WeakReference;

class Stripe3ds2CompletionStarter
implements ActivityStarter<StartData> {
    @NonNull
    private final WeakReference<Activity> mActivityRef;
    private final int mRequestCode;

    Stripe3ds2CompletionStarter(@NonNull Activity activity, int requestCode) {
        this.mActivityRef = new WeakReference<Activity>(activity);
        this.mRequestCode = requestCode;
    }

    @Override
    public void start(@NonNull StartData data) {
        Activity activity = (Activity)this.mActivityRef.get();
        if (activity == null) {
            return;
        }
        Intent intent = new Intent((Context)activity, PaymentRelayActivity.class).putExtra("client_secret", data.mStripeIntent.getClientSecret()).putExtra("status", data.getAuthStatus());
        activity.startActivityForResult(intent, this.mRequestCode);
    }

    static class StartData {
        @NonNull
        private final StripeIntent mStripeIntent;
        private final int mChallengeFlowStatus;
        @Nullable
        private final String mCompletionTransactionStatus;

        @NonNull
        static StartData createForComplete(@NonNull StripeIntent stripeIntent, @NonNull String completionTransactionStatus) {
            return new StartData(stripeIntent, 0, completionTransactionStatus);
        }

        StartData(@NonNull StripeIntent stripeIntent, int status) {
            this(stripeIntent, status, null);
        }

        private StartData(@NonNull StripeIntent stripeIntent, int challengeFlowStatus, @Nullable String completionTransactionStatus) {
            this.mStripeIntent = stripeIntent;
            this.mChallengeFlowStatus = challengeFlowStatus;
            this.mCompletionTransactionStatus = completionTransactionStatus;
        }

        private int getAuthStatus() {
            if (this.mChallengeFlowStatus == 0) {
                return 1;
            }
            if (this.mChallengeFlowStatus == 1) {
                return 3;
            }
            return 2;
        }

        public int hashCode() {
            return ObjectUtils.hash(this.mStripeIntent, this.mChallengeFlowStatus, this.mCompletionTransactionStatus);
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj) || obj instanceof StartData && this.typedEquals((StartData)obj);
        }

        private boolean typedEquals(@NonNull StartData startData) {
            return ObjectUtils.equals(this.mStripeIntent, startData.mStripeIntent) && ObjectUtils.equals(this.mChallengeFlowStatus, startData.mChallengeFlowStatus) && ObjectUtils.equals(this.mCompletionTransactionStatus, startData.mCompletionTransactionStatus);
        }
    }
}

