/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.AnalyticsDataFactory;
import com.stripe.android.ApiKeyValidator;
import com.stripe.android.ApiOperation;
import com.stripe.android.ApiRequest;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.FireAndForgetRequestExecutor;
import com.stripe.android.PaymentAuthConfig;
import com.stripe.android.PaymentAuthWebViewStarter;
import com.stripe.android.PaymentIntentResult;
import com.stripe.android.PaymentRelayStarter;
import com.stripe.android.SetupIntentResult;
import com.stripe.android.Stripe;
import com.stripe.android.Stripe3ds2AuthParams;
import com.stripe.android.Stripe3ds2CompletionStarter;
import com.stripe.android.StripeApiHandler;
import com.stripe.android.StripeFireAndForgetRequestExecutor;
import com.stripe.android.StripeSSLSocketFactory;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.ConfirmPaymentIntentParams;
import com.stripe.android.model.ConfirmSetupIntentParams;
import com.stripe.android.model.ConfirmStripeIntentParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.Stripe3ds2AuthResult;
import com.stripe.android.model.Stripe3ds2Fingerprint;
import com.stripe.android.model.Stripe3dsRedirect;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.stripe3ds2.init.ConfigParameters;
import com.stripe.android.stripe3ds2.init.StripeConfigParameters;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2Service;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2ServiceImpl;
import com.stripe.android.stripe3ds2.transaction.AuthenticationRequestParameters;
import com.stripe.android.stripe3ds2.transaction.ChallengeParameters;
import com.stripe.android.stripe3ds2.transaction.ChallengeStatusReceiver;
import com.stripe.android.stripe3ds2.transaction.CompletionEvent;
import com.stripe.android.stripe3ds2.transaction.MessageVersionRegistry;
import com.stripe.android.stripe3ds2.transaction.ProtocolErrorEvent;
import com.stripe.android.stripe3ds2.transaction.RuntimeErrorEvent;
import com.stripe.android.stripe3ds2.transaction.StripeChallengeParameters;
import com.stripe.android.stripe3ds2.transaction.StripeChallengeStatusReceiver;
import com.stripe.android.stripe3ds2.transaction.Transaction;
import com.stripe.android.stripe3ds2.views.ChallengeProgressDialogActivity;
import com.stripe.android.view.ActivityStarter;
import java.lang.ref.WeakReference;
import java.security.cert.CertificateException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;

class PaymentController {
    static final int PAYMENT_REQUEST_CODE = 50000;
    static final int SETUP_REQUEST_CODE = 50001;
    @NonNull
    private final StripeThreeDs2Service mThreeDs2Service;
    @NonNull
    private final StripeApiHandler mApiHandler;
    @NonNull
    private final MessageVersionRegistry mMessageVersionRegistry;
    @NonNull
    private final PaymentAuthConfig mConfig;
    @NonNull
    private final ApiKeyValidator mApiKeyValidator;
    @NonNull
    private final FireAndForgetRequestExecutor mAnalyticsRequestExecutor;
    @NonNull
    private final AnalyticsDataFactory mAnalyticsDataFactory;

    PaymentController(@NonNull Context context, @NonNull StripeApiHandler apiHandler) {
        this(context, (StripeThreeDs2Service)new StripeThreeDs2ServiceImpl(context, (SSLSocketFactory)new StripeSSLSocketFactory()), apiHandler, new MessageVersionRegistry(), PaymentAuthConfig.get(), new StripeFireAndForgetRequestExecutor(), new AnalyticsDataFactory(context.getApplicationContext()));
    }

    @VisibleForTesting
    PaymentController(@NonNull Context context, @NonNull StripeThreeDs2Service threeDs2Service, @NonNull StripeApiHandler apiHandler, @NonNull MessageVersionRegistry messageVersionRegistry, @NonNull PaymentAuthConfig config, @NonNull FireAndForgetRequestExecutor analyticsRequestExecutor, @NonNull AnalyticsDataFactory analyticsDataFactory) {
        this.mConfig = config;
        this.mThreeDs2Service = threeDs2Service;
        this.mThreeDs2Service.initialize(context, (ConfigParameters)new StripeConfigParameters(), null, config.stripe3ds2Config.uiCustomization.getUiCustomization());
        this.mApiHandler = apiHandler;
        this.mMessageVersionRegistry = messageVersionRegistry;
        this.mApiKeyValidator = new ApiKeyValidator();
        this.mAnalyticsRequestExecutor = analyticsRequestExecutor;
        this.mAnalyticsDataFactory = analyticsDataFactory;
    }

    void startConfirmAndAuth(@NonNull Stripe stripe, @NonNull Activity activity, @NonNull ConfirmStripeIntentParams confirmStripeIntentParams, @NonNull String publishableKey) {
        this.mApiKeyValidator.requireValid(publishableKey);
        new ConfirmStripeIntentTask(stripe, confirmStripeIntentParams, publishableKey, new ConfirmStripeIntentCallback(activity, publishableKey, this, PaymentController.getRequestCode(confirmStripeIntentParams))).execute(new Void[0]);
    }

    void startAuth(@NonNull Stripe stripe, final @NonNull Activity activity, @NonNull String clientSecret, final @NonNull String publishableKey) {
        this.mApiKeyValidator.requireValid(publishableKey);
        new RetrieveIntentTask(stripe, clientSecret, publishableKey, new ApiResultCallback<StripeIntent>(){

            @Override
            public void onSuccess(@NonNull StripeIntent stripeIntent) {
                PaymentController.this.handleNextAction(activity, stripeIntent, publishableKey);
            }

            @Override
            public void onError(@NonNull Exception e) {
                PaymentController.handleError(activity, 50000, e);
            }
        }).execute(new Void[0]);
    }

    boolean shouldHandlePaymentResult(int requestCode, @Nullable Intent data) {
        return requestCode == 50000 && data != null;
    }

    boolean shouldHandleSetupResult(int requestCode, @Nullable Intent data) {
        return requestCode == 50001 && data != null;
    }

    void handlePaymentResult(@NonNull Stripe stripe, @NonNull Intent data, @NonNull String publishableKey, final @NonNull ApiResultCallback<PaymentIntentResult> callback) {
        Exception authException = (Exception)data.getSerializableExtra("exception");
        if (authException != null) {
            callback.onError(authException);
            return;
        }
        final int authStatus = data.getIntExtra("status", 0);
        new RetrieveIntentTask(stripe, this.getClientSecret(data), publishableKey, new ApiResultCallback<StripeIntent>(){

            @Override
            public void onSuccess(@NonNull StripeIntent stripeIntent) {
                if (stripeIntent instanceof PaymentIntent) {
                    callback.onSuccess(new PaymentIntentResult.Builder().setPaymentIntent((PaymentIntent)stripeIntent).setStatus(authStatus).build());
                }
            }

            @Override
            public void onError(@NonNull Exception e) {
                callback.onError(e);
            }
        }).execute(new Void[0]);
    }

    void handleSetupResult(@NonNull Stripe stripe, @NonNull Intent data, @NonNull String publishableKey, final @NonNull ApiResultCallback<SetupIntentResult> callback) {
        Exception authException = (Exception)data.getSerializableExtra("exception");
        if (authException != null) {
            callback.onError(authException);
            return;
        }
        final int authStatus = data.getIntExtra("status", 0);
        new RetrieveIntentTask(stripe, this.getClientSecret(data), publishableKey, new ApiResultCallback<StripeIntent>(){

            @Override
            public void onSuccess(@NonNull StripeIntent stripeIntent) {
                if (stripeIntent instanceof SetupIntent) {
                    callback.onSuccess(new SetupIntentResult.Builder().setSetupIntent((SetupIntent)stripeIntent).setStatus(authStatus).build());
                }
            }

            @Override
            public void onError(@NonNull Exception e) {
                callback.onError(e);
            }
        }).execute(new Void[0]);
    }

    @VisibleForTesting
    @NonNull
    String getClientSecret(@NonNull Intent data) {
        return data.getStringExtra("client_secret");
    }

    @VisibleForTesting
    void handleNextAction(@NonNull Activity activity, @NonNull StripeIntent stripeIntent, @NonNull String publishableKey) {
        if (stripeIntent.requiresAction()) {
            StripeIntent.NextActionType nextActionType = stripeIntent.getNextActionType();
            if (StripeIntent.NextActionType.UseStripeSdk == nextActionType) {
                StripeIntent.SdkData sdkData = Objects.requireNonNull(stripeIntent.getStripeSdkData());
                if (sdkData.is3ds2()) {
                    try {
                        this.begin3ds2Auth(activity, stripeIntent, Stripe3ds2Fingerprint.create(sdkData), publishableKey);
                    }
                    catch (CertificateException e) {
                        PaymentController.handleError(activity, PaymentController.getRequestCode(stripeIntent), e);
                    }
                } else if (sdkData.is3ds1()) {
                    PaymentController.beginWebAuth(activity, PaymentController.getRequestCode(stripeIntent), Objects.requireNonNull(stripeIntent.getClientSecret()), Stripe3dsRedirect.create(sdkData).getUrl(), null);
                } else {
                    this.bypassAuth(activity, stripeIntent);
                }
            } else if (StripeIntent.NextActionType.RedirectToUrl == nextActionType) {
                this.mAnalyticsRequestExecutor.executeAsync(ApiRequest.createAnalyticsRequest(this.mAnalyticsDataFactory.createAuthParams("url_redirect_next_action", StripeTextUtils.emptyIfNull(stripeIntent.getId()), publishableKey), publishableKey, null));
                StripeIntent.RedirectData redirectData = Objects.requireNonNull(stripeIntent.getRedirectData());
                PaymentController.beginWebAuth(activity, PaymentController.getRequestCode(stripeIntent), Objects.requireNonNull(stripeIntent.getClientSecret()), redirectData.url.toString(), redirectData.returnUrl);
            } else {
                this.bypassAuth(activity, stripeIntent);
            }
        } else {
            this.bypassAuth(activity, stripeIntent);
        }
    }

    static int getRequestCode(@NonNull StripeIntent intent) {
        if (intent instanceof PaymentIntent) {
            return 50000;
        }
        return 50001;
    }

    static int getRequestCode(@NonNull ConfirmStripeIntentParams params) {
        if (params instanceof ConfirmPaymentIntentParams) {
            return 50000;
        }
        return 50001;
    }

    private void bypassAuth(@NonNull Activity activity, @NonNull StripeIntent stripeIntent) {
        new PaymentRelayStarter(activity, PaymentController.getRequestCode(stripeIntent)).start(new PaymentRelayStarter.Data(stripeIntent));
    }

    private void begin3ds2Auth(@NonNull Activity activity, @NonNull StripeIntent stripeIntent, @NonNull Stripe3ds2Fingerprint stripe3ds2Fingerprint, @NonNull String publishableKey) {
        Transaction transaction = this.mThreeDs2Service.createTransaction(stripe3ds2Fingerprint.directoryServer.id, this.mMessageVersionRegistry.getCurrent(), stripeIntent.isLiveMode(), stripe3ds2Fingerprint.directoryServer.name, stripe3ds2Fingerprint.directoryServerEncryption.rootCerts, stripe3ds2Fingerprint.directoryServerEncryption.directoryServerPublicKey, stripe3ds2Fingerprint.directoryServerEncryption.keyId);
        ChallengeProgressDialogActivity.show((Context)activity, (String)stripe3ds2Fingerprint.directoryServer.name);
        StripeIntent.RedirectData redirectData = stripeIntent.getRedirectData();
        String returnUrl = redirectData != null ? redirectData.returnUrl : null;
        AuthenticationRequestParameters areqParams = transaction.getAuthenticationRequestParameters();
        int timeout = this.mConfig.stripe3ds2Config.timeout;
        Stripe3ds2AuthParams authParams = new Stripe3ds2AuthParams(stripe3ds2Fingerprint.source, areqParams.getSDKAppID(), areqParams.getSDKReferenceNumber(), areqParams.getSDKTransactionID(), areqParams.getDeviceData(), areqParams.getSDKEphemeralPublicKey(), areqParams.getMessageVersion(), timeout, returnUrl);
        this.mApiHandler.start3ds2Auth(authParams, StripeTextUtils.emptyIfNull(stripeIntent.getId()), publishableKey, new Stripe3ds2AuthCallback(activity, this.mApiHandler, transaction, timeout, stripeIntent, stripe3ds2Fingerprint.source, publishableKey, this.mAnalyticsRequestExecutor, this.mAnalyticsDataFactory));
    }

    private static void beginWebAuth(@NonNull Activity activity, int requestCode, @NonNull String clientSecret, @NonNull String authUrl, @Nullable String returnUrl) {
        new PaymentAuthWebViewStarter(activity, requestCode).start(new PaymentAuthWebViewStarter.Data(clientSecret, authUrl, returnUrl));
    }

    private static void handleError(@NonNull Activity activity, int requestCode, @NonNull Exception exception) {
        new PaymentRelayStarter(activity, requestCode).start(new PaymentRelayStarter.Data(exception));
    }

    static final class PaymentAuth3ds2ChallengeStatusReceiver
    extends StripeChallengeStatusReceiver {
        @NonNull
        private final WeakReference<Activity> mActivityRef;
        @NonNull
        private final ActivityStarter<Stripe3ds2CompletionStarter.StartData> mStarter;
        @NonNull
        private final StripeApiHandler mApiHandler;
        @NonNull
        private final StripeIntent mStripeIntent;
        @NonNull
        private final String mSourceId;
        @NonNull
        private final String mPublishableKey;
        @NonNull
        private final FireAndForgetRequestExecutor mAnalyticsRequestExecutor;
        @NonNull
        private final AnalyticsDataFactory mAnalyticsDataFactory;
        @NonNull
        private final Transaction mTransaction;

        @NonNull
        static PaymentAuth3ds2ChallengeStatusReceiver create(@NonNull Activity activity, @NonNull StripeApiHandler apiHandler, @NonNull StripeIntent stripeIntent, @NonNull String sourceId, @NonNull String publishableKey, @NonNull FireAndForgetRequestExecutor analyticsRequestExecutor, @NonNull AnalyticsDataFactory analyticsDataFactory, @NonNull Transaction transaction) {
            return new PaymentAuth3ds2ChallengeStatusReceiver(activity, new Stripe3ds2CompletionStarter(activity, PaymentController.getRequestCode(stripeIntent)), apiHandler, stripeIntent, sourceId, publishableKey, analyticsRequestExecutor, analyticsDataFactory, transaction);
        }

        PaymentAuth3ds2ChallengeStatusReceiver(@NonNull Activity activity, @NonNull ActivityStarter<Stripe3ds2CompletionStarter.StartData> starter, @NonNull StripeApiHandler apiHandler, @NonNull StripeIntent stripeIntent, @NonNull String sourceId, @NonNull String publishableKey, @NonNull FireAndForgetRequestExecutor analyticsRequestExecutor, @NonNull AnalyticsDataFactory analyticsDataFactory, @NonNull Transaction transaction) {
            this.mActivityRef = new WeakReference<Activity>(activity);
            this.mStarter = starter;
            this.mApiHandler = apiHandler;
            this.mStripeIntent = stripeIntent;
            this.mSourceId = sourceId;
            this.mPublishableKey = publishableKey;
            this.mAnalyticsRequestExecutor = analyticsRequestExecutor;
            this.mAnalyticsDataFactory = analyticsDataFactory;
            this.mTransaction = transaction;
        }

        public void completed(@NonNull CompletionEvent completionEvent, @NonNull String uiTypeCode) {
            super.completed(completionEvent, uiTypeCode);
            this.mAnalyticsRequestExecutor.executeAsync(ApiRequest.createAnalyticsRequest(this.mAnalyticsDataFactory.create3ds2ChallengeParams("3ds2_challenge_flow_completed", StripeTextUtils.emptyIfNull(this.mStripeIntent.getId()), uiTypeCode, this.mPublishableKey), this.mPublishableKey, null));
            this.notifyCompletion(Stripe3ds2CompletionStarter.StartData.createForComplete(this.mStripeIntent, completionEvent.getTransactionStatus()));
        }

        public void cancelled(@NonNull String uiTypeCode) {
            super.cancelled(uiTypeCode);
            this.mAnalyticsRequestExecutor.executeAsync(ApiRequest.createAnalyticsRequest(this.mAnalyticsDataFactory.create3ds2ChallengeParams("3ds2_challenge_flow_canceled", StripeTextUtils.emptyIfNull(this.mStripeIntent.getId()), uiTypeCode, this.mPublishableKey), this.mPublishableKey, null));
            this.notifyCompletion(new Stripe3ds2CompletionStarter.StartData(this.mStripeIntent, 1));
        }

        public void timedout(@NonNull String uiTypeCode) {
            super.timedout(uiTypeCode);
            this.mAnalyticsRequestExecutor.executeAsync(ApiRequest.createAnalyticsRequest(this.mAnalyticsDataFactory.create3ds2ChallengeParams("3ds2_challenge_flow_timed_out", StripeTextUtils.emptyIfNull(this.mStripeIntent.getId()), uiTypeCode, this.mPublishableKey), this.mPublishableKey, null));
            this.notifyCompletion(new Stripe3ds2CompletionStarter.StartData(this.mStripeIntent, 2));
        }

        public void protocolError(@NonNull ProtocolErrorEvent protocolErrorEvent) {
            super.protocolError(protocolErrorEvent);
            this.mAnalyticsRequestExecutor.executeAsync(ApiRequest.createAnalyticsRequest(this.mAnalyticsDataFactory.create3ds2ChallengeErrorParams(StripeTextUtils.emptyIfNull(this.mStripeIntent.getId()), protocolErrorEvent, this.mPublishableKey), this.mPublishableKey, null));
            this.notifyCompletion(new Stripe3ds2CompletionStarter.StartData(this.mStripeIntent, 3));
        }

        public void runtimeError(@NonNull RuntimeErrorEvent runtimeErrorEvent) {
            super.runtimeError(runtimeErrorEvent);
            this.mAnalyticsRequestExecutor.executeAsync(ApiRequest.createAnalyticsRequest(this.mAnalyticsDataFactory.create3ds2ChallengeErrorParams(StripeTextUtils.emptyIfNull(this.mStripeIntent.getId()), runtimeErrorEvent, this.mPublishableKey), this.mPublishableKey, null));
            this.notifyCompletion(new Stripe3ds2CompletionStarter.StartData(this.mStripeIntent, 4));
        }

        private void notifyCompletion(final @NonNull Stripe3ds2CompletionStarter.StartData startData) {
            this.mAnalyticsRequestExecutor.executeAsync(ApiRequest.createAnalyticsRequest(this.mAnalyticsDataFactory.create3ds2ChallengeParams("3ds2_challenge_flow_presented", StripeTextUtils.emptyIfNull(this.mStripeIntent.getId()), StripeTextUtils.emptyIfNull(this.mTransaction.getInitialChallengeUiType()), this.mPublishableKey), this.mPublishableKey, null));
            this.mApiHandler.complete3ds2Auth(this.mSourceId, this.mPublishableKey, new ApiResultCallback<Boolean>(){

                @Override
                public void onSuccess(@NonNull Boolean result) {
                    PaymentAuth3ds2ChallengeStatusReceiver.this.mStarter.start(startData);
                }

                @Override
                public void onError(@NonNull Exception e) {
                    Activity activity = (Activity)PaymentAuth3ds2ChallengeStatusReceiver.this.mActivityRef.get();
                    if (activity != null) {
                        PaymentController.handleError(activity, PaymentController.getRequestCode(PaymentAuth3ds2ChallengeStatusReceiver.this.mStripeIntent), e);
                    }
                }
            });
        }
    }

    static final class Stripe3ds2AuthCallback
    implements ApiResultCallback<Stripe3ds2AuthResult> {
        @NonNull
        private final WeakReference<Activity> mActivityRef;
        @NonNull
        private final StripeApiHandler mApiHandler;
        @NonNull
        private final Transaction mTransaction;
        private final int mMaxTimeout;
        @NonNull
        private final StripeIntent mStripeIntent;
        @NonNull
        private final String mSourceId;
        @NonNull
        private final String mPublishableKey;
        @NonNull
        private final PaymentRelayStarter mPaymentRelayStarter;
        @NonNull
        private final Handler mBackgroundHandler;
        @NonNull
        private final FireAndForgetRequestExecutor mAnalyticsRequestExecutor;
        @NonNull
        private final AnalyticsDataFactory mAnalyticsDataFactory;

        private Stripe3ds2AuthCallback(@NonNull Activity activity, @NonNull StripeApiHandler apiHandler, @NonNull Transaction transaction, int maxTimeout, @NonNull StripeIntent stripeIntent, @NonNull String sourceId, @NonNull String publishableKey, @NonNull FireAndForgetRequestExecutor analyticsRequestExecutor, @NonNull AnalyticsDataFactory analyticsDataFactory) {
            this(activity, apiHandler, transaction, maxTimeout, stripeIntent, sourceId, publishableKey, new PaymentRelayStarter(activity, PaymentController.getRequestCode(stripeIntent)), analyticsRequestExecutor, analyticsDataFactory);
        }

        @VisibleForTesting
        Stripe3ds2AuthCallback(@NonNull Activity activity, @NonNull StripeApiHandler apiHandler, @NonNull Transaction transaction, int maxTimeout, @NonNull StripeIntent stripeIntent, @NonNull String sourceId, @NonNull String publishableKey, @NonNull PaymentRelayStarter paymentRelayStarter, @NonNull FireAndForgetRequestExecutor analyticsRequestExecutor, @NonNull AnalyticsDataFactory analyticsDataFactory) {
            this.mActivityRef = new WeakReference<Activity>(activity);
            this.mApiHandler = apiHandler;
            this.mTransaction = transaction;
            this.mMaxTimeout = maxTimeout;
            this.mStripeIntent = stripeIntent;
            this.mSourceId = sourceId;
            this.mPublishableKey = publishableKey;
            this.mPaymentRelayStarter = paymentRelayStarter;
            this.mAnalyticsRequestExecutor = analyticsRequestExecutor;
            this.mAnalyticsDataFactory = analyticsDataFactory;
            HandlerThread handlerThread = new HandlerThread(Stripe3ds2AuthCallback.class.getSimpleName());
            handlerThread.start();
            this.mBackgroundHandler = new Handler(handlerThread.getLooper());
        }

        @Override
        public void onSuccess(@NonNull Stripe3ds2AuthResult result) {
            Activity activity = (Activity)this.mActivityRef.get();
            if (activity == null) {
                return;
            }
            Stripe3ds2AuthResult.Ares ares = result.ares;
            if (ares != null) {
                if (ares.shouldChallenge()) {
                    this.startChallengeFlow(activity, ares);
                } else {
                    this.startFrictionlessFlow();
                }
            } else if (result.fallbackRedirectUrl != null) {
                PaymentController.beginWebAuth(activity, PaymentController.getRequestCode(this.mStripeIntent), Objects.requireNonNull(this.mStripeIntent.getClientSecret()), result.fallbackRedirectUrl, null);
            } else {
                Stripe3ds2AuthResult.ThreeDS2Error error = result.error;
                String errorMessage = error != null ? "Code: " + error.errorCode + ", Detail: " + error.errorDetail + ", Description: " + error.errorDescription + ", Component: " + error.errorComponent : "Invalid 3DS2 authentication response";
                this.onError(new RuntimeException("Error encountered during 3DS2 authentication request. " + errorMessage));
            }
        }

        @Override
        public void onError(@NonNull Exception e) {
            Activity activity = (Activity)this.mActivityRef.get();
            if (activity != null) {
                this.mPaymentRelayStarter.start(new PaymentRelayStarter.Data(e));
            }
        }

        private void startFrictionlessFlow() {
            this.mAnalyticsRequestExecutor.executeAsync(ApiRequest.createAnalyticsRequest(this.mAnalyticsDataFactory.createAuthParams("3ds2_frictionless_flow", StripeTextUtils.emptyIfNull(this.mStripeIntent.getId()), this.mPublishableKey), this.mPublishableKey, null));
            this.mPaymentRelayStarter.start(new PaymentRelayStarter.Data(this.mStripeIntent));
        }

        private void startChallengeFlow(final @NonNull Activity activity, @NonNull Stripe3ds2AuthResult.Ares ares) {
            final StripeChallengeParameters challengeParameters = new StripeChallengeParameters();
            challengeParameters.setAcsSignedContent(ares.acsSignedContent);
            challengeParameters.set3DSServerTransactionID(ares.threeDSServerTransId);
            challengeParameters.setAcsTransactionID(ares.acsTransId);
            this.mBackgroundHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    Stripe3ds2AuthCallback.this.mTransaction.doChallenge(activity, (ChallengeParameters)challengeParameters, (ChallengeStatusReceiver)PaymentAuth3ds2ChallengeStatusReceiver.create(activity, Stripe3ds2AuthCallback.this.mApiHandler, Stripe3ds2AuthCallback.this.mStripeIntent, Stripe3ds2AuthCallback.this.mSourceId, Stripe3ds2AuthCallback.this.mPublishableKey, Stripe3ds2AuthCallback.this.mAnalyticsRequestExecutor, Stripe3ds2AuthCallback.this.mAnalyticsDataFactory, Stripe3ds2AuthCallback.this.mTransaction), Stripe3ds2AuthCallback.this.mMaxTimeout);
                }
            }, TimeUnit.SECONDS.toMillis(2L));
        }
    }

    private static final class ConfirmStripeIntentCallback
    implements ApiResultCallback<StripeIntent> {
        @NonNull
        private final WeakReference<Activity> mActivityRef;
        @NonNull
        private final String mPublishableKey;
        @NonNull
        private final PaymentController mPaymentController;
        private final int mRequestCode;

        private ConfirmStripeIntentCallback(@NonNull Activity activity, @NonNull String publishableKey, @NonNull PaymentController paymentController, int requestCode) {
            this.mActivityRef = new WeakReference<Activity>(activity);
            this.mPublishableKey = publishableKey;
            this.mPaymentController = paymentController;
            this.mRequestCode = requestCode;
        }

        @Override
        public void onSuccess(@NonNull StripeIntent stripeIntent) {
            Activity activity = (Activity)this.mActivityRef.get();
            if (activity != null) {
                this.mPaymentController.handleNextAction(activity, stripeIntent, this.mPublishableKey);
            }
        }

        @Override
        public void onError(@NonNull Exception e) {
            Activity activity = (Activity)this.mActivityRef.get();
            if (activity != null) {
                PaymentController.handleError(activity, this.mRequestCode, e);
            }
        }
    }

    private static final class ConfirmStripeIntentTask
    extends ApiOperation<StripeIntent> {
        @NonNull
        private final Stripe mStripe;
        @NonNull
        private final ConfirmStripeIntentParams mParams;
        @NonNull
        private final String mPublishableKey;

        private ConfirmStripeIntentTask(@NonNull Stripe stripe, @NonNull ConfirmStripeIntentParams params, @NonNull String publishableKey, @NonNull ApiResultCallback<StripeIntent> callback) {
            super(callback);
            this.mStripe = stripe;
            this.mPublishableKey = publishableKey;
            this.mParams = params.withShouldUseStripeSdk(true);
        }

        @Override
        @Nullable
        StripeIntent getResult() throws StripeException {
            if (this.mParams instanceof ConfirmPaymentIntentParams) {
                return this.mStripe.confirmPaymentIntentSynchronous((ConfirmPaymentIntentParams)this.mParams, this.mPublishableKey);
            }
            if (this.mParams instanceof ConfirmSetupIntentParams) {
                return this.mStripe.confirmSetupIntentSynchronous((ConfirmSetupIntentParams)this.mParams, this.mPublishableKey);
            }
            return null;
        }
    }

    private static final class RetrieveIntentTask
    extends ApiOperation<StripeIntent> {
        @NonNull
        private final Stripe mStripe;
        @NonNull
        private final String mClientSecret;
        @NonNull
        private final String mPublishableKey;

        private RetrieveIntentTask(@NonNull Stripe stripe, @NonNull String clientSecret, @NonNull String publishableKey, @NonNull ApiResultCallback<StripeIntent> callback) {
            super(callback);
            this.mStripe = stripe;
            this.mClientSecret = clientSecret;
            this.mPublishableKey = publishableKey;
        }

        @Override
        @Nullable
        StripeIntent getResult() throws StripeException {
            if (this.mClientSecret.startsWith("pi_")) {
                return this.mStripe.retrievePaymentIntentSynchronous(this.mClientSecret, this.mPublishableKey);
            }
            if (this.mClientSecret.startsWith("seti_")) {
                return this.mStripe.retrieveSetupIntentSynchronous(this.mClientSecret, this.mPublishableKey);
            }
            return null;
        }
    }
}

