/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.stripe3ds2.init.ui.StripeToolbarCustomization;
import com.stripe.android.view.ActivityStarter;
import com.stripe.android.view.PaymentAuthWebViewActivity;

public class PaymentAuthWebViewStarter
implements ActivityStarter<Data> {
    public static final String EXTRA_AUTH_URL = "auth_url";
    public static final String EXTRA_CLIENT_SECRET = "client_secret";
    public static final String EXTRA_RETURN_URL = "return_url";
    public static final String EXTRA_UI_CUSTOMIZATION = "ui_customization";
    @NonNull
    private final Activity mActivity;
    private final int mRequestCode;
    @Nullable
    private final StripeToolbarCustomization mToolbarCustomization;

    PaymentAuthWebViewStarter(@NonNull Activity activity, int requestCode) {
        this(activity, requestCode, null);
    }

    PaymentAuthWebViewStarter(@NonNull Activity activity, int requestCode, @Nullable StripeToolbarCustomization toolbarCustomization) {
        this.mActivity = activity;
        this.mRequestCode = requestCode;
        this.mToolbarCustomization = toolbarCustomization;
    }

    @Override
    public void start(@NonNull Data data) {
        Intent intent = new Intent((Context)this.mActivity, PaymentAuthWebViewActivity.class).putExtra(EXTRA_CLIENT_SECRET, data.mClientSecret).putExtra(EXTRA_AUTH_URL, data.mUrl).putExtra(EXTRA_RETURN_URL, data.mReturnUrl).putExtra(EXTRA_UI_CUSTOMIZATION, (Parcelable)this.mToolbarCustomization);
        this.mActivity.startActivityForResult(intent, this.mRequestCode);
    }

    static final class Data {
        @NonNull
        private final String mClientSecret;
        @NonNull
        private final String mUrl;
        @Nullable
        private final String mReturnUrl;

        Data(@NonNull String clientSecret, @NonNull String url, @Nullable String returnUrl) {
            this.mClientSecret = clientSecret;
            this.mUrl = url;
            this.mReturnUrl = returnUrl;
        }
    }
}

