/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import com.stripe.android.model.StripeIntent;
import java.util.Objects;

public final class Stripe3dsRedirect {
    private static final String FIELD_STRIPE_JS = "stripe_js";
    @NonNull
    private final String mUrl;

    private Stripe3dsRedirect(@NonNull String url) {
        this.mUrl = url;
    }

    @NonNull
    public static Stripe3dsRedirect create(@NonNull StripeIntent.SdkData sdkData) {
        if (!sdkData.is3ds1()) {
            throw new IllegalArgumentException("Expected SdkData with type='three_d_secure_redirect'.");
        }
        return new Stripe3dsRedirect((String)Objects.requireNonNull(sdkData.data.get(FIELD_STRIPE_JS)));
    }

    @NonNull
    public String getUrl() {
        return this.mUrl;
    }
}

