/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.text.SpannableString;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.TypefaceSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Window;
import android.widget.ProgressBar;
import androidx.annotation.ColorInt;
import androidx.appcompat.app.AppCompatActivity;
import com.stripe.android.stripe3ds2.exceptions.InvalidInputException;
import com.stripe.android.stripe3ds2.init.ui.Customization;
import com.stripe.android.stripe3ds2.init.ui.UiCustomization;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b+\u0010,J\u0019\u0010\u0005\u001a\u00020\u00042\b\b\u0001\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u000e\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0010\u0010\tJ!\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00192\b\b\u0001\u0010\u001b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ!\u0010\"\u001a\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u001eH\u0001\u00a2\u0006\u0004\b \u0010!J%\u0010)\u001a\u00020(2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010'\u001a\u00020&\u00a2\u0006\u0004\b)\u0010*J\u0019\u0010\"\u001a\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0002H\u0001\u00a2\u0006\u0004\b \u0010\f\u00a8\u0006-"}, d2={"Lcom/stripe/android/stripe3ds2/utils/CustomizeUtils;", "", "", "color", "", "colorIntToHex", "(I)Ljava/lang/String;", "hexColor", "requireValidColor", "(Ljava/lang/String;)Ljava/lang/String;", "fontSize", "requireValidFontSize", "(I)I", "dimension", "requireValidDimension", "string", "requireValidString", "Landroid/widget/ProgressBar;", "progressBar", "Lcom/stripe/android/stripe3ds2/init/ui/UiCustomization;", "uiCustomization", "", "applyProgressBarColor$3ds2sdk_release", "(Landroid/widget/ProgressBar;Lcom/stripe/android/stripe3ds2/init/ui/UiCustomization;)V", "applyProgressBarColor", "Landroidx/appcompat/app/AppCompatActivity;", "activity", "statusBarColor", "setStatusBarColor", "(Landroidx/appcompat/app/AppCompatActivity;I)V", "", "factor", "darken$3ds2sdk_release", "(IF)I", "darken", "Landroid/content/Context;", "context", "text", "Lcom/stripe/android/stripe3ds2/init/ui/Customization;", "customization", "Landroid/text/SpannableString;", "buildStyledText", "(Landroid/content/Context;Ljava/lang/String;Lcom/stripe/android/stripe3ds2/init/ui/Customization;)Landroid/text/SpannableString;", "<init>", "()V", "3ds2sdk_release"})
public final class CustomizeUtils {
    @NotNull
    public static final CustomizeUtils INSTANCE = new CustomizeUtils();

    @JvmStatic
    @NotNull
    public static final String colorIntToHex(@ColorInt int n2) {
        int n3 = n2;
        n2 = Color.alpha((int)n3);
        int n4 = Color.blue((int)n3);
        int n5 = Color.green((int)n3);
        int n6 = Color.red((int)n3);
        StringBuilder stringBuilder = new StringBuilder().append("#");
        Locale locale = Locale.ENGLISH;
        String string2 = String.format(locale, "%02X", Arrays.copyOf(new Object[]{n2}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
        StringBuilder stringBuilder2 = stringBuilder.append(string2);
        String string3 = String.format(locale, "%02X", Arrays.copyOf(new Object[]{n6}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
        StringBuilder stringBuilder3 = stringBuilder2.append(string3);
        String string4 = String.format(locale, "%02X", Arrays.copyOf(new Object[]{n5}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(locale, format, *args)");
        StringBuilder stringBuilder4 = stringBuilder3.append(string4);
        String string5 = String.format(locale, "%02X", Arrays.copyOf(new Object[]{n4}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(locale, format, *args)");
        return stringBuilder4.append(string5).toString();
    }

    @JvmStatic
    @NotNull
    public static final String requireValidColor(@NotNull String string2) throws InvalidInputException {
        Object object;
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"hexColor");
        Color.parseColor((String)string3);
        try {
            object = Result.constructor-impl((Object)string3);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        if (Result.exceptionOrNull-impl((Object)object) == null) {
            return (String)object;
        }
        throw new InvalidInputException("Unable to parse color: " + string2, null, 2, null);
    }

    @JvmStatic
    public static final int requireValidFontSize(int n2) throws InvalidInputException {
        if (n2 > 0) {
            return n2;
        }
        throw new InvalidInputException("Font size must be greater than 0", null, 2, null);
    }

    @JvmStatic
    public static final int requireValidDimension(int n2) throws InvalidInputException {
        if (n2 >= 0) {
            return n2;
        }
        throw new InvalidInputException("Dimension must be greater or equal to 0", null, 2, null);
    }

    @JvmStatic
    @NotNull
    public static final String requireValidString(@NotNull String string2) throws InvalidInputException {
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"string");
        if (!StringsKt.isBlank((CharSequence)string3)) {
            return string2;
        }
        throw new InvalidInputException("String must not be null or empty", null, 2, null);
    }

    public final void applyProgressBarColor$3ds2sdk_release(@NotNull ProgressBar progressBar, @Nullable UiCustomization uiCustomization) {
        Intrinsics.checkNotNullParameter((Object)progressBar, (String)"progressBar");
        if (uiCustomization != null && (this = uiCustomization.getAccentColor()) != null) {
            progressBar.setIndeterminateTintList(ColorStateList.valueOf((int)Color.parseColor((String)this)));
        }
    }

    public final void setStatusBarColor(@NotNull AppCompatActivity appCompatActivity, @ColorInt int n2) {
        AppCompatActivity appCompatActivity2 = appCompatActivity;
        Intrinsics.checkNotNullParameter((Object)appCompatActivity2, (String)"activity");
        Window window = appCompatActivity2.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"activity.window");
        window.setStatusBarColor(n2);
    }

    @ColorInt
    public final int darken$3ds2sdk_release(@ColorInt int n2, float f2) {
        int n3 = Color.alpha((int)n2);
        int n4 = n2;
        int n5 = (int)((float)Color.red((int)n4) * f2);
        n2 = (int)((float)Color.green((int)n4) * f2);
        n5 = Math.min(Math.max(n5, 0), 255);
        n2 = Math.min(Math.max(n2, 0), 255);
        int n6 = Math.min(Math.max((int)((float)Color.blue((int)n4) * f2), 0), 255);
        return Color.argb((int)n3, (int)n5, (int)n2, (int)n6);
    }

    @NotNull
    public final SpannableString buildStyledText(@NotNull Context object, @NotNull String string2, @NotNull Customization customization) {
        Integer n2;
        SpannableString spannableString;
        Customization customization2 = customization;
        Intrinsics.checkNotNullParameter((Object)object, (String)"context");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)customization2, (String)"customization");
        CustomizeUtils customizeUtils = spannableString;
        spannableString = new SpannableString((CharSequence)string2);
        string2 = customization2.getTextColor();
        if (string2 != null) {
            ForegroundColorSpan foregroundColorSpan;
            CustomizeUtils customizeUtils2 = customizeUtils;
            ForegroundColorSpan foregroundColorSpan2 = foregroundColorSpan;
            foregroundColorSpan = new ForegroundColorSpan(Color.parseColor((String)string2));
            int n3 = customizeUtils2.length();
            customizeUtils2.setSpan(foregroundColorSpan2, 0, n3, 0);
        }
        if (!((n2 = Integer.valueOf(customization.getTextFontSize())) > 0)) {
            n2 = null;
        }
        if (n2 != null) {
            AbsoluteSizeSpan absoluteSizeSpan;
            CustomizeUtils customizeUtils3 = customizeUtils;
            float f2 = ((Number)n2).intValue();
            Resources resources = object.getResources();
            Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
            n2 = resources.getDisplayMetrics();
            int n4 = (int)TypedValue.applyDimension((int)2, (float)f2, (DisplayMetrics)n2);
            n2 = absoluteSizeSpan;
            absoluteSizeSpan = new AbsoluteSizeSpan(n4);
            n4 = customizeUtils3.length();
            customizeUtils3.setSpan(n2, 0, n4, 0);
        }
        if ((object = customization.getTextFontName()) != null) {
            TypefaceSpan typefaceSpan;
            CustomizeUtils customizeUtils4 = customizeUtils;
            n2 = typefaceSpan;
            typefaceSpan = new TypefaceSpan((String)object);
            int n5 = customizeUtils4.length();
            customizeUtils4.setSpan(n2, 0, n5, 0);
        }
        return customizeUtils;
    }

    @ColorInt
    public final int darken$3ds2sdk_release(@ColorInt int n2) {
        return this.darken$3ds2sdk_release(n2, 0.8f);
    }
}

