/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.transaction;

import androidx.annotation.VisibleForTesting;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.bc.BouncyCastleProviderSingleton;
import com.nimbusds.jose.crypto.factories.DefaultJWSVerifierFactory;
import com.nimbusds.jose.jca.JCAContext;
import com.nimbusds.jose.util.Base64;
import com.nimbusds.jose.util.X509CertChainUtils;
import com.nimbusds.jose.util.X509CertUtils;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/JwsValidator;", "", "()V", "getPayload", "Lorg/json/JSONObject;", "jws", "", "isLiveMode", "", "rootCerts", "", "Ljava/security/cert/X509Certificate;", "getPublicKeyFromHeader", "Ljava/security/PublicKey;", "jwsHeader", "Lcom/nimbusds/jose/JWSHeader;", "getVerifier", "Lcom/nimbusds/jose/JWSVerifier;", "isValid", "jwsObject", "Lcom/nimbusds/jose/JWSObject;", "Companion", "sdk_release"})
public class n {
    public static final a a = new a(null);

    private final PublicKey a(JWSHeader jWSHeader) throws CertificateException {
        List list = jWSHeader.getX509CertChain();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"jwsHeader.x509CertChain");
        X509Certificate x509Certificate = X509CertUtils.parseWithException((byte[])((Base64)CollectionsKt.first((List)list)).decode());
        Intrinsics.checkExpressionValueIsNotNull((Object)x509Certificate, (String)"X509CertUtils.parseWithE\u2026irst().decode()\n        )");
        PublicKey publicKey = x509Certificate.getPublicKey();
        Intrinsics.checkExpressionValueIsNotNull((Object)publicKey, (String)"X509CertUtils.parseWithE\u2026ode()\n        ).publicKey");
        return publicKey;
    }

    @NotNull
    public JSONObject a(@NotNull String string, boolean bl, @NotNull List<? extends X509Certificate> defaultJWSVerifierFactory) throws JSONException, ParseException, JOSEException, CertificateException {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"jws");
        Intrinsics.checkParameterIsNotNull(defaultJWSVerifierFactory, (String)"rootCerts");
        string = JWSObject.parse((String)string);
        if (bl) {
            boolean bl2;
            JWSHeader jWSHeader;
            String string2 = string;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"jwsObject");
            JWSHeader jWSHeader2 = jWSHeader = string2.getHeader();
            Intrinsics.checkExpressionValueIsNotNull((Object)jWSHeader2, (String)"jwsHeader");
            if (!a.a(jWSHeader2.getX509CertChain(), (List<? extends X509Certificate>)defaultJWSVerifierFactory)) {
                bl2 = false;
            } else {
                DefaultJWSVerifierFactory defaultJWSVerifierFactory2;
                DefaultJWSVerifierFactory defaultJWSVerifierFactory3 = defaultJWSVerifierFactory = defaultJWSVerifierFactory2;
                defaultJWSVerifierFactory3();
                JCAContext jCAContext = defaultJWSVerifierFactory3.getJCAContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)jCAContext, (String)"verifierFactory.jcaContext");
                jCAContext.setProvider((Provider)BouncyCastleProviderSingleton.getInstance());
                JWSVerifier jWSVerifier = defaultJWSVerifierFactory2.createJWSVerifier(jWSHeader, (Key)this.a(jWSHeader));
                Intrinsics.checkExpressionValueIsNotNull((Object)jWSVerifier, (String)"verifierFactory.createJW\u2026KeyFromHeader(jwsHeader))");
                bl2 = string.verify(jWSVerifier);
            }
            if (!bl2) {
                throw new IllegalStateException("Could not validate JWS");
            }
        }
        String string3 = string;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"jwsObject");
        return new JSONObject(string3.getPayload().toString());
    }

    public static final class a {
        private final void b(List<? extends Base64> object, List<? extends X509Certificate> object2) throws GeneralSecurityException, IOException, ParseException {
            CollectionCertStoreParameters collectionCertStoreParameters;
            PKIXBuilderParameters pKIXBuilderParameters;
            X509CertSelector x509CertSelector;
            a a2 = list;
            List list = X509CertChainUtils.parse(object);
            object = a2.a((List<? extends X509Certificate>)object2);
            object2 = x509CertSelector;
            ((X509CertSelector)object2)();
            x509CertSelector.setCertificate((X509Certificate)list.get(0));
            PKIXBuilderParameters pKIXBuilderParameters2 = pKIXBuilderParameters;
            new PKIXBuilderParameters((KeyStore)object, (CertSelector)object2).setRevocationEnabled(false);
            object = collectionCertStoreParameters;
            collectionCertStoreParameters = new CollectionCertStoreParameters(list);
            pKIXBuilderParameters2.addCertStore(CertStore.getInstance("Collection", (CertStoreParameters)object));
            CertPathBuilder.getInstance("PKIX").build(pKIXBuilderParameters2);
        }

        private a() {
        }

        public /* synthetic */ a(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        @VisibleForTesting
        public final boolean a(@Nullable List<? extends Base64> list, @NotNull List<? extends X509Certificate> list2) {
            Intrinsics.checkParameterIsNotNull(list2, (String)"rootCerts");
            if (list != null && !list.isEmpty() && !list2.isEmpty()) {
                try {
                    this.b(list, list2);
                    return true;
                }
                catch (ParseException parseException) {
                    return false;
                }
                catch (IOException iOException) {
                    return false;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    return false;
                }
            }
            return false;
        }

        @VisibleForTesting
        @NotNull
        public final KeyStore a(@NotNull List<? extends X509Certificate> list) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
            List<? extends X509Certificate> list2 = list;
            Intrinsics.checkParameterIsNotNull(list2, (String)"rootCerts");
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            int n2 = 0;
            for (Object t2 : list2) {
                int n3 = n2 + 1;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                X509Certificate cfr_ignored_0 = (X509Certificate)t2;
                Locale locale = Locale.ROOT;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
                String string = String.format(locale, "ca_%d", Arrays.copyOf(new Object[]{n2}, 1));
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"java.lang.String.format(locale, format, *args)");
                keyStore.setCertificateEntry(string, list.get(n2));
                n2 = n3;
            }
            Object object = keyStore;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"keyStore");
            return object;
        }
    }
}

