/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.init.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.TypedValue;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.R;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.core.content.ContextCompat;
import com.stripe.android.stripe3ds2.exceptions.InvalidInputException;
import com.stripe.android.stripe3ds2.init.ui.BaseCustomization;
import com.stripe.android.stripe3ds2.init.ui.ButtonCustomization;
import com.stripe.android.stripe3ds2.init.ui.LabelCustomization;
import com.stripe.android.stripe3ds2.init.ui.StripeButtonCustomization;
import com.stripe.android.stripe3ds2.init.ui.StripeLabelCustomization;
import com.stripe.android.stripe3ds2.init.ui.StripeTextBoxCustomization;
import com.stripe.android.stripe3ds2.init.ui.StripeToolbarCustomization;
import com.stripe.android.stripe3ds2.init.ui.TextBoxCustomization;
import com.stripe.android.stripe3ds2.init.ui.ToolbarCustomization;
import com.stripe.android.stripe3ds2.init.ui.UiCustomization;
import com.stripe.android.stripe3ds2.utils.CustomizeUtils;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kotlin.jvm.internal.Intrinsics;

public final class StripeUiCustomization
implements UiCustomization,
Parcelable {
    public static final Parcelable.Creator<StripeUiCustomization> CREATOR = new Parcelable.Creator<StripeUiCustomization>(){

        public Object[] newArray(int n2) {
            return new StripeUiCustomization[n2];
        }

        public Object createFromParcel(Parcel parcel) {
            return new StripeUiCustomization(parcel);
        }
    };
    @Nullable
    private ToolbarCustomization a;
    @Nullable
    private LabelCustomization b;
    @Nullable
    private TextBoxCustomization c;
    @NonNull
    private final Map<UiCustomization.ButtonType, ButtonCustomization> d;
    @NonNull
    private final Map<String, ButtonCustomization> e;
    @Nullable
    private String f;

    public StripeUiCustomization() {
        HashMap hashMap;
        EnumMap enumMap;
        Object object = enumMap;
        enumMap = new EnumMap(UiCustomization.ButtonType.class);
        v1.d = object;
        object = hashMap;
        hashMap = new HashMap();
        v1.e = object;
    }

    @NonNull
    public static StripeUiCustomization createWithAppTheme(@NonNull Activity activity) {
        return new StripeUiCustomization(activity);
    }

    private StripeUiCustomization(@NonNull Activity object) {
        this();
        StripeButtonCustomization stripeButtonCustomization;
        StripeButtonCustomization stripeButtonCustomization2;
        StripeTextBoxCustomization stripeTextBoxCustomization;
        StripeLabelCustomization stripeLabelCustomization;
        StripeToolbarCustomization stripeToolbarCustomization;
        Object object2 = this.a((Activity)object, R.attr.actionBarTheme);
        int n2 = Build.VERSION.SDK_INT >= 21 ? 16843827 : R.attr.colorPrimary;
        String string = this.a((Context)object, n2);
        int n3 = Build.VERSION.SDK_INT >= 21 ? 16843828 : R.attr.colorPrimaryDark;
        Context context = object2;
        object2 = this.a((Context)object, n3);
        String string2 = this.a(context, 16842806);
        String string3 = this.a((Context)object, 16842904);
        int n4 = Build.VERSION.SDK_INT >= 21 ? 16843829 : R.attr.colorAccent;
        StripeUiCustomization stripeUiCustomization = this;
        String string4 = stripeUiCustomization.a((Context)object, n4);
        object = stripeUiCustomization.a((Context)object, 16842906);
        StripeUiCustomization stripeUiCustomization2 = this;
        BaseCustomization baseCustomization = stripeToolbarCustomization;
        stripeToolbarCustomization = new StripeToolbarCustomization();
        stripeUiCustomization2.a = baseCustomization;
        baseCustomization = stripeLabelCustomization;
        stripeLabelCustomization = new StripeLabelCustomization();
        stripeUiCustomization2.b = baseCustomization;
        baseCustomization = stripeTextBoxCustomization;
        stripeTextBoxCustomization = new StripeTextBoxCustomization();
        stripeUiCustomization2.c = baseCustomization;
        if (object != null) {
            baseCustomization.setHintTextColor((String)object);
        }
        object = stripeButtonCustomization2;
        stripeButtonCustomization2 = new StripeButtonCustomization();
        baseCustomization = stripeButtonCustomization;
        stripeButtonCustomization = new StripeButtonCustomization();
        if (string2 != null) {
            this.a.setTextColor(string2);
            object.setTextColor(string2);
        }
        if (string != null) {
            this.a.setBackgroundColor(string);
        }
        if (object2 != null) {
            this.a.setStatusBarColor((String)object2);
        }
        if (string3 != null) {
            StripeUiCustomization stripeUiCustomization3 = this;
            stripeUiCustomization3.b.setTextColor(string3);
            stripeUiCustomization3.b.setHeadingTextColor(string3);
            baseCustomization.setTextColor(string3);
            this.c.setTextColor(string3);
        }
        if (string4 != null) {
            StripeButtonCustomization stripeButtonCustomization3;
            StripeUiCustomization stripeUiCustomization4 = this;
            stripeUiCustomization4.setAccentColor(string4);
            object2 = stripeButtonCustomization3;
            new StripeButtonCustomization().setTextColor(string4);
            stripeUiCustomization4.setButtonCustomization((ButtonCustomization)object2, UiCustomization.ButtonType.RESEND);
            baseCustomization.setBackgroundColor(string4);
        }
        StripeUiCustomization stripeUiCustomization5 = this;
        stripeUiCustomization5.setButtonCustomization((ButtonCustomization)object, UiCustomization.ButtonType.CANCEL);
        stripeUiCustomization5.setButtonCustomization((ButtonCustomization)((Object)baseCustomization), UiCustomization.ButtonType.NEXT);
        stripeUiCustomization5.setButtonCustomization((ButtonCustomization)((Object)baseCustomization), UiCustomization.ButtonType.CONTINUE);
        stripeUiCustomization5.setButtonCustomization((ButtonCustomization)((Object)baseCustomization), UiCustomization.ButtonType.SUBMIT);
        stripeUiCustomization5.setButtonCustomization((ButtonCustomization)((Object)baseCustomization), UiCustomization.ButtonType.SELECT);
    }

    @Nullable
    private String a(@NonNull Context context, @AttrRes int n2) {
        TypedValue typedValue;
        StripeUiCustomization stripeUiCustomization = typedValue;
        typedValue = new TypedValue();
        if (context.getTheme().resolveAttribute(n2, (TypedValue)stripeUiCustomization, true)) {
            n2 = ((TypedValue)stripeUiCustomization).resourceId;
            return CustomizeUtils.colorIntToHex(n2 != 0 ? ContextCompat.getColor((Context)context, (int)n2) : ((TypedValue)stripeUiCustomization).data);
        }
        return null;
    }

    @NonNull
    private Context a(@NonNull Activity activity, @AttrRes int n2) {
        TypedValue typedValue;
        StripeUiCustomization stripeUiCustomization = typedValue;
        typedValue = new TypedValue();
        if (activity.getTheme().resolveAttribute(n2, (TypedValue)stripeUiCustomization, true)) {
            return new ContextThemeWrapper((Context)activity, ((TypedValue)stripeUiCustomization).resourceId);
        }
        return activity;
    }

    private StripeUiCustomization(Parcel parcel) {
        StripeUiCustomization stripeUiCustomization = this;
        this.f = parcel.readString();
        this.a = (ToolbarCustomization)parcel.readParcelable(StripeToolbarCustomization.class.getClassLoader());
        this.b = (LabelCustomization)parcel.readParcelable(StripeLabelCustomization.class.getClassLoader());
        stripeUiCustomization.c = (TextBoxCustomization)parcel.readParcelable(StripeTextBoxCustomization.class.getClassLoader());
        stripeUiCustomization.d = new HashMap<UiCustomization.ButtonType, ButtonCustomization>();
        Bundle bundle = parcel.readBundle(StripeUiCustomization.class.getClassLoader());
        if (bundle != null) {
            for (Object object2 : bundle.keySet()) {
                ButtonCustomization buttonCustomization = (ButtonCustomization)bundle.getParcelable((String)object2);
                if (buttonCustomization == null) continue;
                this.d.put(UiCustomization.ButtonType.valueOf((String)object2), buttonCustomization);
            }
        }
        this.e = new HashMap<String, ButtonCustomization>();
        if ((parcel = parcel.readBundle(StripeUiCustomization.class.getClassLoader())) != null) {
            for (Object object : parcel.keySet()) {
                Object object2;
                object2 = (ButtonCustomization)parcel.getParcelable((String)object);
                if (object2 == null) continue;
                this.e.put((String)object, (ButtonCustomization)object2);
            }
        }
    }

    @Override
    public void setButtonCustomization(@NonNull ButtonCustomization buttonCustomization, @NonNull UiCustomization.ButtonType buttonType) throws InvalidInputException {
        this.d.put(buttonType, buttonCustomization);
    }

    @Override
    public void setButtonCustomization(@NonNull ButtonCustomization buttonCustomization, @NonNull String string) throws InvalidInputException {
        this.e.put(string, buttonCustomization);
    }

    @Override
    public void setToolbarCustomization(@NonNull ToolbarCustomization toolbarCustomization) throws InvalidInputException {
        this.a = toolbarCustomization;
    }

    @Override
    public void setLabelCustomization(@NonNull LabelCustomization labelCustomization) throws InvalidInputException {
        this.b = labelCustomization;
    }

    @Override
    public void setTextBoxCustomization(@NonNull TextBoxCustomization textBoxCustomization) throws InvalidInputException {
        this.c = textBoxCustomization;
    }

    @Override
    public void setAccentColor(@NonNull String string) {
        this.f = CustomizeUtils.requireValidColor(string);
    }

    @Override
    @Nullable
    public ButtonCustomization getButtonCustomization(@NonNull UiCustomization.ButtonType buttonType) throws InvalidInputException {
        return this.d.get((Object)buttonType);
    }

    @Override
    @Nullable
    public ButtonCustomization getButtonCustomization(@NonNull String string) throws InvalidInputException {
        return this.e.get(string);
    }

    @Override
    @Nullable
    public ToolbarCustomization getToolbarCustomization() {
        return this.a;
    }

    @Override
    @Nullable
    public LabelCustomization getLabelCustomization() {
        return this.b;
    }

    @Override
    @Nullable
    public TextBoxCustomization getTextBoxCustomization() {
        return this.c;
    }

    @Override
    @Nullable
    public String getAccentColor() {
        return this.f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object object) {
        if (this == object) return true;
        if (!(object instanceof StripeUiCustomization)) return false;
        object = (StripeUiCustomization)object;
        if (!Intrinsics.areEqual((Object)this.a, (Object)((StripeUiCustomization)object).a)) return false;
        if (!Intrinsics.areEqual((Object)this.f, (Object)((StripeUiCustomization)object).f)) return false;
        if (!Intrinsics.areEqual((Object)this.b, (Object)((StripeUiCustomization)object).b)) return false;
        if (!Intrinsics.areEqual((Object)this.c, (Object)((StripeUiCustomization)object).c)) return false;
        if (!Intrinsics.areEqual(this.d, ((StripeUiCustomization)object).d)) return false;
        if (!Intrinsics.areEqual(this.e, ((StripeUiCustomization)object).e)) return false;
        return true;
    }

    public int hashCode() {
        int n2 = 6;
        Object[] objectArray = new Object[]{this.a, this.f, this.b, this.c, this.d, this.e};
        Intrinsics.checkParameterIsNotNull((Object)objectArray, (String)"values");
        return Objects.hash(Arrays.copyOf(objectArray, n2));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel parcel, int n2) {
        Bundle bundle;
        Bundle bundle2;
        StripeUiCustomization stripeUiCustomization2;
        parcel.writeString(stripeUiCustomization2.f);
        parcel.writeParcelable((Parcelable)((StripeToolbarCustomization)stripeUiCustomization2.a), 0);
        parcel.writeParcelable((Parcelable)((StripeLabelCustomization)stripeUiCustomization2.b), 0);
        parcel.writeParcelable((Parcelable)((StripeTextBoxCustomization)stripeUiCustomization2.c), 0);
        Bundle bundle3 = bundle2;
        bundle2 = new Bundle();
        for (Map.Entry<UiCustomization.ButtonType, ButtonCustomization> entry : stripeUiCustomization2.d.entrySet()) {
            bundle3.putParcelable(entry.getKey().name(), (Parcelable)((StripeButtonCustomization)entry.getValue()));
        }
        StripeUiCustomization stripeUiCustomization = stripeUiCustomization2;
        parcel.writeBundle(bundle3);
        stripeUiCustomization2 = bundle;
        bundle = new Bundle();
        for (Map.Entry entry : stripeUiCustomization.e.entrySet()) {
            stripeUiCustomization2.putParcelable((String)entry.getKey(), (StripeButtonCustomization)entry.getValue());
        }
        parcel.writeBundle((Bundle)stripeUiCustomization2);
    }
}

