/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.init.ui;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.stripe.android.stripe3ds2.exceptions.InvalidInputException;
import com.stripe.android.stripe3ds2.init.ui.BaseCustomization;
import com.stripe.android.stripe3ds2.init.ui.TextBoxCustomization;
import com.stripe.android.stripe3ds2.utils.CustomizeUtils;
import java.util.Arrays;
import java.util.Objects;
import kotlin.jvm.internal.Intrinsics;

public final class StripeTextBoxCustomization
extends BaseCustomization
implements TextBoxCustomization,
Parcelable {
    public static final Parcelable.Creator<StripeTextBoxCustomization> CREATOR = new Parcelable.Creator<StripeTextBoxCustomization>(){

        public Object[] newArray(int n2) {
            return new StripeTextBoxCustomization[n2];
        }

        public Object createFromParcel(@NonNull Parcel parcel) {
            return new StripeTextBoxCustomization(parcel);
        }
    };
    private int d;
    @Nullable
    private String e;
    private int f;
    @Nullable
    private String g;

    public StripeTextBoxCustomization() {
    }

    private StripeTextBoxCustomization(@NonNull Parcel parcel) {
        super(parcel);
        this.d = parcel.readInt();
        this.e = parcel.readString();
        this.f = parcel.readInt();
        this.g = parcel.readString();
    }

    @Override
    public void setBorderWidth(int n2) throws InvalidInputException {
        this.d = CustomizeUtils.requireValidDimension(n2);
    }

    @Override
    public int getBorderWidth() {
        return this.d;
    }

    @Override
    public void setBorderColor(@NonNull String string2) throws InvalidInputException {
        this.e = CustomizeUtils.requireValidColor(string2);
    }

    @Override
    @Nullable
    public String getBorderColor() {
        return this.e;
    }

    @Override
    public void setCornerRadius(int n2) throws InvalidInputException {
        this.f = CustomizeUtils.requireValidDimension(n2);
    }

    @Override
    public int getCornerRadius() {
        return this.f;
    }

    @Override
    public void setHintTextColor(@NonNull String string2) throws InvalidInputException {
        this.g = CustomizeUtils.requireValidColor(string2);
    }

    @Override
    @Nullable
    public String getHintTextColor() {
        return this.g;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object object) {
        if (this == object) return true;
        if (!(object instanceof StripeTextBoxCustomization)) return false;
        object = (StripeTextBoxCustomization)object;
        if (this.d != ((StripeTextBoxCustomization)object).d) return false;
        if (!Intrinsics.areEqual((Object)this.e, (Object)((StripeTextBoxCustomization)object).e)) return false;
        if (this.f != ((StripeTextBoxCustomization)object).f) return false;
        if (!Intrinsics.areEqual((Object)this.g, (Object)((StripeTextBoxCustomization)object).g)) return false;
        return true;
    }

    public int hashCode() {
        int n2 = 4;
        Object[] objectArray = new Object[]{this.d, this.e, this.f, this.g};
        Intrinsics.checkParameterIsNotNull((Object)objectArray, (String)"values");
        return Objects.hash(Arrays.copyOf(objectArray, n2));
    }

    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int n2) {
        StripeTextBoxCustomization stripeTextBoxCustomization = this;
        super.writeToParcel(parcel, n2);
        parcel.writeInt(stripeTextBoxCustomization.d);
        parcel.writeString(this.e);
        parcel.writeInt(this.f);
        parcel.writeString(this.g);
    }
}

