/*
 * Copyright 2017 StreamSets Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.streamsets.pipeline.sdk;

import com.streamsets.pipeline.api.Stage;
import com.streamsets.pipeline.api.StageDef;

/**
 * A utility class that offers various methods to help validate proper stage configuration.
 */
public class StageValidator {

  private StageValidator() {
    // Do not instantiate
  }

  /**
   * Returns if and only if both stage classes have defined the same version.
   */
  public static boolean isSameVersion(Class<? extends Stage> a, Class<? extends Stage> b) {
    StageDef aDef = a.getAnnotation(StageDef.class);
    StageDef bDef = b.getAnnotation(StageDef.class);

    return aDef.version() == bDef.version();
  }
}
