/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi.impl.j2ssh;

import com.sshtools.j2ssh.session.SessionChannelClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.sshapi.AbstractDataProducingComponent;
import net.sf.sshapi.SshConfiguration;
import net.sf.sshapi.SshException;
import net.sf.sshapi.SshExtendedStreamChannel;
import net.sf.sshapi.util.Util;

abstract class J2SshStreamChannel
extends AbstractDataProducingComponent
implements SshExtendedStreamChannel {
    private final SessionChannelClient channel;
    private final SshConfiguration configuration;

    public J2SshStreamChannel(SshConfiguration configuration, SessionChannelClient channel) {
        this.channel = channel;
        this.configuration = configuration;
    }

    public int exitCode() throws IOException {
        Integer i = this.channel.getExitCode();
        return i == null ? -1 : i;
    }

    public InputStream getInputStream() throws IOException {
        return this.channel.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.channel.getOutputStream();
    }

    public InputStream getExtendedInputStream() throws IOException {
        return this.channel.getStderrInputStream();
    }

    protected SessionChannelClient getChannel() {
        return this.channel;
    }

    public final void onOpen() throws SshException {
        if (this.configuration.getX11Cookie() != null) {
            byte[] x11Cookie = this.configuration.getX11Cookie();
            String hexCookie = Util.formatAsHexString((byte[])x11Cookie);
            int x11Port = this.configuration.getX11Port();
            try {
                this.channel.requestX11Forwarding(x11Port - 6000, hexCookie);
            }
            catch (IOException e) {
                throw new SshException(SshException.IO_ERROR, (Throwable)e);
            }
        }
        this.onChannelOpen();
    }

    public void onClose() throws SshException {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            throw new SshException(SshException.IO_ERROR, (Throwable)e);
        }
    }

    protected abstract void onChannelOpen() throws SshException;
}

