/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi.impl.j2ssh;

import com.sshtools.j2ssh.session.PseudoTerminal;
import com.sshtools.j2ssh.session.SessionChannelClient;
import java.io.IOException;
import java.io.InputStream;
import net.sf.sshapi.SshConfiguration;
import net.sf.sshapi.SshException;
import net.sf.sshapi.SshShell;
import net.sf.sshapi.impl.j2ssh.J2SshStreamChannel;

class J2SshShell
extends J2SshStreamChannel
implements SshShell {
    public J2SshShell(SshConfiguration configuration, SessionChannelClient session) {
        super(configuration, session);
    }

    public InputStream getExtendedInputStream() throws IOException {
        return this.getShellChannel().getStderrInputStream();
    }

    private SessionChannelClient getShellChannel() {
        return this.getChannel();
    }

    public final void onChannelOpen() throws SshException {
        try {
            if (!this.getShellChannel().startShell()) {
                throw new SshException("Failed to start shell.");
            }
        }
        catch (IOException e) {
            throw new SshException(SshException.IO_ERROR, (Throwable)e);
        }
    }

    public void requestPseudoTerminalChange(final int width, final int height, final int pixw, final int pixh) throws SshException {
        try {
            this.getShellChannel().changeTerminalDimensions(new PseudoTerminal(){

                public int getWidth() {
                    return pixw;
                }

                public String getTerm() {
                    throw new UnsupportedOperationException();
                }

                public int getRows() {
                    return height;
                }

                public int getHeight() {
                    return pixh;
                }

                public String getEncodedTerminalModes() {
                    throw new UnsupportedOperationException();
                }

                public int getColumns() {
                    return width;
                }
            });
        }
        catch (IOException e) {
            throw new SshException(SshException.IO_ERROR, (Throwable)e);
        }
    }
}

