/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi.impl.j2ssh;

import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.sftp.FileAttributes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.sf.sshapi.SshException;
import net.sf.sshapi.sftp.AbstractSftpClient;
import net.sf.sshapi.sftp.SftpException;
import net.sf.sshapi.sftp.SftpFile;

class J2SshSftpClient
extends AbstractSftpClient {
    private final SshClient client;
    private SftpClient sftpClient;
    private String home;

    public J2SshSftpClient(SshClient client) {
        this.client = client;
    }

    public void onClose() throws SshException {
    }

    public SftpFile[] ls(String path) throws SshException {
        try {
            List entries = this.sftpClient.ls(path);
            SftpFile[] files = new SftpFile[entries.size()];
            for (int i = 0; i < files.length; ++i) {
                files[i] = this.entryToFile(path, (com.sshtools.j2ssh.sftp.SftpFile)entries.get(i));
            }
            return files;
        }
        catch (IOException e) {
            throw new SshException("Failed to list directory.", (Throwable)e);
        }
    }

    private SftpFile entryToFile(String path, com.sshtools.j2ssh.sftp.SftpFile entry) throws com.sshtools.j2ssh.SshException {
        FileAttributes attr = entry.getAttributes();
        SftpFile file = new SftpFile(this.convertType(attr), entry.getAbsolutePath(), attr.getSize().longValue(), this.toLong(attr.getModifiedTime()), 0L, this.toLong(attr.getAccessedTime()), (int)this.toLong(attr.getGID()), (int)this.toLong(attr.getUID()), (int)this.toLong(attr.getPermissions()));
        return file;
    }

    long convertIntDate(Integer date) {
        return date == null ? 0L : (long)date.intValue() * 1000L;
    }

    public void onOpen() throws SshException {
        try {
            this.sftpClient = this.client.openSftpClient();
            this.home = this.sftpClient.pwd();
        }
        catch (IOException e) {
            throw new SshException("Failed to open SFTP client.", (Throwable)e);
        }
    }

    public String getDefaultPath() throws SshException {
        return this.home;
    }

    public void mkdir(String path, int permissions) throws SshException {
        try {
            this.sftpClient.mkdir(path);
        }
        catch (IOException e) {
            throw new SshException("Failed to create directory.", (Throwable)e);
        }
    }

    public void mkdirs(String path, int permissions) throws SshException {
        this.sftpClient.mkdirs(path);
    }

    public void rm(String path) throws SshException {
        try {
            SftpFile file = this.stat(path);
            if (file.isDirectory()) {
                throw new SftpException(SftpException.SSH_FX_NO_SUCH_FILE);
            }
            this.sftpClient.rm(path);
        }
        catch (SftpException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SshException("Failed to create directory.", (Throwable)e);
        }
    }

    public void rmdir(String path) throws SshException {
        try {
            SftpFile file = this.stat(path);
            if (!file.isDirectory()) {
                throw new SftpException(SftpException.SSH_FX_NOT_A_DIRECTORY);
            }
            this.sftpClient.rm(path);
        }
        catch (SftpException e) {
            throw e;
        }
        catch (IOException e) {
            throw new SshException("Failed to create directory.", (Throwable)e);
        }
    }

    public SftpFile stat(String path) throws SshException {
        try {
            FileAttributes entry = this.sftpClient.stat(path);
            return this.entryToFile(path, entry);
        }
        catch (IOException e) {
            throw new SshException("Failed to create directory.", (Throwable)e);
        }
    }

    private SftpFile entryToFile(String path, FileAttributes entry) {
        return new SftpFile(this.convertType(entry), path, entry.getSize().longValue(), this.toLong(entry.getModifiedTime()), 0L, this.toLong(entry.getAccessedTime()), (int)this.toLong(entry.getGID()), (int)this.toLong(entry.getUID()), (int)this.toLong(entry.getPermissions()));
    }

    long toLong(UnsignedInteger32 i) {
        return i == null ? 0L : (long)i.intValue();
    }

    int toInt(Integer val) {
        return val == null ? 0 : val;
    }

    int convertType(FileAttributes attrs) {
        if (attrs.isDirectory()) {
            return 2;
        }
        if (attrs.isLink()) {
            return 3;
        }
        if (attrs.isFile()) {
            return 1;
        }
        if (attrs.isFifo()) {
            return 4;
        }
        if (attrs.isCharacter()) {
            return 7;
        }
        if (attrs.isBlock()) {
            return 8;
        }
        return 5;
    }

    public void get(String path, OutputStream out) throws SshException {
        try {
            this.sftpClient.get(path, out);
        }
        catch (IOException e) {
            throw new SshException("Failed to create directory.", (Throwable)e);
        }
    }

    public void put(String path, InputStream in, int permissions) throws SshException {
        try {
            this.sftpClient.put(in, path);
            this.sftpClient.chmod(permissions, path);
        }
        catch (IOException e) {
            throw new SshException("Failed to create directory.", (Throwable)e);
        }
    }

    public void chmod(String path, int permissions) throws SshException {
        try {
            this.sftpClient.chmod(permissions, path);
        }
        catch (IOException e) {
            throw new SshException("Failed to create directory.", (Throwable)e);
        }
    }

    public void rename(String path, String newPath) throws SshException {
        try {
            this.sftpClient.rename(path, newPath);
        }
        catch (IOException e) {
            throw new SshException("Failed to create directory.", (Throwable)e);
        }
    }

    public void chgrp(String path, int permissions) throws SshException {
        try {
            this.sftpClient.chgrp(permissions, path);
        }
        catch (IOException e) {
            throw new SshException("Failed to create directory.", (Throwable)e);
        }
    }

    public void chown(String path, int permissions) throws SshException {
        try {
            this.sftpClient.chown(permissions, path);
        }
        catch (IOException e) {
            throw new SshException("Failed to create directory.", (Throwable)e);
        }
    }

    public void setLastModified(String path, long modtime) throws SshException {
        throw new UnsupportedOperationException();
    }
}

