/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi.util;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import net.sf.sshapi.SshConfiguration;
import net.sf.sshapi.util.XAuthorityFile;

public class XDetails {
    private int x11Port;
    private String x11Host;
    private byte[] x11Cookie;

    public XDetails() throws IOException {
        this(XDetails.getDefaultXAuthorityFile(), System.getenv("DISPLAY"));
    }

    public XDetails(File xAuthorityFile, String display) throws IOException {
        String[] displayElements = display.split(":");
        String[] displayNumberElements = displayElements[1].split("\\.");
        int displayNumber = Integer.parseInt(displayNumberElements[0]);
        this.x11Host = displayElements[0];
        if (this.x11Host.equals("")) {
            this.x11Host = System.getenv("HOSTNAME");
            if (this.x11Host == null || this.x11Host.equals("")) {
                this.x11Host = InetAddress.getLocalHost().getHostName();
            }
        }
        this.x11Port = displayNumber + 6000;
        this.x11Cookie = null;
        if (xAuthorityFile.exists()) {
            XAuthorityFile af = new XAuthorityFile(xAuthorityFile, this.x11Host, displayNumber);
            this.x11Cookie = af.getData();
        }
    }

    private static File getDefaultXAuthorityFile() {
        String xauthorityFile = System.getenv("XAUTHORITY");
        File xAuthorityFile = new File(xauthorityFile);
        return xAuthorityFile;
    }

    public void configure(SshConfiguration configuration) {
        configuration.setX11Host(this.x11Host);
        configuration.setX11Port(this.x11Port);
        configuration.setX11Cookie(this.x11Cookie);
    }

    public int getX11Port() {
        return this.x11Port;
    }

    public String getX11Host() {
        return this.x11Host;
    }

    public byte[] getX11Cookie() {
        return this.x11Cookie;
    }

    public void setX11Cookie(byte[] x11Cookie) {
        this.x11Cookie = x11Cookie;
    }
}

