/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi.util;

import java.util.Arrays;
import net.sf.sshapi.SshException;
import net.sf.sshapi.hostkeys.SshHostKey;
import net.sf.sshapi.hostkeys.SshHostKeyManager;
import net.sf.sshapi.hostkeys.SshHostKeyValidator;
import net.sf.sshapi.util.Util;

public class ConsoleHostKeyValidator
implements SshHostKeyValidator {
    private SshHostKeyManager keyManager;

    public ConsoleHostKeyValidator() {
        this(null);
    }

    public ConsoleHostKeyValidator(SshHostKeyManager keyManager) {
        this.keyManager = keyManager;
    }

    public int verifyHost(SshHostKey hostKey) throws SshException {
        SshHostKey[] keys;
        String type = hostKey.getType().substring(4).toUpperCase();
        if (this.keyManager != null && (keys = this.keyManager.getKeysForHost(hostKey.getHost(), hostKey.getType())) != null && keys.length > 0) {
            for (int i = 0; i < keys.length; ++i) {
                if (!Arrays.equals(keys[i].getKey(), hostKey.getKey())) continue;
                return 0;
            }
            System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            System.out.println("@    WARNING: REMOTE HOST IDENTIFICATION HAS CHANGED!     @");
            System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            System.out.println("IT IS POSSIBLE THAT SOMEONE IS DOING SOMETHING NASTY!");
            System.out.println("Someone could be eavesdropping on you right now (man-in-the-middle attack)!");
            System.out.println("It is also possible that the " + type + " host key has just been changed.");
            System.out.println("The fingerprint for the " + type + " key sent by the remote host is");
            System.out.println(hostKey.getFingerprint() + ".");
            System.out.println("Please contact your system administrator.");
            System.out.println("Add correct host key to your known hosts database");
            return 3;
        }
        String message = "The authenticity of host '" + hostKey.getHost() + "' can't be established.\n";
        String keyAlgorithm = hostKey.getType();
        String hexFingerprint = hostKey.getFingerprint();
        boolean yes = Util.promptYesNo((message = message + (keyAlgorithm == null ? "?" : keyAlgorithm) + " key fingerprint is " + (hexFingerprint == null ? "unknown" : hexFingerprint)) + "\nAllow?");
        if (yes && this.keyManager != null) {
            this.keyManager.add(hostKey, true);
            System.out.println("Warning: Permanently added '" + hostKey.getHost() + "' (" + type + ") to the list of known hosts.");
        }
        return yes ? 0 : 2;
    }
}

