/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi.sftp;

import java.util.HashMap;
import java.util.Map;
import net.sf.sshapi.SshException;

public class SftpException
extends SshException {
    private static final long serialVersionUID = 1L;
    public static final SshException.Code SSH_FX_OK = new SftpCode("sftp.ok", 0);
    public static final SshException.Code SSH_FX_EOF = new SftpCode("sftp.eof", 1);
    public static final SshException.Code SSH_FX_NO_SUCH_FILE = new SftpCode("sftp.noSuchFile", 2);
    public static final SshException.Code SSH_FX_PERMISSION_DENIED = new SftpCode("sftp.permissionDenied", 3);
    public static final SshException.Code SSH_FX_FAILURE = new SftpCode("sftp.failure", 4);
    public static final SshException.Code SSH_FX_BAD_MESSAGE = new SftpCode("sftp.badMessage", 5);
    public static final SshException.Code SSH_FX_NO_CONNECTION = new SftpCode("sftp.noConnection", 6);
    public static final SshException.Code SSH_FX_CONNECTION_LOST = new SftpCode("sftp.connectionLost", 7);
    public static final SshException.Code SSH_FX_OP_UNSUPPORTED = new SftpCode("sftp.opUnsupported", 8);
    public static final SshException.Code SSH_FX_INVALID_HANDLE = new SftpCode("sftp.invalidHandle", 9);
    public static final SshException.Code SSH_FX_NO_SUCH_PATH = new SftpCode("sftp.noSuchPath", 10);
    public static final SshException.Code SSH_FX_FILE_ALREADY_EXISTS = new SftpCode("sftp.fileAlreadyExists", 11);
    public static final SshException.Code SSH_FX_WRITE_PROTECT = new SftpCode("sftp.writeProtect", 12);
    public static final SshException.Code SSH_FX_NO_MEDIA = new SftpCode("sftp.noMedia", 13);
    public static final SshException.Code SSH_FX_NO_SPACE_ON_FILESYSTEM = new SftpCode("sftp.noSpaceOnFileSystem", 14);
    public static final SshException.Code SSH_FX_QUOTA_EXCEEDED = new SftpCode("sftp.quoteExceeded", 15);
    public static final SshException.Code SSH_FX_UNKNOWN_PRINCIPAL = new SftpCode("sftp.unknownPrincipal", 16);
    public static final SshException.Code SSH_FX_LOCK_CONFLICT = new SftpCode("sftp.lockConflict", 17);
    public static final SshException.Code SSH_FX_DIR_NOT_EMPTY = new SftpCode("sftp.dirNotEmpty", 18);
    public static final SshException.Code SSH_FX_NOT_A_DIRECTORY = new SftpCode("sftp.notADirectory", 19);
    public static final SshException.Code SSH_FX_INVALID_FILENAME = new SftpCode("sftp.invalidFilename", 20);
    public static final SshException.Code SSH_FX_LINK_LOOP = new SftpCode("sftp.linkLoop", 21);
    public static final SshException.Code SSH_FX_CANNOT_DELETE = new SftpCode("sftp.cannotDelete", 22);
    public static final SshException.Code SSH_FX_INVALID_PARAMETER = new SftpCode("sftp.invalidParameter", 23);
    public static final SshException.Code SSH_FX_FILE_IS_A_DIRECTORY = new SftpCode("sftp.fileIsADirectory", 24);
    public static final SshException.Code SSH_FX_BYTE_RANGE_LOCK_CONFLICT = new SftpCode("sftp.byteRangeLockConflict", 25);
    public static final SshException.Code SSH_FX_BYTE_RANGE_LOCK_REFUSED = new SftpCode("sftp.byteRangeLockRefused", 26);
    public static final SshException.Code SSH_FX_DELETE_PENDING = new SftpCode("sftp.deletePending", 27);
    public static final SshException.Code SSH_FX_FILE_CORRUPT = new SftpCode("sftp.fileCorrupt", 28);
    public static final SshException.Code SSH_FX_OWNER_INVALID = new SftpCode("sftp.ownerInvalid", 29);
    public static final SshException.Code SSH_FX_GROUP_INVALID = new SftpCode("sftp.groupInvalid", 30);
    public static final SshException.Code SSH_FX_NO_MATCHING_BYTE_RANGE_LOCK = new SftpCode("sftp.noMatchingByteRangeLock", 31);
    private static Map codes;

    public SftpException(int serverErrorCode) {
        super(SftpException.getCodeForServerCode(serverErrorCode));
    }

    public SftpException(SshException.Code code) {
        super(code);
    }

    public SftpException(int serverErrorCode, String message) {
        super(SftpException.getCodeForServerCode(serverErrorCode), message);
    }

    public SftpException(int serverErrorCode, String message, Throwable cause) {
        super(SftpException.getCodeForServerCode(serverErrorCode), message, cause);
    }

    public static final SshException.Code getCodeForServerCode(int serverCode) {
        return (SshException.Code)codes.get(new Integer(serverCode));
    }

    public static class SftpCode
    extends SshException.Code {
        public SftpCode(String id, int serverCode) {
            super(id);
            if (codes == null) {
                codes = new HashMap();
            }
            codes.put(new Integer(serverCode), this);
        }
    }
}

