/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi.hostkeys;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import net.sf.sshapi.SshConfiguration;
import net.sf.sshapi.hostkeys.SshHostKey;
import net.sf.sshapi.hostkeys.SshHostKeyManager;

public abstract class AbstractHostKeyManager
implements SshHostKeyManager {
    protected static final String HASH_MAGIC = "|1|";
    protected static final String HASH_DELIM = "|";
    private final SshConfiguration configuration;

    public AbstractHostKeyManager(SshConfiguration configuration) {
        this.configuration = configuration;
    }

    protected SshConfiguration getConfiguration() {
        return this.configuration;
    }

    public final SshHostKey[] getKeysForHost(String host, String type) {
        SshHostKey[] hk = this.doGetKeysForHost(host, type);
        if (hk == null && "true".equals(this.configuration.getProperties().getProperty("sshapi.knownHosts.reverseDNS", "true"))) {
            try {
                InetAddress addr = InetAddress.getByName(host);
                hk = this.doGetKeysForHost(addr.getHostName(), type);
                if (hk == null) {
                    hk = this.doGetKeysForHost(addr.getCanonicalHostName(), type);
                }
                if (hk == null) {
                    hk = this.doGetKeysForHost(addr.getHostAddress(), type);
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return hk == null ? new SshHostKey[]{} : hk;
    }

    protected SshHostKey[] doGetKeysForHost(String host, String type) {
        SshHostKey[] keys = this.getKeys();
        ArrayList<SshHostKey> hostKeys = new ArrayList<SshHostKey>();
        for (int i = 0; i < keys.length; ++i) {
            if (!this.checkHost(keys[i].getHost(), host) || type != null && !type.equals(keys[i].getType())) continue;
            hostKeys.add(keys[i]);
        }
        return hostKeys.toArray(new SshHostKey[0]);
    }

    protected boolean checkHost(String storedHostName, String hostToCheck) {
        return storedHostName.equals(hostToCheck);
    }
}

