/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.sshapi.Capability;
import net.sf.sshapi.Logger;
import net.sf.sshapi.SshConfiguration;
import net.sf.sshapi.SshProvider;
import net.sf.sshapi.SshProviderFactory;

public class DefaultProviderFactory
implements SshProviderFactory {
    public static final String PROVIDER_CLASS_NAME = "net.sf.sshapi.provider";
    private static final String FACTORY_CLASS_NAME = "net.sf.sshapi.factory";
    private static ClassLoader providerClassLoader = null;
    private static final Map providerCache = new HashMap();

    public static SshProviderFactory getInstance() {
        return DefaultClientFactoryHolder.instance;
    }

    public static SshProvider[] getAllProviders() {
        ArrayList providers = new ArrayList();
        ClassLoader cl = DefaultProviderFactory.getClassLoader();
        try {
            Enumeration<URL> e = cl.getResources("sshapi-providers.properties");
            while (e.hasMoreElements()) {
                try {
                    DefaultProviderFactory.addIfNotExist(providers, e);
                }
                catch (UnsatisfiedLinkError ule) {
                    System.out.println("WARNING: Provider requires a native library but it could not be found." + ule.getMessage());
                }
                catch (Exception ex) {
                    System.out.println("WARNING: Provider failed to load. " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Could not discover providers.", ioe);
        }
        return providers.toArray(new SshProvider[providers.size()]);
    }

    private static void addIfNotExist(List providers, Enumeration e) throws IOException {
        SshProvider provider = DefaultProviderFactory.loadFromProperties((URL)e.nextElement());
        if (provider != null && !providers.contains(provider)) {
            providers.add(provider);
        }
    }

    public static Capability[] getAllCapabilties() {
        ArrayList<Capability> capabilties = new ArrayList<Capability>();
        SshProvider[] providers = DefaultProviderFactory.getAllProviders();
        for (int i = 0; i < providers.length; ++i) {
            List c = providers[i].getCapabilities();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Capability cap = (Capability)it.next();
                if (capabilties.contains(cap)) continue;
                capabilties.add(cap);
            }
        }
        return capabilties.toArray(new Capability[0]);
    }

    public static String[] getAllCiphers() {
        ArrayList ciphers = new ArrayList();
        SshProvider[] providers = DefaultProviderFactory.getAllProviders();
        for (int i = 0; i < providers.length; ++i) {
            try {
                List c = providers[i].getSupportedCiphers(3);
                DefaultProviderFactory.addList(ciphers, c);
                continue;
            }
            catch (UnsatisfiedLinkError ule) {
                System.out.println("WARNING: Provider requires a native library but it could not be found." + ule.getMessage());
                continue;
            }
            catch (Exception ex) {
                System.out.println("WARNING: Provider failed to load. " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return ciphers.toArray(new String[0]);
    }

    public static String[] getAllKEX() {
        ArrayList kex = new ArrayList();
        SshProvider[] providers = DefaultProviderFactory.getAllProviders();
        for (int i = 0; i < providers.length; ++i) {
            try {
                List c = providers[i].getSupportedKeyExchange();
                DefaultProviderFactory.addList(kex, c);
                continue;
            }
            catch (UnsatisfiedLinkError ule) {
                System.out.println("WARNING: Provider requires a native library but it could not be found." + ule.getMessage());
                continue;
            }
            catch (Exception ex) {
                System.out.println("WARNING: Provider failed to load. " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return kex.toArray(new String[0]);
    }

    public static String[] getAllCompression() {
        ArrayList comp = new ArrayList();
        SshProvider[] providers = DefaultProviderFactory.getAllProviders();
        for (int i = 0; i < providers.length; ++i) {
            try {
                List c = providers[i].getSupportedCompression();
                DefaultProviderFactory.addList(comp, c);
                continue;
            }
            catch (UnsatisfiedLinkError ule) {
                System.out.println("WARNING: Provider requires a native library but it could not be found." + ule.getMessage());
                continue;
            }
            catch (Exception ex) {
                System.out.println("WARNING: Provider failed to load. " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return comp.toArray(new String[0]);
    }

    public static String[] getAllMAC() {
        ArrayList mac = new ArrayList();
        SshProvider[] providers = DefaultProviderFactory.getAllProviders();
        for (int i = 0; i < providers.length; ++i) {
            try {
                List c = providers[i].getSupportedMAC();
                DefaultProviderFactory.addList(mac, c);
                continue;
            }
            catch (UnsatisfiedLinkError ule) {
                System.out.println("WARNING: Provider requires a native library but it could not be found." + ule.getMessage());
                continue;
            }
            catch (Exception ex) {
                System.out.println("WARNING: Provider failed to load. " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return mac.toArray(new String[0]);
    }

    public static SshProvider getProviderByName(String providerName) {
        SshProvider[] providers = DefaultProviderFactory.getAllProviders();
        for (int i = 0; i < providers.length; ++i) {
            if (!providers[i].getName().equals(providerName)) continue;
            return providers[i];
        }
        throw new IllegalArgumentException("No provider named " + providerName);
    }

    public static String[] getAllPublicKey() {
        ArrayList pk = new ArrayList();
        SshProvider[] providers = DefaultProviderFactory.getAllProviders();
        for (int i = 0; i < providers.length; ++i) {
            try {
                List c = providers[i].getSupportedPublicKey();
                DefaultProviderFactory.addList(pk, c);
                continue;
            }
            catch (UnsatisfiedLinkError ule) {
                System.out.println("WARNING: Provider requires a native library but it could not be found." + ule.getMessage());
                continue;
            }
            catch (Exception ex) {
                System.out.println("WARNING: Provider failed to load. " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return pk.toArray(new String[0]);
    }

    private static void addList(List kex, List c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            String cap = (String)it.next();
            if (kex.contains(cap)) continue;
            kex.add(cap);
        }
    }

    public SshProvider getProvider() {
        return this.getProvider(null);
    }

    public SshProvider getProvider(SshConfiguration configuration) {
        SshProvider provider = DefaultProviderFactory.loadFromProperties(System.getProperties());
        if (provider != null && !provider.supportsConfiguration(null)) {
            throw new UnsupportedOperationException("The provider " + provider.getClass().getName() + " requires configuration. Use createClient(SshConfiguration) instead or use a different provider.");
        }
        if (provider == null) {
            ClassLoader cl = DefaultProviderFactory.getClassLoader();
            try {
                SshConfiguration.getLogger().log(Logger.Level.INFO, "Looking for sshapi-providers.properties resources.");
                Enumeration<URL> e = cl.getResources("sshapi-providers.properties");
                while (e.hasMoreElements() && provider == null) {
                    SshProvider possibleProvider = DefaultProviderFactory.loadFromProperties(e.nextElement());
                    if (possibleProvider == null) continue;
                    if (possibleProvider.supportsConfiguration(configuration)) {
                        SshConfiguration.getLogger().log(Logger.Level.INFO, "Provider supports configuration.");
                        provider = possibleProvider;
                        continue;
                    }
                    SshConfiguration.getLogger().log(Logger.Level.INFO, "Provider DOES NOT support configuration.");
                }
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Could not discover providers.", ioe);
            }
        }
        if (provider == null) {
            throw new IllegalStateException("No working SSH providers were found on the classpath.");
        }
        return provider;
    }

    public static void setProviderClassLoader(ClassLoader classLoader) {
        providerClassLoader = classLoader;
    }

    protected static final SshProvider createProviderInstance(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        try {
            SshConfiguration.getLogger().log(Logger.Level.INFO, "Attempting to load provider " + className + ".");
            SshProvider provider = (SshProvider)Class.forName(className, true, DefaultProviderFactory.getClassLoader()).newInstance();
            SshConfiguration.getLogger().log(Logger.Level.INFO, "Provider " + className + " loaded.");
            return provider;
        }
        catch (InstantiationException ie) {
            if (ie.getCause() != null && ie.getCause() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)ie.getCause();
            }
            throw ie;
        }
    }

    protected static final ClassLoader getClassLoader() {
        ClassLoader classLoader = providerClassLoader;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = DefaultProviderFactory.class.getClassLoader();
        }
        return classLoader;
    }

    protected static final SshProvider loadFromProperties(URL resource) throws IOException {
        SshConfiguration.getLogger().log(Logger.Level.INFO, "Loading " + resource + ".");
        return DefaultProviderFactory.loadFromProperties(DefaultProviderFactory.loadProperties(resource));
    }

    protected static final SshProvider loadFromProperties(Properties properties) {
        String requestedProviderClassName = properties.getProperty(PROVIDER_CLASS_NAME);
        if (requestedProviderClassName != null && requestedProviderClassName.length() > 0) {
            if (providerCache.containsKey(requestedProviderClassName)) {
                return (SshProvider)providerCache.get(requestedProviderClassName);
            }
            String dependsOn = properties.getProperty(requestedProviderClassName + ".dependsOn", "");
            if (!dependsOn.equals("")) {
                try {
                    Class.forName(dependsOn, true, DefaultProviderFactory.getClassLoader());
                }
                catch (ClassNotFoundException cnfe) {
                    SshConfiguration.getLogger().log(Logger.Level.WARN, "The provider " + requestedProviderClassName + " was found, but a class it depends on (" + dependsOn + ", does not exist. Probably caused by a missing dependency.");
                    return null;
                }
            }
            try {
                SshProvider provider = DefaultProviderFactory.createProviderInstance(requestedProviderClassName);
                providerCache.put(requestedProviderClassName, provider);
                return provider;
            }
            catch (NoClassDefFoundError ncdfe) {
                SshConfiguration.getLogger().log(Logger.Level.WARN, "Could not load provider " + requestedProviderClassName + ". Probably cause by a missing dependency.");
            }
            catch (Exception e) {
                SshConfiguration.getLogger().log(Logger.Level.WARN, "Could not load provider " + requestedProviderClassName + ". " + e.getLocalizedMessage());
            }
        }
        return null;
    }

    protected static final Properties loadProperties(URL resource) throws IOException {
        Properties properties = new Properties();
        InputStream in = resource.openStream();
        try {
            properties.load(in);
        }
        finally {
            in.close();
        }
        return properties;
    }

    private static class DefaultClientFactoryHolder {
        private static final SshProviderFactory instance = DefaultClientFactoryHolder.createInstance();

        private DefaultClientFactoryHolder() {
        }

        private static SshProviderFactory createInstance() {
            String factoryClassName = System.getProperty(DefaultProviderFactory.FACTORY_CLASS_NAME, (class$net$sf$sshapi$DefaultProviderFactory == null ? (class$net$sf$sshapi$DefaultProviderFactory = DefaultProviderFactory.class$("net.sf.sshapi.DefaultProviderFactory")) : class$net$sf$sshapi$DefaultProviderFactory).getName());
            try {
                Constructor<?> c = Class.forName(factoryClassName).getConstructor(new Class[0]);
                c.setAccessible(true);
                return (SshProviderFactory)c.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create SSH client factory.", e);
            }
        }
    }
}

