/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.sshapi.AbstractLifecycleComponentWithEvents;
import net.sf.sshapi.SshFileTransferListener;

public abstract class AbstractFileTransferClient
extends AbstractLifecycleComponentWithEvents {
    private List fileTransferListeners;

    public final synchronized void addFileTransferListener(SshFileTransferListener listener) {
        if (this.fileTransferListeners == null) {
            this.fileTransferListeners = new ArrayList();
        }
        this.fileTransferListeners.add(listener);
    }

    public final synchronized void removeFileTransferListener(SshFileTransferListener listener) {
        if (this.fileTransferListeners != null) {
            this.fileTransferListeners.remove(listener);
        }
    }

    protected void fireFileTransferStarted(String path, String targetPath, long length) {
        if (this.fileTransferListeners != null) {
            Iterator i = new ArrayList(this.fileTransferListeners).iterator();
            while (i.hasNext()) {
                ((SshFileTransferListener)i.next()).startedTransfer(path, targetPath, length);
            }
        }
    }

    protected void fireFileTransferProgressed(String path, String targetPath, long progress) {
        if (this.fileTransferListeners != null) {
            Iterator i = new ArrayList(this.fileTransferListeners).iterator();
            while (i.hasNext()) {
                ((SshFileTransferListener)i.next()).transferProgress(path, targetPath, progress);
            }
        }
    }

    protected void fireFileTransferFinished(String path, String targetPath) {
        if (this.fileTransferListeners != null) {
            Iterator i = new ArrayList(this.fileTransferListeners).iterator();
            while (i.hasNext()) {
                ((SshFileTransferListener)i.next()).finishedTransfer(path, targetPath);
            }
        }
    }
}

